//      

#include "stdafx.h"
#include "Poligon.h"
#include "CustomPropertyGridProperty.h"
#include "IntelligenceDefaultsPage.h"
#include "afxdialogex.h"

IMPLEMENT_DYNAMIC( CIntelligenceDefaultsPage, CMFCPropertyPage )

BEGIN_MESSAGE_MAP( CIntelligenceDefaultsPage, CMFCPropertyPage )
	ON_REGISTERED_MESSAGE( AFX_WM_PROPERTY_CHANGED, &OnAfxWmPropertyChanged )
	ON_REGISTERED_MESSAGE( MM_NEED_TO_NOTIFY, &OnMmNeedToNotify )
	ON_WM_SIZE()
END_MESSAGE_MAP()

CIntelligenceDefaultsPage::CIntelligenceDefaultsPage() : CMFCPropertyPage( IDD ), 
	ddeRunning( false ), ddeDisable( false )
{
}

void CIntelligenceDefaultsPage::DoDataExchange( CDataExchange* pDX )
{
	CAutoSwitcher<bool> switcher( ddeRunning, true );

	CMFCPropertyPage::DoDataExchange( pDX );
	if( ddeDisable ) {
		return;
	}

	if( pDX->m_bSaveAndValidate ) {
		m_wndPropList.EndEditItem();
		if( !controls.Validate() ) {
			pDX->Fail();
		}
		
		controls.SaveToRegistry();
		SetModified( false );
	} else {
		if( controls.OptimizedReceptorResolution != 0 ) {
			controls.LoadFromRegistry();
		}
	}
}

BOOL CIntelligenceDefaultsPage::OnApply()
{
	ASSERT_VALID( this );

	if ( !UpdateData() ) {
		TRACE( traceAppMsg, 0, L"!\n" );
		return FALSE;
	}
	return TRUE;
}

BOOL CIntelligenceDefaultsPage::OnSetActive()
{
	CAutoSwitcher<bool> switcher( ddeDisable, true );

	return CMFCPropertyPage::OnSetActive();
}

BOOL CIntelligenceDefaultsPage::OnKillActive()
{
	ASSERT_VALID(this);
	CAutoSwitcher<bool> switcher( ddeDisable, true );

	return CMFCPropertyPage::OnKillActive() && controls.Validate();
}

BOOL CIntelligenceDefaultsPage::OnInitDialog()
{
	CRect rectPropList;
	GetClientRect( &rectPropList );

	m_wndPropList.Create( WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_BORDER, rectPropList, this, 0xffffffff );

	m_wndPropList.EnableHeaderCtrl();
	m_wndPropList.EnableDescriptionArea();
	m_wndPropList.SetVSDotNetLook( true );
	m_wndPropList.MarkModifiedProperties( true );

	m_wndPropList.SetAlphabeticMode( false );
	m_wndPropList.SetShowDragContext( false );

	controls.CreateGridPropertiesDefault( m_wndPropList, this );

	CMFCPropertyPage::OnInitDialog();

	return TRUE;  // return TRUE unless you set the focus to a control
	// :   OCX    FALSE
}

afx_msg LRESULT CIntelligenceDefaultsPage::OnAfxWmPropertyChanged( WPARAM wParam, LPARAM lParam )
{
	CMFCPropertyGridProperty* propertyPtr = reinterpret_cast<CMFCPropertyGridProperty*>( lParam );
	static bool recursion = false;
	
	SetModified( true );
	if( !recursion && !ddeRunning ) {
		CAutoSwitcher<bool> switcher( recursion, true );
		controls.EmulateActivity( m_wndPropList, propertyPtr );
	}

	return 0;
}

//	    
afx_msg LRESULT CIntelligenceDefaultsPage::OnMmNeedToNotify( WPARAM wParam, LPARAM lParam )
{
	CMFCPropertyGridProperty* propertyPtr = reinterpret_cast<CMFCPropertyGridProperty*>( wParam );
	SetFocus();
	m_wndPropList.EnsureVisible( propertyPtr, TRUE );
	m_wndPropList.SetCurSel( propertyPtr );
	return 0;
}

void CIntelligenceDefaultsPage::OnSize( UINT nType, int cx, int cy )
{
	CMFCPropertyPage::OnSize( nType, cx, cy );

	CWnd* parentWnd = GetParent();
	assert( parentWnd != 0 );
	if( m_wndPropList.GetSafeHwnd() != 0 ) {

		CRect rectPropList;
		GetClientRect( &rectPropList );
		CRect rectParent;
		parentWnd->GetClientRect( &rectParent );
		parentWnd->MapWindowPoints( this, &rectParent );
		rectPropList &= rectParent;

		m_wndPropList.SetWindowPos( 0, rectPropList.left, rectPropList.top, rectPropList.Width(), rectPropList.Height(), 
			SWP_NOZORDER | SWP_NOOWNERZORDER | SWP_NOACTIVATE | SWP_NOCOPYBITS );
	}
}
