#pragma once

#include "IntelligenceInterface.h"
//  CIntelligence

class CIntelligence : public CDocument, public IIntelligenceInterface {
	DECLARE_DYNCREATE(CIntelligence)
public:
	CIntelligence();
	virtual ~CIntelligence();

	typedef std::vector<double> TDistributionType;	//	   
	typedef std::vector<int> TIoLimitsContainer;	//	     IO 

	const TDistributionType& GetOptimizedReceptorWeights() const { return optimizedReceptorWeights; }
	const TIoLimitsContainer& GetReceptorsLimits() const { return receptorsLimits; }
	const TIoLimitsContainer& GetEffectorsLimits() const { return effectorsLimits; }

	virtual void DeleteContents();

	//	IIntelligenceInterfaceV01
	virtual void TimeStep( const TIoDataContainer& receptors, TIoDataContainer& effectors );


#ifndef _WIN32_WCE
	virtual void Serialize(CArchive& ar);   //   / 
#endif
#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

protected:
	DECLARE_MESSAGE_MAP()

private:
	TIoLimitsContainer receptorsLimits;
	TIoLimitsContainer effectorsLimits;
	TDistributionType optimizedReceptorWeights;

	typedef std::vector<TDistributionType> TDistributionsContainer;	//	   
	//	   
	struct CCluster {
		CCluster() : Weight( 0. ), Expectation( 0. ) {}
		CCluster( int receptorsCount, int effectorsCount );

		TDistributionsContainer ReceptorsStatistics;
		TDistributionsContainer EffectorsStatistics;
		TDistributionType ContextStatistics;
		TDistributionType::value_type Weight;
		TDistributionType::value_type Expectation;
	};

	friend CArchive& operator << ( CArchive& ar, const CIntelligence::CCluster& data );
	friend CArchive& operator >> ( CArchive& ar, CIntelligence::CCluster& data );

	typedef std::vector<CCluster> TClustersContainer;
	TClustersContainer worldModel;
	TDistributionType context;
	TIoDataContainer prevStepEffectors;

	//	    
	struct CEffectorVariant {
		CEffectorVariant( TDistributionType::value_type likelihood, int testedStateIndex,
			TIoDataContainer::value_type variant );

		TDistributionType::value_type Likelihood;
		int TestedStateIndex;
		TIoDataContainer::value_type Variant;
	};

	//	 
	struct CEffectorVariantComparer : public std::binary_function<CEffectorVariant, CEffectorVariant, bool> {
		bool operator() ( const CEffectorVariant& left, const CEffectorVariant& right ) const;
	};

	//	  
	typedef std::vector< std::priority_queue<CEffectorVariant, std::vector<CEffectorVariant>,
		CEffectorVariantComparer> > TVariantQueuesContainer;

	//	   
	typedef std::vector< std::vector<bool> > TVariantsContainer;
	class CEffectorsTestedState {
	public:
		CEffectorsTestedState( const TIoDataContainer& effectors, const TIoLimitsContainer& limits );
		//	  
		CEffectorsTestedState( CEffectorsTestedState& baseState,
			int effectorIndex, TIoDataContainer::value_type newVariant );
		const TIoDataContainer& Effectors() const { return effectors; }
		const TVariantsContainer& TestedVariants() const { return testedVariants; }

	private:
		TVariantsContainer testedVariants;	//	 
		TIoDataContainer effectors;	//	 
	};
	typedef std::vector<CEffectorsTestedState> TTestedStatesContainer;

	void calculateNextStepContext( const TIoDataContainer& receptors, TDistributionType& adArchive ) const;
	void updateStatistics( const TIoDataContainer& receptors, const TDistributionType& adArchive );
	void findBestReaction( const TDistributionType& adArchive, TIoDataContainer& effectors ) const;
	void prepareClustersLikelihoods( TDistributionType& clustersLikelihood,
		const TDistributionType& adArchive ) const;
	void prepareFirstApproximation( TIoDataContainer& firstApproximation,
		const TDistributionType& clustersLikelihood ) const;
	TDistributionType::value_type prepareVariant( TDistributionType& preservedLikelihoods,
		const TDistributionType& clustersLikelihood, const TIoDataContainer& firstApproximation ) const;
	void effectorVariantsGenerator( TVariantQueuesContainer& queues,
		const TDistributionType& preservedLikelihoods, const TTestedStatesContainer& lastState ) const;
};

inline CIntelligence::CEffectorVariant::CEffectorVariant( TDistributionType::value_type likelihood,
	int testedStateIndex, TIoDataContainer::value_type variant ) :
	Likelihood( likelihood ), TestedStateIndex( testedStateIndex ), Variant( variant )
{
}

inline bool CIntelligence::CEffectorVariantComparer::operator()(
	const CEffectorVariant& left, const CEffectorVariant& right) const
{
	return left.Likelihood < right.Likelihood;
}
