//	 
#pragma once

enum TCustolPropertyValueType {
	CPV_IntValType,
	CPV_DoubleValType
};

class CCustomPropertyGridProperty : public CMFCPropertyGridProperty {
public:
	CCustomPropertyGridProperty( const CString& description, const COleVariant& initVal,  
		CWnd* parent = 0, const CString& registryKey = L"", const CString& registryValue = L"" );
	CCustomPropertyGridProperty( const CString& description, bool isValueList,  
		CWnd* parent = 0, const CString& registryKey = L"", const CString& registryValue = L"" );
	virtual ~CCustomPropertyGridProperty() {}

	virtual bool Validate( bool silent = false ) = 0;
	virtual void LoadFromRegistry( bool silent = false ) = 0;
	virtual void SaveToRegistry() const = 0;

	virtual void SetRawName( const CString& _rawName ) { SetName( _rawName ); }
	virtual void SetRawDescription( const CString& _rawDescription ) { SetDescription( _rawDescription ); }
	virtual void SetRawErrorPrompt( const CString& _rawErrorPrompt ) { rawErrorPrompt = _rawErrorPrompt; }

	void SetRegistryKey( const CString& _registryKey ) { registryKey = _registryKey; }
	void SetRegistryValue( const CString& _registryValue ) { registryValue = _registryValue; }
	void SetParent( CWnd* _parent ) { parent = _parent; }

protected:
	CString registryKey;
	CString registryValue;
	CString rawName;
	CString rawDescription;
	CString rawErrorPrompt;
	CWnd* parent;
};

class CBoundedPropertyGridProperty : public CCustomPropertyGridProperty {
public:
	CBoundedPropertyGridProperty( const CString& description, int defValue, int minVal, int maxVal, 
		CWnd* parent = 0, const CString& registryKey = L"", const CString& registryValue = L"" );
	CBoundedPropertyGridProperty( const CString& description, double defValue, double minVal, double maxVal, 
		CWnd* parent = 0, const CString& registryKey = L"", const CString& registryValue = L"" );
	virtual ~CBoundedPropertyGridProperty() {}

	virtual bool Validate( bool silent = false );
	virtual void LoadFromRegistry( bool silent = false );
	virtual void SaveToRegistry() const;

	virtual void SetRawDescription( const CString& _rawDescription );
	virtual BOOL OnUpdateValue();

	TCustolPropertyValueType ValType() const { return valType; }

	int GetIntValue() const { assert( m_varValue.vt == VT_I4 ); return m_varValue.lVal; }
	double GetDoubleValue() const { assert( m_varValue.vt == VT_R8 ); return m_varValue.dblVal; }
	void SetValue( int data, bool updateDefault = false, bool silent = false );
	void SetValue( double data, bool updateDefault = false, bool silent = false );

	void SetMaxValue( int value );
	void SetMaxValue( double value );
	void SetMinValue( int value );
	void SetMinValue( double value );

private:
	COleVariant minVal;
	COleVariant maxVal;
	const TCustolPropertyValueType valType;
};

class CBoundedPropertyGridVectorProperty : public CCustomPropertyGridProperty {
public:
	CBoundedPropertyGridVectorProperty( const CString& description, const CString& childDescription, 
		const std::vector<int>& defValues, int minVal, int maxVal, CWnd* parent = 0, 
		const CString& registryKey = L"", const CString& registryValue = L"" );
	CBoundedPropertyGridVectorProperty( const CString& description, const CString& childDescription, 
		const std::vector<double>& defValue, double minVal, double maxVal, CWnd* parent = 0, 
		const CString& registryKey = L"", const CString& registryValue = L"" );
	virtual ~CBoundedPropertyGridVectorProperty() {}

	virtual bool Validate( bool silent = false );
	virtual void LoadFromRegistry( bool silent = false );
	virtual void SaveToRegistry() const;

	virtual void SetRawDescription( const CString& rawDescription );
	void SetChildDescription( const CString& childDescription );
	TCustolPropertyValueType ValType() const { return valType; }

	int GetIntValue( int index ) const { return children[index]->GetIntValue(); }
	double GetDoubleValue( int index ) const { return children[index]->GetDoubleValue(); }
	int GetChildrenCount() const { return children.size(); }
	void GetValues( std::vector<int>& values ) const;
	void GetValues( std::vector<double>& values ) const;
	void SetValues( const std::vector<int>& values );
	void SetValues( const std::vector<double>& values );
	void SetNewCount( int newCount, int defValue );
	void SetNewCount( int newCount, double defValue );

	void SetMaxValue( int value );
	void SetMaxValue( double value );
	void SetMinValue( int value );
	void SetMinValue( double value );

private:
	COleVariant minVal;
	COleVariant maxVal;
	CString childDescription;
	const TCustolPropertyValueType valType;
	typedef std::vector<CBoundedPropertyGridProperty*> TChidrenContainer;
	TChidrenContainer children;

	void addChild( int newValue );
	void addChild( double newValue );
	void removeChild();
};