//	 
#include "stdafx.h"
#include "Poligon.h"
#include "CustomPropertyGridProperty.h"

const wchar_t tokSep[] = L"\n";

CCustomPropertyGridProperty::CCustomPropertyGridProperty( const CString& description, 
	const COleVariant& initVal,	CWnd* _parent, const CString& _registryKey, const CString& _registryValue ) :
	CMFCPropertyGridProperty( L"dummyName", initVal ), parent( _parent ), 
	registryKey( _registryKey ), registryValue( _registryValue )
{
	int iStart = 0;
	rawName = description.Tokenize( tokSep, iStart );
	rawDescription = description.Tokenize( tokSep, iStart );
	rawErrorPrompt = description.Tokenize( tokSep, iStart );
	SetName( rawName );
}

CCustomPropertyGridProperty::CCustomPropertyGridProperty( const CString& description, bool isValueList,  
	CWnd* _parent, const CString& _registryKey, const CString& _registryValue ) :
	CMFCPropertyGridProperty( L"dummyName", 0, isValueList ), parent( _parent ), 
	registryKey( _registryKey ), registryValue( _registryValue )
{
	int iStart = 0;
	rawName = description.Tokenize( tokSep, iStart );
	rawDescription = description.Tokenize( tokSep, iStart );
	rawErrorPrompt = description.Tokenize( tokSep, iStart );
	SetName( rawName );
}

//---------------------------------------------------------------------------------------------------------------------
CBoundedPropertyGridProperty::CBoundedPropertyGridProperty( const CString& description, int defVal, int _minVal, 
	int _maxVal, CWnd* parent, const CString& registryKey, const CString& registryValue ) :
	CCustomPropertyGridProperty( description, COleVariant( long( defVal ) ), parent, registryKey, registryValue ),
	minVal( long( _minVal ) ), maxVal( long( _maxVal ) ), valType( CPV_IntValType )
{
	CMFCPropertyGridProperty::EnableSpinControl( TRUE, _minVal, _maxVal );
	SetRawDescription( rawDescription );
}

CBoundedPropertyGridProperty::CBoundedPropertyGridProperty( const CString& description, double defVal, double _minVal, 
	double _maxVal, CWnd* parent, const CString& registryKey, const CString& registryValue ) :
	CCustomPropertyGridProperty( description, COleVariant( defVal ), parent, registryKey, registryValue ),
	minVal( _minVal ), maxVal( _maxVal ), valType( CPV_DoubleValType )
{
	SetRawDescription( rawDescription );
}

bool CBoundedPropertyGridProperty::Validate( bool silent )
{
	bool success = true;
	switch( valType ) {
		case CPV_IntValType:
			assert( m_varValue.vt == VT_I4 );
			success = m_varValue.lVal >= minVal.lVal && m_varValue.lVal <= maxVal.lVal;
			break;
		case CPV_DoubleValType:
			assert( m_varValue.vt == VT_R8 );
			success = m_varValue.dblVal >= minVal.dblVal && m_varValue.dblVal <= maxVal.dblVal;
			break; 
		default:
			assert( false );
	}

	if( silent ) {
		return success;
	}

	if ( !success ) {
		static BOOL bRecursedHere = FALSE;
		if( bRecursedHere ) {
			return true;
		}
		bRecursedHere = TRUE;

		CString string = rawErrorPrompt;
		string.Replace( L"%0", CString( minVal ) );
		string.Replace( L"%1", CString( maxVal ) );

		AfxMessageBox( string, MB_ICONEXCLAMATION );
		if( parent != 0 ) {
			parent->PostMessage( MM_NEED_TO_NOTIFY, reinterpret_cast<WPARAM>( 
				static_cast<CMFCPropertyGridProperty*>( this ) ) );
		}

		bRecursedHere = FALSE;
		return false;
	}

	return true;
}

void CBoundedPropertyGridProperty::LoadFromRegistry( bool silent )
{
	assert( !registryKey.IsEmpty() );
	assert( !registryValue.IsEmpty() );
	CString valueString = theApp.GetProfileString( registryKey, registryValue, FormatProperty() );
	switch( valType ) {
		case CPV_IntValType: 
			SetValue( _ttol( valueString ), true, silent );
			break;
		case CPV_DoubleValType: {
			SetValue( _wtof( valueString ), true, silent );
			break; }
		default:
			assert( false );
	}
}

void CBoundedPropertyGridProperty::SaveToRegistry() const
{
	assert( !registryKey.IsEmpty() );
	assert( !registryValue.IsEmpty() );
	theApp.WriteProfileString( registryKey, registryValue, CString( GetValue() ) );
}

void CBoundedPropertyGridProperty::SetValue( int data, bool updateDefault, bool updateSilent ) 
{ 
	assert( valType == CPV_IntValType ); 
	if( updateSilent ) {
		m_varValue = long( data );
	} else {
		CMFCPropertyGridProperty::SetValue( long( data ) );
	}
	if( updateDefault ) {
		CMFCPropertyGridProperty::SetOriginalValue( GetValue() );
	}
}

void CBoundedPropertyGridProperty::SetValue( double data, bool updateDefault, bool updateSilent ) 
{ 
	assert( valType == CPV_DoubleValType ); 
	if( updateSilent ) {
		m_varValue = data;
	} else {
		CMFCPropertyGridProperty::SetValue( data ); 
	}
	if( updateDefault ) {
		CMFCPropertyGridProperty::SetOriginalValue( GetValue() );
	}
}

void CBoundedPropertyGridProperty::SetMaxValue( int value )
{
	assert( valType == CPV_IntValType ); 
	maxVal = long( value );
	SetRawDescription( rawDescription );
}

void CBoundedPropertyGridProperty::SetMaxValue( double value )
{
	assert( valType == CPV_DoubleValType ); 
	maxVal = value;
	SetRawDescription( rawDescription );
}

void CBoundedPropertyGridProperty::SetMinValue( int value )
{
	assert( valType == CPV_IntValType); 
	minVal = long( value );
	SetRawDescription( rawDescription );
}

void CBoundedPropertyGridProperty::SetMinValue( double value )
{
	assert( valType == CPV_DoubleValType ); 
	minVal = value;
	SetRawDescription( rawDescription );
}

void CBoundedPropertyGridProperty::SetRawDescription( const CString& _rawDescription )
{
	rawDescription = _rawDescription;
	CString description = rawDescription;
	description.Replace( L"%0", CString( minVal ) );
	description.Replace( L"%1", CString( maxVal ) );
	CMFCPropertyGridProperty::SetDescription( description );
}

BOOL CBoundedPropertyGridProperty::OnUpdateValue()
{
	ASSERT_VALID( this );
	ASSERT_VALID( m_pWndInPlace );
	ASSERT_VALID( m_pWndList );
	ASSERT( ::IsWindow( m_pWndInPlace->GetSafeHwnd() ) );

	BOOL bRet = TRUE;
	CString strText;
	m_pWndInPlace->GetWindowText( strText );

	BOOL bIsChanged = FormatProperty() != strText;
	if( bIsChanged ) {
		bRet = CMFCPropertyGridProperty::OnUpdateValue();

		if( m_pParent != NULL ) {
			m_pWndList->OnPropertyChanged(m_pParent);
		}
	}

	return bRet;
}

//---------------------------------------------------------------------------------------------------------------------
CBoundedPropertyGridVectorProperty::CBoundedPropertyGridVectorProperty( 
	const CString& description, const CString& _childDescription, 
	const std::vector<int>& defValues, int _minVal, int _maxVal, CWnd* parent, 
	const CString& registryKey, const CString& registryValue ) :
	CCustomPropertyGridProperty( description, true, parent, registryKey + L"\\" + registryValue, RegistryArrayCountName ),
	minVal( long( _minVal ) ), maxVal( long( _maxVal ) ), valType( CPV_IntValType ),
	childDescription( _childDescription )
{
	SetRawDescription( rawDescription );
	SetValues( defValues );
}

CBoundedPropertyGridVectorProperty::CBoundedPropertyGridVectorProperty( 
	const CString& description, const CString& _childDescription, 
	const std::vector<double>& defValues, double _minVal, double _maxVal, CWnd* parent, 
	const CString& registryKey, const CString& registryValue ) :
	CCustomPropertyGridProperty( description, true, parent, registryKey + L"\\" + registryValue, RegistryArrayCountName ),
	minVal( _minVal ), maxVal( _maxVal ), valType( CPV_DoubleValType ),
	childDescription( _childDescription )
{
	SetRawDescription( rawDescription );
	SetValues( defValues );
}

bool CBoundedPropertyGridVectorProperty::Validate( bool silent )
{
	TChidrenContainer::iterator child = children.begin();
	for( ; child != children.end(); ++child ) {
		if( !( *child )->Validate( silent ) ) {
			return false;
		}
	}
	return true;
}

void CBoundedPropertyGridVectorProperty::LoadFromRegistry( bool silent )
{
	assert( !registryKey.IsEmpty() );
	assert( !registryValue.IsEmpty() );

	switch( valType ) {
		case CPV_IntValType: {
			std::vector<int> values;
			GetValues( values );
			LoadArrayFromRegistry( registryKey, values );
			SetValues( values );
			break; }
		case CPV_DoubleValType: {
			std::vector<double> values;
			GetValues( values );
			LoadArrayFromRegistry( registryKey, values );
			SetValues( values );
			break; }
		default:
			assert( false );
	}
	/*	 
	const int childrenSize = children.size();
	int count = theApp.GetProfileInt( registryKey, registryValue, childrenSize );

	if( count > childrenSize ) {
		switch( valType ) {
			case CPV_IntValType: {
				for( int i = count - childrenSize; i > 0; i-- ) {
					addChild( int( 0 ) );
				}
				break; }
			case CPV_DoubleValType: {
				for( int i = count - childrenSize; i > 0; i-- ) {
					addChild( double( 0. ) );
				}
				break; }
			default:
				assert( false );
		}
	} else if( count < childrenSize ) {
		for( int i = childrenSize - count; i > 0; i-- ) {
			addChild( double( 0. ) );
		}
	}
	
	TChidrenContainer::iterator child = children.begin();
	for( ; child != children.end(); ++child ) {
		( *child )->LoadFromRegistry( silent );
	}
	*/
}

void CBoundedPropertyGridVectorProperty::SaveToRegistry() const
{
	assert( !registryKey.IsEmpty() );
	assert( !registryValue.IsEmpty() );

	switch( valType ) {
		case CPV_IntValType: {
			std::vector<int> values;
			GetValues( values );
			SaveArrayToRegistry( registryKey, values );
			break; }
		case CPV_DoubleValType: {
			std::vector<double> values;
			GetValues( values );
			SaveArrayToRegistry( registryKey, values );
			break; }
		default:
			assert( false );
	}

/*	 
	theApp.WriteProfileInt( registryKey, registryValue, children.size() );

	TChidrenContainer::const_iterator child = children.begin();
	for( ; child != children.end(); ++child ) {
		( *child )->SaveToRegistry();
	}*/
}

void CBoundedPropertyGridVectorProperty::SetRawDescription( const CString& _rawDescription )
{
	rawDescription = _rawDescription;
	CString description = rawDescription;
	description.Replace( L"%0", CString( minVal ) );
	description.Replace( L"%1", CString( maxVal ) );
	CMFCPropertyGridProperty::SetDescription( description );
}

void CBoundedPropertyGridVectorProperty::SetChildDescription( const CString& _childDescription )
{
	childDescription = _childDescription;

	TChidrenContainer::const_iterator child = children.begin();
	for( int index = 0 ; child != children.end(); ++child, ++index ) {
		CString indexStr;
		indexStr.Format( L"%d", index );

		CString description = childDescription;
		description.Replace( L"%2", indexStr );

		( *child )->SetRawDescription( description );
	}
}

void CBoundedPropertyGridVectorProperty::GetValues( std::vector<int>& values ) const
{
	values.clear();
	TChidrenContainer::const_iterator child = children.begin();
	for( ; child != children.end(); ++child ) {
		values.push_back( ( *child )->GetIntValue() );
	}
}

void CBoundedPropertyGridVectorProperty::GetValues( std::vector<double>& values ) const
{
	values.clear();
	TChidrenContainer::const_iterator child = children.begin();
	for( ; child != children.end(); ++child ) {
		values.push_back( ( *child )->GetDoubleValue() );
	}
}

void CBoundedPropertyGridVectorProperty::SetValues( const std::vector<int>& values )
{
	assert( valType == CPV_IntValType );

	TChidrenContainer::iterator child = children.begin();
	std::vector<int>::const_iterator source = values.begin();
	for( ; child != children.end() && source != values.end(); ++child, ++source ) {
		( *child )->SetValue( *source, false, true );
	}

	for( ; source != values.end(); ++source ) {
		addChild( *source );
	}

	for( size_t i = children.size() - values.size(); i > 0; i-- ) {
		removeChild();
	}
}

void CBoundedPropertyGridVectorProperty::SetValues( const std::vector<double>& values )
{
	assert( valType == CPV_DoubleValType );

	TChidrenContainer::iterator child = children.begin();
	std::vector<double>::const_iterator source = values.begin();
	for( ; child != children.end() && source != values.end(); ++child, ++source ) {
		( *child )->SetValue( *source, false, true );
	}

	for( ; source != values.end(); ++source ) {
		addChild( *source );
	}

	for( size_t i = children.size() - values.size(); i > 0; i-- ) {
		removeChild();
	}
}

void CBoundedPropertyGridVectorProperty::SetNewCount( int newCount, int defValue )
{
	assert( valType == CPV_IntValType );

	const size_t childrenSize = children.size();
	for( int i = newCount - childrenSize; i > 0; i-- ) {
		addChild( defValue );
	}

	for( int i = childrenSize - newCount; i > 0; i-- ) {
		removeChild();
	}
}

void CBoundedPropertyGridVectorProperty::SetNewCount( int newCount, double defValue )
{
	assert( valType == CPV_DoubleValType );

	const size_t childrenSize = children.size();
	for( int i = newCount - childrenSize; i > 0; i-- ) {
		addChild( defValue );
	}

	for( int i = childrenSize - newCount; i > 0; i-- ) {
		removeChild();
	}
}

void CBoundedPropertyGridVectorProperty::SetMaxValue( int value )
{
	assert( valType == CPV_IntValType ); 
	maxVal = long( value );
	SetRawDescription( rawDescription );

	TChidrenContainer::iterator child = children.begin();
	for( ; child != children.end(); ++child ) {
		( *child )->SetMaxValue( value );
	}
}

void CBoundedPropertyGridVectorProperty::SetMaxValue( double value )
{
	assert( valType == CPV_DoubleValType ); 
	maxVal = value;
	SetRawDescription( rawDescription );

	TChidrenContainer::iterator child = children.begin();
	for( ; child != children.end(); ++child ) {
		( *child )->SetMaxValue( value );
	}
}

void CBoundedPropertyGridVectorProperty::SetMinValue( int value )
{
	assert( valType == CPV_IntValType); 
	minVal = long( value );
	SetRawDescription( rawDescription );

	TChidrenContainer::iterator child = children.begin();
	for( ; child != children.end(); ++child ) {
		( *child )->SetMinValue( value );
	}
}

void CBoundedPropertyGridVectorProperty::SetMinValue( double value )
{
	assert( valType == CPV_DoubleValType ); 
	minVal = value;
	SetRawDescription( rawDescription );

	TChidrenContainer::iterator child = children.begin();
	for( ; child != children.end(); ++child ) {
		( *child )->SetMinValue( value );
	}
}

void CBoundedPropertyGridVectorProperty::addChild( int newValue )
{
	assert( CPV_IntValType == valType );

	CString indexStr;
	indexStr.Format( L"%d", children.size() );

	CString newDescription = childDescription;
	newDescription.Replace( L"%2", indexStr );

	CString newRegisrtyValue = RegistryArrayElementName + indexStr;

	TChidrenContainer::value_type newChild = new CBoundedPropertyGridProperty( newDescription, newValue,
		minVal.lVal, maxVal.lVal, parent, registryKey, newRegisrtyValue );

	children.push_back( newChild );
	CMFCPropertyGridProperty::AddSubItem( newChild );
}

void CBoundedPropertyGridVectorProperty::addChild( double newValue )
{
	assert( CPV_DoubleValType == valType );
		
	CString indexStr;
	indexStr.Format( L"%d", children.size() );

	CString newDescription = childDescription;
	newDescription.Replace( L"%2", indexStr );

	CString newRegisrtyValue = RegistryArrayElementName + indexStr;

	TChidrenContainer::value_type newChild = new CBoundedPropertyGridProperty( newDescription, newValue,
		minVal.dblVal, maxVal.dblVal, parent, registryKey, newRegisrtyValue );

	children.push_back( newChild );
	CMFCPropertyGridProperty::AddSubItem( newChild );
}

void CBoundedPropertyGridVectorProperty::removeChild()
{
	CMFCPropertyGridProperty* deleted = children.back();
	CMFCPropertyGridProperty::RemoveSubItem( deleted );
	children.pop_back();
}