package org.jamocha.service;

import java.util.ArrayList;

import woolfel.examples.model.Hobby;

import junit.framework.TestCase;

public class ServiceConfigTest extends TestCase {
	public ServiceConfigTest() {
		super();
	}
	
	public void testSaveServiceConfig() {
		ServiceConfiguration config = new ServiceConfiguration();
		config.setServiceName("sample");
		RuleApplicationImpl app1 = new RuleApplicationImpl();
		config.setApplications(new ArrayList());
		config.getApplications().add(app1);
		app1.setMinPool(1);
		app1.setMaxPool(10);
		app1.setInitialPool(1);
		app1.setName("test");
		app1.setVersion("1.0");
		
		app1.setFunctionGroups(new ArrayList());
		app1.setInitialData(new ArrayList());
		app1.setRulesets(new ArrayList());
		app1.setModels(new ArrayList());
		
		ObjectModel model1 = new ObjectModel();
		app1.getModels().add(model1);
		ArrayList classList = new ArrayList();
		model1.setClassList(classList);
		classList.add("woolfel.examples.model.Account");
		classList.add("woolfel.examples.model.Account2");
		
		FunctionPackage functionGroup = new FunctionPackage();
		app1.getFunctionGroups().add(functionGroup);
		String[] functionList = new String[]{"woolfel.examples.function.HellFunction"};
		functionGroup.setClassNames(functionList);
		
		ClipsRuleset ruleset1 = new ClipsRuleset();
		app1.getRulesets().add(ruleset1);
		ruleset1.setURL("./samples/join_sample1.clp");
		
		ClipsInitialData initialData1 = new ClipsInitialData();
		app1.getInitialData().add(initialData1);
		initialData1.setURL("./samples/data/data.dat");
		
		RuleServiceImpl.saveConfiguration("./samples/configuration/test_config.xml", config);
	}
	
	public void testSaveServiceConfig2() {
		ServiceConfiguration config = new ServiceConfiguration();
		config.setServiceName("sample");
		RuleApplicationImpl app1 = new RuleApplicationImpl();
		config.setApplications(new ArrayList());
		config.getApplications().add(app1);
		app1.setMinPool(1);
		app1.setMaxPool(10);
		app1.setInitialPool(1);
		app1.setName("test");
		app1.setVersion("1.0");
		
		app1.setFunctionGroups(new ArrayList());
		app1.setInitialData(new ArrayList());
		app1.setRulesets(new ArrayList());
		app1.setModels(new ArrayList());
		
		ObjectModel model1 = new ObjectModel();
		app1.getModels().add(model1);
		ArrayList classList = new ArrayList();
		model1.setClassList(classList);
		classList.add("woolfel.examples.model.Account");
		classList.add("woolfel.examples.model.Account2");
		
		FunctionPackage functionGroup = new FunctionPackage();
		app1.getFunctionGroups().add(functionGroup);
		String[] functionList = new String[]{"woolfel.examples.function.HellFunction"};
		functionGroup.setClassNames(functionList);
		
		ClipsRuleset ruleset1 = new ClipsRuleset();
		app1.getRulesets().add(ruleset1);
		ruleset1.setURL("./samples/join_sample1.clp");
		
		ClipsInitialData initialData1 = new ClipsInitialData();
		app1.getInitialData().add(initialData1);
		initialData1.setURL("./samples/data/data.dat");
		
		ObjectData objectData1 = new ObjectData();
		objectData1.setName("generic");
		app1.getInitialData().add(objectData1);
		objectData1.setUrl("./samples/data/hobbies.xml");
		
		RuleServiceImpl.saveConfiguration("./samples/configuration/test_config2.xml", config);
	}
	
	public void testSaveObjectData() {
		ArrayList list = new ArrayList();
		Hobby hobby1 = new Hobby();
		list.add(hobby1);
		hobby1.setName("Hiking");
		hobby1.setHobbyCode("0101");
		hobby1.setCategory("Sport");
		hobby1.setSubCategory("Outdoor");
		
		Hobby hobby2 = new Hobby();
		list.add(hobby2);
		hobby2.setName("Climbing");
		hobby2.setHobbyCode("0201");
		hobby2.setCategory("Sport");
		hobby2.setSubCategory("Outdoor");
		
		Hobby hobby3 = new Hobby();
		list.add(hobby3);
		hobby3.setName("Swimming");
		hobby3.setCategory("Sport");
		hobby3.setSubCategory("Indoor/Outdoor");
		
		ObjectData.saveObjectData("./samples/data/data1.xml", list);
	}
	
	public void testCreateServiceInstance() {
		RuleService service = RuleServiceImpl.createInstance("./samples/configuration/sample_config.xml");
		assertNotNull(service);
		System.out.println(service.getServiceName());
		assertNotNull(service.getServiceName());
	}
}
