/*
 * Copyright 2002-2010 Peter Lin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://ruleml-dev.sourceforge.net/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

package org.jamocha.service.servlet;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.jamocha.service.ServiceConfiguration;
import org.jamocha.xml.ConfigurationHandler;
import org.xml.sax.SAXException;

public class SAXStartupService extends RuleStartupService {

	public SAXStartupService() {
		super();
	}

	protected ServiceConfiguration loadConfiguration() {
		if (this.serviceConfiguration == null) {
			String path = "/WEB-INF/" + CONFIGURATION_FILE;
			this.servletContext.log("Path: " + path);
			ConfigurationHandler handler = new ConfigurationHandler();
			InputStream input = this.servletContext.getResourceAsStream(path);
			SAXParser parser;
			try {
				parser = SAXParserFactory.newInstance().newSAXParser();
				parser.parse(input, handler);
				this.serviceConfiguration = handler.getServiceConfiguration();
			} catch (ParserConfigurationException e) {
				this.servletContext.log(e.getMessage());
			} catch (SAXException e) {
				this.servletContext.log(e.getMessage());
			} catch (IOException e) {
				this.servletContext.log(e.getMessage());
			}
			return this.serviceConfiguration;
		} else {
			return this.serviceConfiguration;
		}
	}
}
