/*
 * Copyright 2002-2009 Peter Lin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://ruleml-dev.sourceforge.net/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package org.jamocha.rete;

/**
 * The only difference between a Function and RuleFunction is a rule
 * function has 1 addtional setTriggerFacts(Fact[]) method. This is
 * used to pass the facts that triggered a rule to the function. A
 * normal function doesn't need the Fact[] array to execute.
 * 
 * @author Peter Lin
 */
public interface RuleFunction extends Function {
	void setTriggerFacts(Fact[] facts);
}
