/*
 * Copyright 2002-2006 Peter Lin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://ruleml-dev.sourceforge.net/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package org.jamocha.rete;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * @author Peter Lin
 *
 * Messages is a basic resource bundle. It's responsible for getting
 * the error messages and other resource bundle related values.
 */
public class Messages {
	private static final String BUNDLE_NAME = "org.jamocha.rete.messages";//$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle
			.getBundle(BUNDLE_NAME);

	private Messages() {
	}

	public static String getString(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}
	
	public static boolean getBooleanProperty(String key) {
		String val = getString(key);
		if (val.equals("true")) {
			return true;
		} else {
			return false;
		}
	}
}
