/* Generated By:JavaCC: Do not edit this line. CLIPSParser.java */
package org.jamocha.parser.clips;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Defcube;
import org.jamocha.rete.Defdimension;
import org.jamocha.rete.Defmeasure;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.MultiSlot;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.ParameterUtils;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ShellBoundParam;
import org.jamocha.rete.Slot;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.functions.ShellFunction;
import org.jamocha.rule.Action;
import org.jamocha.rule.AndCondition;
import org.jamocha.rule.AndLiteralConstraint;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.Defrule;
import org.jamocha.rule.Defquery;
import org.jamocha.rule.ExistCondition;
import org.jamocha.rule.FunctionAction;
import org.jamocha.rule.LiteralConstraint;
import org.jamocha.rule.MultiValue;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.OrLiteralConstraint;
import org.jamocha.rule.PredicateConstraint;
import org.jamocha.rule.RuleProperty;
import org.jamocha.rule.CubeQueryCondition;
import org.jamocha.rule.TestCondition;
import org.jamocha.rule.TemporalCondition;
import org.jamocha.rete.functions.DeffunctionFunction;

public class CLIPSParser implements CLIPSParserConstants {

    protected Rete engine = null;

    public CLIPSParser(Rete eng, Reader stream) {
        this(stream);
        engine = eng;
    }

    public CLIPSParser(Rete eng, InputStream stream) {
        this(new InputStreamReader(stream));
        engine = eng;
    }

    public void close() {
        engine = null;
        if (token != null) {
            token.clear();
            token = null;
        }
        if (jj_nt != null) {
            jj_nt.clear();
            jj_nt = null;
        }
        if (jj_scanpos != null) {
            jj_scanpos.clear();
            jj_scanpos = null;
        }
        if (jj_lastpos != null) {
            jj_lastpos.clear();
            jj_lastpos = null;
        }
        try {
            jj_input_stream.inputStream.close();
        } catch (IOException e) {
            // later on log the error
        }
    }

  final public Object basicExpr() throws ParseException {
  Object exp = null;
  Token obj = null;
  ShellFunction func = null;
  Parameter[] pms = null;
  ShellBoundParam sbp = null;
  ArrayList list = new ArrayList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BIND:
    case BIND3:
    case BIND4:
      obj = getBindType();
    func = new ShellFunction();
    func.setName("echo");
    sbp = new ShellBoundParam();
    sbp.setDefglobalName(obj.image);
    pms = new ShellBoundParam[]{sbp};
    func.setParameters(pms);
    {if (true) return func;}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      exp = expr();
      jj_consume_token(RBRACE);
    {if (true) return exp;}
      break;
    case STRING_LITERAL:
    case IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        obj = jj_consume_token(IDENTIFIER);
        break;
      case STRING_LITERAL:
        obj = jj_consume_token(STRING_LITERAL);
        break;
      default:
        jj_la1[0] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    {if (true) return ParserUtils.getStringLiteral(obj.image);}
      break;
    case 0:
      jj_consume_token(0);
    {if (true) return null;}
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// main expression for loading a data file
  final public List loadExpr() throws ParseException {
  ArrayList facts = new ArrayList();
    label_1:
    while (true) {
      loadAllExpr(facts);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
    }
    {if (true) return facts;}
    throw new Error("Missing return statement in function");
  }

// this method is used to load data
  final public void loadAllExpr(List list) throws ParseException {
  ValueParam[] param = null;
    param = assertBody();
    list.add(param);
  }

  final public Object streamExpr() throws ParseException {
  ValueParam[] param = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      param = assertBody();
    {if (true) return param;}
      break;
    case 0:
      jj_consume_token(0);
    {if (true) return null;}
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// typeExpr is only responsible for parsing string and bigdecimal types
  final public Object typeExpr() throws ParseException {
  Token exp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      exp = jj_consume_token(STRING_LITERAL);
    String strlit = exp.image;
    strlit = ParserUtils.getStringLiteral(strlit);
    {if (true) return strlit;}
      break;
    case INTEGER_LITERAL:
      exp = jj_consume_token(INTEGER_LITERAL);
    // we use BigDecimal
    {if (true) return new BigDecimal(exp.image);}
      break;
    case FLOATING_POINT_LITERAL:
      exp = jj_consume_token(FLOATING_POINT_LITERAL);
    // we use float, double
    {if (true) return new BigDecimal(exp.image);}
      break;
    case PATH_LITERAL:
      exp = jj_consume_token(PATH_LITERAL);
    {if (true) return exp.image;}
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Object expr() throws ParseException {
  Token exp = null;
  Token exp2 = null;
  Token exp3 = null;
  String body;
  ValueParam param;
  Deffact fact;
  Deftemplate templ;
  Defrule rule;
  Defquery query;
  Defcube cube;
  ShellFunction func;
  DeffunctionFunction dffunc;
  ArrayList list = new ArrayList();
  ValueParam[] pms;
  List infunc = new ArrayList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSERT:
      exp = jj_consume_token(ASSERT);
      jj_consume_token(LBRACE);
      exp2 = jj_consume_token(IDENTIFIER);
      label_2:
      while (true) {
        assertContents(list);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[5] = jj_gen;
          break label_2;
        }
      }
      jj_consume_token(RBRACE);
    func = new ShellFunction();
    func.setName(exp.image);
    pms = new ValueParam[2];
    pms[0] = new ValueParam(Constants.STRING_TYPE,exp2.image);
    pms[1] = new ValueParam(Constants.OBJECT_TYPE,list.toArray());
    func.setParameters(pms);
    exp.clear();
    exp = null;
    {if (true) return func;}
      break;
    case ASSERTTEMPORAL:
      exp = jj_consume_token(ASSERTTEMPORAL);
      jj_consume_token(LBRACE);
      exp2 = jj_consume_token(IDENTIFIER);
      label_3:
      while (true) {
        assertContents(list);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[6] = jj_gen;
          break label_3;
        }
      }
      jj_consume_token(RBRACE);
    func = new ShellFunction();
    func.setName(exp.image);
    pms = new ValueParam[2];
    pms[0] = new ValueParam(Constants.STRING_TYPE,exp2.image);
    pms[1] = new ValueParam(Constants.OBJECT_TYPE,list.toArray());
    func.setParameters(pms);
    exp.clear();
    exp = null;
    {if (true) return func;}
      break;
    case RETRACT:
      exp = jj_consume_token(RETRACT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIND:
        exp2 = jj_consume_token(BIND);
        break;
      case INTEGER_LITERAL:
        exp2 = jj_consume_token(INTEGER_LITERAL);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    func = new ShellFunction();
    func.setName(exp.image);
    Parameter[] rpms = new Parameter[1];
    if (exp2.image.startsWith("?")) {
      BoundParam bp = new BoundParam();
      bp.setVariableName(exp2.image);
      rpms[0] = bp;
    } else {
      ValueParam vp = new ValueParam(Constants.BIG_DECIMAL, new BigDecimal(exp2.image));
      rpms[0] = vp;
    }
    func.setParameters(rpms);
    exp.clear();
    exp = null;
    exp2.clear();
    exp2 = null;
    {if (true) return func;}
      break;
    case MODIFY:
      exp = jj_consume_token(MODIFY);
      exp2 = jj_consume_token(BIND);
      label_4:
      while (true) {
        assertContents(list);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_4;
        }
      }
    func = new ShellFunction();
    func.setName(exp.image);
    BoundParam bp = new BoundParam();
    bp.setVariableName(exp2.image);
    list.add(0,bp);
    func.setParameters(ParameterUtils.slotToParameters(list));
    exp.clear();
    exp = null;
    {if (true) return func;}
      break;
    case DEFTEMPLATE:
      exp = jj_consume_token(DEFTEMPLATE);
      templ = templateExpr();
    func = new ShellFunction();
    func.setName(exp.image);
    pms = new ValueParam[1];
    pms[0] = new ValueParam(Constants.OBJECT_TYPE,templ);
    func.setParameters(pms);
    {if (true) return func;}
      break;
    case DEFCUBE:
      exp = jj_consume_token(DEFCUBE);
      cube = cubeExpr();
    func = new ShellFunction();
    func.setName(exp.image);
    pms = new ValueParam[1];
    pms[0] = new ValueParam(Constants.OBJECT_TYPE,cube);
    func.setParameters(pms);
    {if (true) return func;}
      break;
    case DEFMODULE:
      exp = jj_consume_token(DEFMODULE);
      body = getIdentifier();
    func = new ShellFunction();
    func.setName(exp.image);
    pms = new ValueParam[1];
    pms[0] = new ValueParam(Constants.STRING_TYPE,body);
    func.setParameters(pms);
    {if (true) return func;}
      break;
    case DEFRULE:
      exp = jj_consume_token(DEFRULE);
      rule = ruleBody();
    func = new ShellFunction();
    func.setName(exp.image);
    pms = new ValueParam[1];
    pms[0] = new ValueParam(Constants.OBJECT_TYPE,rule);
    func.setParameters(pms);
    {if (true) return func;}
      break;
    case DEFQUERY:
      exp = jj_consume_token(DEFQUERY);
      query = queryBody();
    func = new ShellFunction();
    func.setName(exp.image);
    pms = new ValueParam[1];
    pms[0] = new ValueParam(Constants.OBJECT_TYPE,query);
    func.setParameters(pms);
    {if (true) return func;}
      break;
    case DEFCLASS:
      exp = jj_consume_token(DEFCLASS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case BIND:
      case BIND3:
      case BIND4:
      case TRUE:
      case TRUE2:
      case FALSE:
      case FALSE2:
      case IDENTIFIER:
      case PATH_LITERAL:
        label_5:
        while (true) {
          valueParams(list);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case STRING_LITERAL:
          case BIND:
          case BIND3:
          case BIND4:
          case TRUE:
          case TRUE2:
          case FALSE:
          case FALSE2:
          case IDENTIFIER:
          case PATH_LITERAL:
            ;
            break;
          default:
            jj_la1[9] = jj_gen;
            break label_5;
          }
        }
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
    func = new ShellFunction();
    func.setName(exp.image);
    func.setParameters(ParameterUtils.convertParameters(list));
    list.clear();
    {if (true) return func;}
      break;
    case DEFFUNCTION:
      exp = jj_consume_token(DEFFUNCTION);
      exp2 = jj_consume_token(IDENTIFIER);
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIND:
      case BIND3:
      case BIND4:
        label_6:
        while (true) {
          bindingParams(list);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BIND:
          case BIND3:
          case BIND4:
            ;
            break;
          default:
            jj_la1[11] = jj_gen;
            break label_6;
          }
        }
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BINDING:
      case ASSERT:
      case ASSERTTEMPORAL:
      case DEFCLASS:
      case DEFCUBE:
      case DEFFUNCTION:
      case DEFMODULE:
      case DEFRULE:
      case DEFQUERY:
      case DEFTEMPLATE:
      case MODIFY:
      case NOTCE:
      case RETRACT:
      case PLUS:
      case MINUS:
      case MULTIPLY:
      case DIVIDE:
      case GT1:
      case LT1:
      case EQ1:
      case EQ2:
      case LE1:
      case GE1:
      case NE1:
      case AND1:
      case OR1:
      case IDENTIFIER:
        ruleAction(infunc);
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    dffunc = new DeffunctionFunction();
    dffunc.setName(exp2.image);
    dffunc.setParameters(ParameterUtils.convertParameters(list));
    dffunc.setFunction(infunc);
    list.clear();
    {if (true) return dffunc;}
      break;
    case BINDING:
      jj_consume_token(BINDING);
      exp = getBindType();
      label_7:
      while (true) {
        valueParams(list);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case BIND:
        case BIND3:
        case BIND4:
        case TRUE:
        case TRUE2:
        case FALSE:
        case FALSE2:
        case IDENTIFIER:
        case PATH_LITERAL:
          ;
          break;
        default:
          jj_la1[14] = jj_gen;
          break label_7;
        }
      }
    func = new ShellFunction();
    func.setName("bind");
    list.add(0,new ValueParam(Constants.STRING_TYPE,exp.image.substring(1)));
    func.setParameters(ParameterUtils.convertParameters(list));
    list.clear();
    {if (true) return func;}
      break;
    case NOTCE:
    case PLUS:
    case MINUS:
    case MULTIPLY:
    case DIVIDE:
    case GT1:
    case LT1:
    case EQ1:
    case EQ2:
    case LE1:
    case GE1:
    case NE1:
    case AND1:
    case OR1:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        exp = jj_consume_token(PLUS);
        break;
      case MINUS:
        exp = jj_consume_token(MINUS);
        break;
      case MULTIPLY:
        exp = jj_consume_token(MULTIPLY);
        break;
      case DIVIDE:
        exp = jj_consume_token(DIVIDE);
        break;
      case GT1:
        exp = jj_consume_token(GT1);
        break;
      case LT1:
        exp = jj_consume_token(LT1);
        break;
      case EQ1:
        exp = jj_consume_token(EQ1);
        break;
      case EQ2:
        exp = jj_consume_token(EQ2);
        break;
      case LE1:
        exp = jj_consume_token(LE1);
        break;
      case GE1:
        exp = jj_consume_token(GE1);
        break;
      case NE1:
        exp = jj_consume_token(NE1);
        break;
      case OR1:
        exp = jj_consume_token(OR1);
        break;
      case AND1:
        exp = jj_consume_token(AND1);
        break;
      case NOTCE:
        exp = jj_consume_token(NOTCE);
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_8:
      while (true) {
        valueParams(list);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case BIND:
        case BIND3:
        case BIND4:
        case TRUE:
        case TRUE2:
        case FALSE:
        case FALSE2:
        case IDENTIFIER:
        case PATH_LITERAL:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_8;
        }
      }
    func = new ShellFunction();
    func.setName(exp.image);
    func.setParameters(ParameterUtils.convertParameters(list));
    list.clear();
    {if (true) return func;}
      break;
    case IDENTIFIER:
      exp = jj_consume_token(IDENTIFIER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case BIND:
      case BIND3:
      case BIND4:
      case TRUE:
      case TRUE2:
      case FALSE:
      case FALSE2:
      case IDENTIFIER:
      case PATH_LITERAL:
        label_9:
        while (true) {
          valueParams(list);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case STRING_LITERAL:
          case BIND:
          case BIND3:
          case BIND4:
          case TRUE:
          case TRUE2:
          case FALSE:
          case FALSE2:
          case IDENTIFIER:
          case PATH_LITERAL:
            ;
            break;
          default:
            jj_la1[17] = jj_gen;
            break label_9;
          }
        }
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
    func = new ShellFunction();
    func.setName(exp.image);
    func.setParameters(ParameterUtils.convertParameters(list));
    list.clear();
    {if (true) return func;}
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void valueParams(List list) throws ParseException {
  Object exp;
  Token tok;
  ValueParam vp = null;
    if (jj_2_1(2147483647)) {
      jj_consume_token(LBRACE);
      exp = expr();
      jj_consume_token(RBRACE);
    ShellFunction subfunc = (ShellFunction)exp;
    FunctionParam2 fp2 = new FunctionParam2();
    fp2.setFunctionName(subfunc.getName());
    fp2.setEngine(engine);
    fp2.setParameters(subfunc.getParameters());
    list.add(fp2);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case PATH_LITERAL:
        exp = typeExpr();
    vp = new ValueParam();
      vp.setValue(exp);
    if (exp instanceof BigDecimal) {
      vp.setValueType(Constants.BIG_DECIMAL);
    } else if (exp instanceof String) {
      vp.setValueType(Constants.STRING_TYPE);
    }
    list.add(vp);
        break;
      case IDENTIFIER:
        exp = jj_consume_token(IDENTIFIER);
    vp = new ValueParam();
    vp.setValueType(Constants.STRING_TYPE);
    if (exp instanceof Token) {
      vp.setValue( ((Token)exp).image );
    } else {
      vp.setValue(exp);
    }
    list.add(vp);
        break;
      case TRUE:
        exp = jj_consume_token(TRUE);
    vp = new ValueParam();
    vp.setValue(new Boolean(true));
    list.add(vp);
        break;
      case TRUE2:
        exp = jj_consume_token(TRUE2);
    vp = new ValueParam();
    vp.setValue(new Boolean(true));
    list.add(vp);
        break;
      case FALSE:
        exp = jj_consume_token(FALSE);
    vp = new ValueParam();
    vp.setValue(new Boolean(false));
    list.add(vp);
        break;
      case FALSE2:
        exp = jj_consume_token(FALSE2);
    vp = new ValueParam();
    vp.setValue(new Boolean(false));
    list.add(vp);
        break;
      case BIND:
      case BIND3:
      case BIND4:
        // in some cases, the parameters may be a binding to a variable
          tok = getBindType();
    BoundParam bp = new BoundParam();
    if (tok.kind == CLIPSParserConstants.BIND4) {
      bp.setVariableName(tok.image.substring(2));
      bp.setIsMultislot(true);
    } else {
      bp.setVariableName(tok.image);
    }
    list.add(bp);
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
 * bindingParams is meant to parse the params for a deffunction
 */
  final public void bindingParams(List list) throws ParseException {
  Object exp;
  Token tok;
  ValueParam vp = null;
    tok = getBindType();
    BoundParam bp = new BoundParam();
    if (tok.kind == CLIPSParserConstants.BIND4) {
      bp.setVariableName(tok.image.substring(2));
      bp.setIsMultislot(true);
    } else {
      bp.setVariableName(tok.image);
    }
    list.add(bp);
  }

  final public Token getBindType() throws ParseException {
  Token exp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BIND3:
      exp = jj_consume_token(BIND3);
    {if (true) return exp;}
      break;
    case BIND:
      exp = jj_consume_token(BIND);
    {if (true) return exp;}
      break;
    case BIND4:
      exp = jj_consume_token(BIND4);
    {if (true) return exp;}
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * this is for convienance
 */
  final public String getIdentifier() throws ParseException {
  Token exp;
    exp = jj_consume_token(IDENTIFIER);
    {if (true) return exp.image;}
    throw new Error("Missing return statement in function");
  }

  final public ValueParam[] assertBody() throws ParseException {
  Token exp;
  List tokens = new ArrayList();
  ValueParam[] param = null;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(IDENTIFIER);
    label_10:
    while (true) {
      assertContents(tokens);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        ;
        break;
      default:
        jj_la1[22] = jj_gen;
        break label_10;
      }
    }
    jj_consume_token(RBRACE);
    param = new ValueParam[2];
    param[0] = new ValueParam(Constants.STRING_TYPE,exp.image);
    param[1] = new ValueParam(Constants.OBJECT_TYPE,tokens.toArray());
    tokens.clear();
    exp = null;
    {if (true) return param;}
    throw new Error("Missing return statement in function");
  }

/* assert body */
  final public void assertContents(List tokens) throws ParseException {
  Token exp;
  Object body = null;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case BIND:
    case BIND3:
    case BIND4:
    case TRUE:
    case TRUE2:
    case FALSE:
    case FALSE2:
    case IDENTIFIER:
    case PATH_LITERAL:
      body = checkMultiSlot();
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    if (body != null) {
      if (body instanceof Object[]) {
        MultiSlot msl = new MultiSlot(exp.image);
        msl.setValue(body);
        tokens.add(msl);
      } else {
        Slot s = new Slot(exp.image);
        s.setValue(body);
        tokens.add(s);
      }
    }
    exp.clear();
    exp = null;
    body = null;
  }

  final public Object checkMultiSlot() throws ParseException {
  Object body;
  ArrayList artokens = new ArrayList();
    if (jj_2_2(2147483647)) {
      label_11:
      while (true) {
        arrayType(artokens);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case BIND:
        case BIND3:
        case IDENTIFIER:
        case PATH_LITERAL:
          ;
          break;
        default:
          jj_la1[24] = jj_gen;
          break label_11;
        }
      }
    {if (true) return artokens.toArray();}
    } else if (jj_2_3(2147483647)) {
      label_12:
      while (true) {
        arrayType(artokens);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case BIND:
        case BIND3:
        case IDENTIFIER:
        case PATH_LITERAL:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_12;
        }
      }
    {if (true) return artokens.toArray();}
    } else if (jj_2_4(2147483647)) {
      label_13:
      while (true) {
        arrayType(artokens);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case BIND:
        case BIND3:
        case IDENTIFIER:
        case PATH_LITERAL:
          ;
          break;
        default:
          jj_la1[26] = jj_gen;
          break label_13;
        }
      }
    {if (true) return artokens.toArray();}
    } else if (jj_2_5(2147483647)) {
      label_14:
      while (true) {
        arrayType(artokens);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case BIND:
        case BIND3:
        case IDENTIFIER:
        case PATH_LITERAL:
          ;
          break;
        default:
          jj_la1[27] = jj_gen;
          break label_14;
        }
      }
    {if (true) return artokens.toArray();}
    } else if (jj_2_6(2147483647)) {
      label_15:
      while (true) {
        arrayType(artokens);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case BIND:
        case BIND3:
        case IDENTIFIER:
        case PATH_LITERAL:
          ;
          break;
        default:
          jj_la1[28] = jj_gen;
          break label_15;
        }
      }
    {if (true) return artokens.toArray();}
    } else if (jj_2_7(2147483647)) {
      label_16:
      while (true) {
        arrayType(artokens);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case STRING_LITERAL:
        case BIND:
        case BIND3:
        case IDENTIFIER:
        case PATH_LITERAL:
          ;
          break;
        default:
          jj_la1[29] = jj_gen;
          break label_16;
        }
      }
    {if (true) return artokens.toArray();}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case BIND:
      case BIND3:
      case BIND4:
      case TRUE:
      case TRUE2:
      case FALSE:
      case FALSE2:
      case IDENTIFIER:
      case PATH_LITERAL:
        body = slotValueType();
    {if (true) return body;}
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Object slotValueType() throws ParseException {
  Object body;
  Token btoken;
  boolean boolval;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BIND:
    case BIND3:
    case BIND4:
      btoken = getBindType();
    // probably should refactor this later, instead of looking up the value directly
    Object val = engine.getDefglobalValue(btoken.image);
    if (val != null) {
      {if (true) return engine.getDefglobalValue(btoken.image);}
    } else {
      BoundParam bp = new BoundParam();
      bp.setVariableName(btoken.image);
      {if (true) return bp;}
    }
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case PATH_LITERAL:
      body = typeExpr();
    {if (true) return body;}
      break;
    case TRUE:
    case TRUE2:
    case FALSE:
    case FALSE2:
      boolval = trueFalse();
    {if (true) return new Boolean(boolval);}
      break;
    case IDENTIFIER:
      btoken = jj_consume_token(IDENTIFIER);
    {if (true) return btoken.image;}
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/* arrayType handles multislot tokens */
  final public void arrayType(List tokens) throws ParseException {
  Token tval;
  Object val;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      tval = jj_consume_token(IDENTIFIER);
    tokens.add(tval.image);
      break;
    case BIND:
      tval = jj_consume_token(BIND);
    if (tval.kind == CLIPSParserConstants.BIND) {
      BoundParam bp = new BoundParam();
      bp.setVariableName(tval.image);
      tokens.add(bp);
    }
      break;
    case BIND3:
      tval = jj_consume_token(BIND3);
    if (tval.kind == CLIPSParserConstants.BIND3) {
      BoundParam bp = new BoundParam();
      bp.setVariableName(tval.image);
      tokens.add(bp);
    }
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case PATH_LITERAL:
      val = typeExpr();
    tokens.add(val);
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* templateExpr gets the slots of a deftemplate */
  final public Deftemplate templateExpr() throws ParseException {
  Token exp;
  Deftemplate template;
  List slots = new ArrayList();
    /* javacc gives a warning for this, but not sure how to do it better */
      exp = jj_consume_token(IDENTIFIER);
    label_17:
    while (true) {
      templateBody(slots);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        ;
        break;
      default:
        jj_la1[33] = jj_gen;
        break label_17;
      }
    }
    Slot[] s = new Slot[slots.size()];
    slots.toArray(s);
    template = new Deftemplate(exp.image,null,s);
    slots.clear();
    exp.clear();
    exp = null;
    {if (true) return template;}
    throw new Error("Missing return statement in function");
  }

  final public void templateBody(List slots) throws ParseException {
  Token sname;
  int stype;
  int sid;
  Slot sl;
  MultiSlot msl;
  Object defaultvalue;
    if (jj_2_8(2147483647)) {
      jj_consume_token(LBRACE);
      jj_consume_token(SLOT);
      sname = jj_consume_token(IDENTIFIER);
      stype = slotType();
      defaultvalue = defaultValue();
      jj_consume_token(RBRACE);
    sid = slots.size();
    sl = new Slot(sname.image);
    sl.setId(sid);
    sl.setValueType(stype);
    sl.setDefaultValue(defaultvalue);
    slots.add(sl);
    sname = null;
    } else if (jj_2_9(2147483647)) {
      jj_consume_token(LBRACE);
      jj_consume_token(MULTISLOT);
      sname = jj_consume_token(IDENTIFIER);
      jj_consume_token(RBRACE);
    sid = slots.size();
    msl = new MultiSlot(sname.image);
    msl.setId(sid);
    slots.add(msl);
    sname = null;
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public int slotType() throws ParseException {
  int stype = -1;
  int defaultType = 9;
    if (jj_2_10(2147483647)) {
      jj_consume_token(LBRACE);
      jj_consume_token(TYPEDEF);
      stype = getType();
      jj_consume_token(RBRACE);
    } else {
      ;
    }
    if (stype > -1) {
      defaultType = stype;
    }
    {if (true) return defaultType;}
    throw new Error("Missing return statement in function");
  }

  final public Object defaultValue() throws ParseException {
  Object defobj = null;
    if (jj_2_11(2147483647)) {
      jj_consume_token(LBRACE);
      jj_consume_token(DEFAULTVALUE);
      defobj = typeExpr();
      jj_consume_token(RBRACE);
    } else {
      ;
    }
    {if (true) return defobj;}
    throw new Error("Missing return statement in function");
  }

  final public int getType() throws ParseException {
  Token exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER:
      exp = jj_consume_token(INTEGER);
    exp = null;
    {if (true) return Constants.INT_PRIM_TYPE;}
      break;
    case SHORT:
      exp = jj_consume_token(SHORT);
    exp = null;
    {if (true) return Constants.SHORT_PRIM_TYPE;}
      break;
    case LONG:
      exp = jj_consume_token(LONG);
    exp = null;
    {if (true) return Constants.LONG_PRIM_TYPE;}
      break;
    case FLOAT:
      exp = jj_consume_token(FLOAT);
    exp = null;
    {if (true) return Constants.FLOAT_PRIM_TYPE;}
      break;
    case DOUBLE:
      exp = jj_consume_token(DOUBLE);
    exp = null;
    {if (true) return Constants.DOUBLE_PRIM_TYPE;}
      break;
    case SYMBOL:
      exp = jj_consume_token(SYMBOL);
    exp = null;
    {if (true) return Constants.OBJECT_TYPE;}
      break;
    case STRING:
      exp = jj_consume_token(STRING);
    exp = null;
    {if (true) return Constants.STRING_TYPE;}
      break;
    case BOOLEAN:
      exp = jj_consume_token(BOOLEAN);
    exp = null;
    {if (true) return Constants.BOOLEAN_PRIM_TYPE;}
      break;
    case IDENTIFIER:
      exp = jj_consume_token(IDENTIFIER);
    if (exp.image.equals("DATE")) {
      {if (true) return Constants.DATE_TYPE;}
    } else {
      {if (true) return Constants.OBJECT_TYPE;}
    }
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Defrule ruleBody() throws ParseException {
  Token exp = null;
  Token rulecomment = null;
  Defrule rule;
  List dec = new ArrayList();
  List conditions = new ArrayList();
  List actions = new ArrayList();
  List modactions = new ArrayList();
    exp = jj_consume_token(IDENTIFIER);
    if (jj_2_12(2147483647)) {
      rulecomment = jj_consume_token(STRING_LITERAL);
    } else {
      ;
    }
    if (jj_2_13(2147483647)) {
      ruleDeclaration(dec);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
    case BIND:
      label_18:
      while (true) {
        conditionElement(conditions);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case BIND:
          ;
          break;
        default:
          jj_la1[35] = jj_gen;
          break label_18;
        }
      }
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    arrow();
    ruleActions(actions);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT_ARROW:
      leftarrow();
      ruleActions(modactions);
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    rule = new Defrule(exp.image);
    if (rulecomment != null) {
      rule.setComment(rulecomment.image);
    }
    rule.setRuleProperties(dec);
    Iterator itr = conditions.iterator();
    while (itr.hasNext()) {
      rule.addCondition( (Condition)itr.next() );
    }

    itr = actions.iterator();
    while (itr.hasNext()) {
      Object acn = itr.next();
      if (acn instanceof Function) {
        FunctionAction faction = new FunctionAction();
        faction.setFunction((Function)acn);
        rule.addAction(faction);
      } else if (acn instanceof Action) {
        rule.addAction( (Action)acn );
      }
    }
    itr = modactions.iterator();
    while (itr.hasNext()) {
      Object acn = itr.next();
      if (acn instanceof Function) {
        FunctionAction faction = new FunctionAction();
        faction.setFunction((Function)acn);
        rule.addModificationAction(faction);
      } else if (acn instanceof Action) {
        rule.addModificationAction( (Action)acn );
      }
    }
    dec.clear();
    conditions.clear();
    actions.clear();
    modactions.clear();
    exp = null;
    {if (true) return rule;}
    throw new Error("Missing return statement in function");
  }

  final public void ruleDeclaration(List list) throws ParseException {
  Token exp;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(DECLARE);
    ruleProperty(list);
    jj_consume_token(RBRACE);

  }

  final public void ruleProperty(List list) throws ParseException {
  Object exp = null;
  boolean tf = true;
  String ver = null;
  boolean remember = true;
  boolean temporal = false;
  boolean agenda = false;
  String direction = null;
  String date = null;
  RuleProperty rmem;
    if (jj_2_14(2147483647)) {
      exp = salience();
    } else {
      ;
    }
    if (exp != null) {
      Long intsal = new Long( ((Token)exp).image);
      RuleProperty sal = new RuleProperty(RuleProperty.SALIENCE,intsal.intValue());
      list.add(sal);
    }
    if (jj_2_15(2147483647)) {
      tf = autoFocus();
    } else {
      ;
    }
    RuleProperty auto = new RuleProperty(RuleProperty.AUTO_FOCUS,tf);
    list.add(auto);
    if (jj_2_16(2147483647)) {
      ver = ruleVersion();
    } else {
      ;
    }
    RuleProperty rp = new RuleProperty(RuleProperty.VERSION,ver);
    list.add(rp);
    if (jj_2_17(2147483647)) {
      remember = remember();
    } else {
      ;
    }
    rmem = new RuleProperty(RuleProperty.REMEMBER_ALPHA,remember);
    list.add(rmem);
    if (jj_2_18(2147483647)) {
      remember = remember();
    } else {
      ;
    }
    rmem = new RuleProperty(RuleProperty.HASHED_MEMORY,remember);
    list.add(rmem);
    if (jj_2_19(2147483647)) {
      date = effectiveDate();
    } else {
      ;
    }
    RuleProperty eff = new RuleProperty(RuleProperty.EFFECTIVE_DATE,date);
    list.add(eff);
    if (jj_2_20(2147483647)) {
      date = expirationDate();
    } else {
      ;
    }
    RuleProperty expr = new RuleProperty(RuleProperty.EXPIRATION_DATE,date);
    list.add(expr);
    if (jj_2_21(2147483647)) {
      direction = direction();
    } else {
      ;
    }
    RuleProperty dir = new RuleProperty(RuleProperty.DIRECTION,direction);
    list.add(dir);
    if (jj_2_22(2147483647)) {
      agenda = noAgenda();
    } else {
      ;
    }
    RuleProperty noagenda = new RuleProperty(RuleProperty.NO_AGENDA,agenda);
    list.add(noagenda);
    if (jj_2_23(2147483647)) {
      temporal = temporalAct();
    } else {
      ;
    }
    RuleProperty tempprop = new RuleProperty(RuleProperty.TEMPORAL_ACTIVATION,temporal);
    list.add(tempprop);
  }

  final public Object salience() throws ParseException {
  Token exp = null;
  Object val = null;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(SALIENCE);
    val = jj_consume_token(INTEGER_LITERAL);
    jj_consume_token(RBRACE);
    exp = null;
    if (val != null) {
      {if (true) return val;}
    } else {
      {if (true) return null;}
    }
    throw new Error("Missing return statement in function");
  }

  final public boolean autoFocus() throws ParseException {
  Token exp;
  boolean tf = false;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(AUTOFOCUS);
    tf = trueFalse();
    jj_consume_token(RBRACE);
    {if (true) return tf;}
    throw new Error("Missing return statement in function");
  }

  final public String ruleVersion() throws ParseException {
  Token exp;
    jj_consume_token(LBRACE);
    jj_consume_token(RULEVERSION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      exp = jj_consume_token(IDENTIFIER);
      break;
    case FLOATING_POINT_LITERAL:
      exp = jj_consume_token(FLOATING_POINT_LITERAL);
      break;
    case INTEGER_LITERAL:
      exp = jj_consume_token(INTEGER_LITERAL);
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACE);
    {if (true) return exp.image;}
    throw new Error("Missing return statement in function");
  }

  final public boolean remember() throws ParseException {
  Token exp;
  boolean tf = false;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(REMEMBERALPHA);
    tf = trueFalse();
    jj_consume_token(RBRACE);
    {if (true) return tf;}
    throw new Error("Missing return statement in function");
  }

  final public String direction() throws ParseException {
  Token exp;
  String defaultDir = "forward";
    jj_consume_token(LBRACE);
    jj_consume_token(CHAININGDIRECTION);
    exp = jj_consume_token(IDENTIFIER);
    jj_consume_token(RBRACE);
    if (exp != null && exp.image.equals("backward")) {
      {if (true) return exp.image;}
    } else {
      {if (true) return defaultDir;}
    }
    throw new Error("Missing return statement in function");
  }

  final public boolean noAgenda() throws ParseException {
  Token exp;
  boolean tf = false;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(NOAGENDA);
    tf = trueFalse();
    jj_consume_token(RBRACE);
    {if (true) return tf;}
    throw new Error("Missing return statement in function");
  }

  final public String effectiveDate() throws ParseException {
  Token exp;
  Token date;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(EFFECTIVE);
    date = jj_consume_token(STRING_LITERAL);
    jj_consume_token(RBRACE);
    {if (true) return date.image.substring(1,date.image.length() - 1);}
    throw new Error("Missing return statement in function");
  }

  final public String expirationDate() throws ParseException {
  Token exp;
  Token date;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(EXPIRATION);
    date = jj_consume_token(STRING_LITERAL);
    jj_consume_token(RBRACE);
    {if (true) return date.image.substring(1,date.image.length() - 1);}
    throw new Error("Missing return statement in function");
  }

  final public boolean temporalAct() throws ParseException {
  Token exp;
  boolean tf = false;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(TEMPORALACTIVATION);
    tf = trueFalse();
    jj_consume_token(RBRACE);
    {if (true) return tf;}
    throw new Error("Missing return statement in function");
  }

  final public boolean trueFalse() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
    {if (true) return true;}
      break;
    case TRUE2:
      jj_consume_token(TRUE2);
    {if (true) return true;}
      break;
    case FALSE:
      jj_consume_token(FALSE);
    {if (true) return false;}
      break;
    case FALSE2:
      jj_consume_token(FALSE2);
    {if (true) return false;}
      break;
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// conditionalElement checks for object binding
  final public void conditionElement(List list) throws ParseException {
  Token exp;
    if (jj_2_24(2147483647)) {
      exp = jj_consume_token(BIND);
      jj_consume_token(ASSIGN);
      jj_consume_token(LBRACE);
      CEType(list);
      jj_consume_token(RBRACE);
    ObjectCondition oc = (ObjectCondition)list.get(list.size() -1);
    BoundConstraint bc = new BoundConstraint(oc.getTemplateName(),true);
    bc.setValue(exp.image.substring(1));
    oc.addConstraint(bc,0);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        jj_consume_token(LBRACE);
        CEType(list);
        jj_consume_token(RBRACE);

        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

// CEType checks the Conditional element to see if it's exist, not, test or plain
  final public void CEType(List list) throws ParseException {
  Token exp;
  Token exp2;
  Object etime;
  Object nested = null;
  List alpha = new ArrayList();
  ObjectCondition oc = null;
  CubeQueryCondition cubec = null;
  TemporalCondition tmpc = null;
  List params = new ArrayList();
  AndCondition andcond = new AndCondition();
    if (jj_2_25(2147483647)) {
      jj_consume_token(NOTCE);
      jj_consume_token(LBRACE);
      exp = jj_consume_token(IDENTIFIER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        label_19:
        while (true) {
          templatePatterns(alpha);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
            ;
            break;
          default:
            jj_la1[41] = jj_gen;
            break label_19;
          }
        }
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    oc = new ObjectCondition();
    oc.setNegated(true);
    oc.setTemplateName(exp.image);
    Iterator itr = alpha.iterator();
    while (itr.hasNext()) {
      oc.addConstraint((Constraint)itr.next());
    }
    list.add(oc);
    alpha.clear();
    exp = null;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOTCE:
        jj_consume_token(NOTCE);
        jj_consume_token(LBRACE);
        nested = expr();
        jj_consume_token(RBRACE);
    TestCondition tc = new TestCondition();
    tc.setNegated(true);
    if (nested instanceof Function) {
      tc.setFunction((Function)nested);
    }
    list.add(tc);
        break;
      case CUBEQUERY:
        jj_consume_token(CUBEQUERY);
        jj_consume_token(LBRACE);
        exp = jj_consume_token(IDENTIFIER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          label_20:
          while (true) {
            templatePatterns(alpha);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LBRACE:
              ;
              break;
            default:
              jj_la1[43] = jj_gen;
              break label_20;
            }
          }
          break;
        default:
          jj_la1[44] = jj_gen;
          ;
        }
        jj_consume_token(RBRACE);
    cubec = new CubeQueryCondition();
    cubec.setTemplateName(exp.image);
    Iterator itr2 = alpha.iterator();
    while (itr2.hasNext()) {
      cubec.addConstraint((Constraint)itr2.next());
    }
    list.add(cubec);
    alpha.clear();
    exp = null;
        break;
      case TEMPORAL:
        jj_consume_token(TEMPORAL);
        temporalPattern(list);

        break;
      case TEST:
        jj_consume_token(TEST);
        jj_consume_token(LBRACE);
        nested = expr();
        jj_consume_token(RBRACE);
    tc = new TestCondition();
    if (nested instanceof Function) {
      tc.setFunction((Function)nested);
    }
    list.add(tc);
        break;
      case AND1:
        jj_consume_token(AND1);
        label_21:
        while (true) {
          jj_consume_token(LBRACE);
          nestedCE(andcond);
          jj_consume_token(RBRACE);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
            ;
            break;
          default:
            jj_la1[45] = jj_gen;
            break label_21;
          }
        }
    list.add(andcond);
        break;
      case EXISTS:
        jj_consume_token(EXISTS);
        label_22:
        while (true) {
          jj_consume_token(LBRACE);
          CEType(alpha);
          jj_consume_token(RBRACE);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
            ;
            break;
          default:
            jj_la1[46] = jj_gen;
            break label_22;
          }
        }
    ExistCondition exc = null;
    if (alpha.size() > 1) {
      for (int iz=0; iz < alpha.size(); iz++) {
        exc = ExistCondition.newExistCondition((ObjectCondition)alpha.get(iz));
        list.add(exc);
      }
    } else {
      exc = ExistCondition.newExistCondition((ObjectCondition)alpha.get(0));
      list.add(exc);
    }
        break;
      case IDENTIFIER:
        exp = jj_consume_token(IDENTIFIER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          label_23:
          while (true) {
            templatePatterns(alpha);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LBRACE:
              ;
              break;
            default:
              jj_la1[47] = jj_gen;
              break label_23;
            }
          }
          break;
        default:
          jj_la1[48] = jj_gen;
          ;
        }
    oc = new ObjectCondition();
    oc.setTemplateName(exp.image);
    Iterator itr = alpha.iterator();
    while (itr.hasNext()) {
      oc.addConstraint((Constraint)itr.next());
    }
    list.add(oc);
    alpha.clear();
    exp = null;
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void nestedCE(AndCondition andcond) throws ParseException {
  Object nested = null;
  List nestedCE = new ArrayList();
    if (jj_2_26(2147483647)) {
      CEType(nestedCE);
    andcond.addAll(nestedCE);
    nestedCE.clear();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BINDING:
      case ASSERT:
      case ASSERTTEMPORAL:
      case DEFCLASS:
      case DEFCUBE:
      case DEFFUNCTION:
      case DEFMODULE:
      case DEFRULE:
      case DEFQUERY:
      case DEFTEMPLATE:
      case MODIFY:
      case NOTCE:
      case RETRACT:
      case PLUS:
      case MINUS:
      case MULTIPLY:
      case DIVIDE:
      case GT1:
      case LT1:
      case EQ1:
      case EQ2:
      case LE1:
      case GE1:
      case NE1:
      case AND1:
      case OR1:
      case IDENTIFIER:
        nested = expr();
    TestCondition tc = new TestCondition();
    if (nested instanceof Function) {
      tc.setFunction((Function)nested);
    }
    andcond.addNestedConditionElement(tc);
        break;
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void temporalPattern(List list) throws ParseException {
  Token exp;
  Object nested = null;
  List alpha = new ArrayList();
  TemporalCondition tmpc = new TemporalCondition();
  List params = new ArrayList();
    temporalDeclaration(tmpc);
    jj_consume_token(LBRACE);
    exp = jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      label_24:
      while (true) {
        templatePatterns(alpha);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[51] = jj_gen;
          break label_24;
        }
      }
      break;
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    tmpc.setTemplateName(exp.image);
    Iterator itr = alpha.iterator();
    while (itr.hasNext()) {
      tmpc.addConstraint((Constraint)itr.next());
    }
    list.add(tmpc);
    alpha.clear();
    exp = null;
  }

  final public void temporalDeclaration(TemporalCondition tmpc) throws ParseException {
  Token exp2;
  Object etime;
  Object itime = null;
  List params = new ArrayList();
    jj_consume_token(LBRACE);
    jj_consume_token(DECLARE);
    exp2 = jj_consume_token(BIND);
    jj_consume_token(LBRACE);
    jj_consume_token(RELATIVETIME);
    etime = typeExpr();
    jj_consume_token(RBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      jj_consume_token(INTERVALTIME);
      itime = typeExpr();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        jj_consume_token(LBRACE);
        label_25:
        while (true) {
          valueParams(params);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case STRING_LITERAL:
          case BIND:
          case BIND3:
          case BIND4:
          case TRUE:
          case TRUE2:
          case FALSE:
          case FALSE2:
          case IDENTIFIER:
          case PATH_LITERAL:
            ;
            break;
          default:
            jj_la1[53] = jj_gen;
            break label_25;
          }
        }
        jj_consume_token(RBRACE);
        break;
      default:
        jj_la1[54] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    tmpc.setVariableName(exp2.image.substring(1));
    if (etime instanceof BigDecimal) {
      tmpc.setRelativeTime(((BigDecimal)etime).intValue());
    }
    if (itime != null && itime instanceof BigDecimal) {
      tmpc.setIntervalTime(((BigDecimal)itime).intValue());
      tmpc.addFunction(params);
    }
    exp2 = null;
  }

  final public void templatePatterns(List list) throws ParseException {
  Token exp = null;
    jj_consume_token(LBRACE);
    exp = jj_consume_token(IDENTIFIER);
    propertyType(list,exp);
    jj_consume_token(RBRACE);
    exp = null;
  }

  final public void propertyType(List list, Token identifier) throws ParseException {
  Token id = null;
  Object body = null;
  Token body2 = null;
  boolean bval = false;
  LiteralConstraint vc;
  BoundConstraint bc;
  OrLiteralConstraint orc;
  AndLiteralConstraint andc;
  List andor = new java.util.ArrayList();
  MultiValue mv = null;
    if (jj_2_27(2147483647)) {
      predicateFunc(list,identifier);

    } else if (jj_2_28(2147483647)) {
      body2 = jj_consume_token(BIND4);
    if (body2 != null) {
      bc = new BoundConstraint();
      bc.setName(identifier.image);
      bc.setValue(body2.image.substring(2));
      bc.setIsMultislot(true);
      list.add(bc);
    }
    } else if (jj_2_29(2147483647)) {
      body2 = jj_consume_token(BIND);
    if (body2 != null) {
      bc = new BoundConstraint();
      bc.setName(identifier.image);
      bc.setValue(body2.image.substring(1));
      list.add(bc);
    }
    } else if (jj_2_30(2147483647)) {
      jj_consume_token(TILDA);
      body2 = jj_consume_token(BIND);
    if (body2 != null) {
      bc = new BoundConstraint();
      bc.setName(identifier.image);
      bc.setValue(body2.image.substring(1));
      bc.setNegated(true);
      list.add(bc);
    }
    } else if (jj_2_31(2147483647)) {
      body = typeExpr();
      label_26:
      while (true) {
        jj_consume_token(OR2);
        orType(andor);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OR2:
          ;
          break;
        default:
          jj_la1[56] = jj_gen;
          break label_26;
        }
      }
    if (body != null) {
      orc = new OrLiteralConstraint();
      orc.setName(identifier.image);
      mv = new MultiValue(body);
      orc.addValue(mv);
      orc.addValues(andor);
      list.add(orc);
    }
    } else if (jj_2_32(2147483647)) {
      jj_consume_token(TILDA);
      body = typeExpr();
      label_27:
      while (true) {
        jj_consume_token(OR2);
        orType(andor);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OR2:
          ;
          break;
        default:
          jj_la1[57] = jj_gen;
          break label_27;
        }
      }
    if (body != null) {
      orc = new OrLiteralConstraint();
      orc.setName(identifier.image);
      mv = new MultiValue(body);
      mv.setNegated(true);
      orc.addValue(mv);
      orc.addValues(andor);
      list.add(orc);
    }
    } else if (jj_2_33(2147483647)) {
      body = bindTypeExpr();
      label_28:
      while (true) {
        jj_consume_token(AND2);
        andType(andor);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND2:
          ;
          break;
        default:
          jj_la1[58] = jj_gen;
          break label_28;
        }
      }
    if (body != null) {
      if (body instanceof String && ((String)body).startsWith("?") ) {
        bc = new BoundConstraint();
        bc.setName(identifier.image);
        bc.setValue( ((String)body).substring(1) );
        bc.setIntraFactJoin(true);
        bc.addIntrFactJoin(andor);
        list.add(bc);
      } else {
        andc = new AndLiteralConstraint();
        andc.setName(identifier.image);
        mv = new MultiValue(body);
        andc.addValue(mv);
        andc.addValues(andor);
        list.add(andc);
      }
    }
    } else if (jj_2_34(2147483647)) {
      jj_consume_token(TILDA);
      body = typeExpr();
      label_29:
      while (true) {
        jj_consume_token(AND2);
        andType(andor);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND2:
          ;
          break;
        default:
          jj_la1[59] = jj_gen;
          break label_29;
        }
      }
    if (body != null) {
      andc = new AndLiteralConstraint();
      andc.setName(identifier.image);
      mv = new MultiValue(body);
      mv.setNegated(true);
      andc.addValue(mv);
      andc.addValues(andor);
      list.add(andc);
    }
    } else if (jj_2_35(2147483647)) {
      jj_consume_token(TILDA);
      body = typeExpr();
    if (body != null) {
      vc = new LiteralConstraint();
      vc.setName(identifier.image);
      vc.setValue(body);
      vc.setNegated(true);
      list.add(vc);
    }
    } else if (jj_2_36(2147483647)) {
      id = jj_consume_token(IDENTIFIER);
    if (id != null) {
      vc = new LiteralConstraint();
      vc.setName(identifier.image);
      vc.setValue(id.image);
      list.add(vc);
    }
    } else if (jj_2_37(2147483647)) {
      jj_consume_token(TILDA);
      id = jj_consume_token(IDENTIFIER);
    if (id != null) {
      vc = new LiteralConstraint();
      vc.setName(identifier.image);
      vc.setValue(id.image);
      vc.setNegated(true);
      list.add(vc);
    }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case PATH_LITERAL:
        body = typeExpr();
    if (body != null) {
      vc = new LiteralConstraint();
      vc.setName(identifier.image);
      vc.setValue(body);
      list.add(vc);
    }
        break;
      case TRUE:
      case TRUE2:
      case FALSE:
      case FALSE2:
        bval = trueFalse();
    vc = new LiteralConstraint();
      vc.setName(identifier.image);
      vc.setValue( new Boolean(bval) );
      list.add(vc);
        break;
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

// either a bind or typeExpr
  final public Object bindTypeExpr() throws ParseException {
  Token body = null;
  Object value = null;
    if (jj_2_38(2147483647)) {
      body = jj_consume_token(BIND);
    {if (true) return body.image;}
    } else if (jj_2_39(2147483647)) {
      value = typeExpr();
    {if (true) return value;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// need to enhance to handling bindings
  final public void andType(List list) throws ParseException {
  Token body = null;
  Object val = null;
  MultiValue mv = null;
  BoundConstraint bc;
    if (jj_2_40(2147483647)) {
      body = jj_consume_token(IDENTIFIER);
    if (body != null) {
      mv = new MultiValue(body.image);
      list.add(mv);
    }
    } else if (jj_2_41(2147483647)) {
      jj_consume_token(TILDA);
      val = typeExpr();
    if (val != null) {
      mv = new MultiValue(val,true);
      list.add(mv);
    }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIND:
        // a binding ?bind
          body = jj_consume_token(BIND);
    bc = new BoundConstraint();
    bc.setValue( body.image.substring(1) );
    list.add(bc);
        break;
      case TILDA:
        jj_consume_token(TILDA);
        body = jj_consume_token(BIND);
    bc = new BoundConstraint();
    bc.setValue( body.image.substring(1) );
    bc.setNegated(true);
    list.add(bc);
        break;
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case PATH_LITERAL:
        val = typeExpr();
    if (val != null) {
      mv = new MultiValue(val);
      list.add(mv);
    }
        break;
      default:
        jj_la1[61] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void orType(List list) throws ParseException {
  Token body = null;
  Object val = null;
  MultiValue mv = null;
    if (jj_2_42(2147483647)) {
      body = jj_consume_token(IDENTIFIER);
    if (body != null) {
      mv = new MultiValue(body.image);
      list.add(mv);
    }
    } else if (jj_2_43(2147483647)) {
      jj_consume_token(TILDA);
      val = typeExpr();
    if (val != null) {
      mv = new MultiValue(val,true);
      list.add(mv);
    }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case PATH_LITERAL:
        val = typeExpr();
    if (val != null) {
      mv = new MultiValue(val);
      list.add(mv);
    }
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void predicateFunc(List list, Token identifier) throws ParseException {
  Token varname = null;
  String func = null;
  List params = new ArrayList();
  Token bind = null;
  Token val = null;
    varname = jj_consume_token(BIND2);
    jj_consume_token(LBRACE);
    func = functionName();
    label_30:
    while (true) {
      valueParams(params);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case BIND:
      case BIND3:
      case BIND4:
      case TRUE:
      case TRUE2:
      case FALSE:
      case FALSE2:
      case IDENTIFIER:
      case PATH_LITERAL:
        ;
        break;
      default:
        jj_la1[63] = jj_gen;
        break label_30;
      }
    }
    jj_consume_token(RBRACE);
    PredicateConstraint predc = new PredicateConstraint();
    predc.setName(identifier.image);
    predc.setVariableName(
      varname.image.substring(1,varname.image.length() -2));
    predc.setFunctionName(func);
    predc.addParameters(params);
    list.add(predc);
  }

  final public String functionName() throws ParseException {
  Token fname = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      fname = jj_consume_token(IDENTIFIER);
    {if (true) return fname.image;}
      break;
    case PLUS:
    case MINUS:
    case MULTIPLY:
    case DIVIDE:
    case GT1:
    case LT1:
    case EQ1:
    case EQ2:
    case LE1:
    case GE1:
    case AND1:
    case OR1:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        fname = jj_consume_token(PLUS);
        break;
      case MINUS:
        fname = jj_consume_token(MINUS);
        break;
      case MULTIPLY:
        fname = jj_consume_token(MULTIPLY);
        break;
      case DIVIDE:
        fname = jj_consume_token(DIVIDE);
        break;
      case GT1:
        fname = jj_consume_token(GT1);
        break;
      case LT1:
        fname = jj_consume_token(LT1);
        break;
      case EQ1:
        fname = jj_consume_token(EQ1);
        break;
      case EQ2:
        fname = jj_consume_token(EQ2);
        break;
      case LE1:
        fname = jj_consume_token(LE1);
        break;
      case GE1:
        fname = jj_consume_token(GE1);
        break;
      case AND1:
        fname = jj_consume_token(AND1);
        break;
      case OR1:
        fname = jj_consume_token(OR1);
        break;
      default:
        jj_la1[64] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    {if (true) return fname.image;}
      break;
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void arrow() throws ParseException {
  Token exp;
    exp = jj_consume_token(ARROW);
    exp = null;
  }

  final public void leftarrow() throws ParseException {
  Token exp;
    exp = jj_consume_token(LEFT_ARROW);
    exp = null;
  }

  final public void ruleActions(List list) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      label_31:
      while (true) {
        jj_consume_token(LBRACE);
        ruleAction(list);
        jj_consume_token(RBRACE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[66] = jj_gen;
          break label_31;
        }
      }
      break;
    default:
      jj_la1[67] = jj_gen;
      ;
    }

  }

  final public void ruleAction(List list) throws ParseException {
  Object exp;
    exp = expr();
    list.add(exp);
  }

  final public Defquery queryBody() throws ParseException {
  Token exp = null;
  Token querycomment = null;
  Defquery query;
  List variables = new ArrayList();
  List conditions = new ArrayList();
    exp = jj_consume_token(IDENTIFIER);
    if (jj_2_44(2147483647)) {
      querycomment = jj_consume_token(STRING_LITERAL);
    } else {
      ;
    }
    jj_consume_token(LBRACE);
    jj_consume_token(DECLARE);
    jj_consume_token(LBRACE);
    jj_consume_token(IDENTIFIER);
    label_32:
    while (true) {
      variables(variables);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BIND:
      case BIND3:
      case BIND4:
        ;
        break;
      default:
        jj_la1[68] = jj_gen;
        break label_32;
      }
    }
    jj_consume_token(RBRACE);
    jj_consume_token(RBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
    case BIND:
      label_33:
      while (true) {
        conditionElement(conditions);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case BIND:
          ;
          break;
        default:
          jj_la1[69] = jj_gen;
          break label_33;
        }
      }
      break;
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    query = new Defquery(exp.image);
    if (querycomment != null) {
      query.setComment(querycomment.image);
    }
    query.setQueryParameters(variables);
    Iterator itr = conditions.iterator();
    while (itr.hasNext()) {
      query.addCondition( (Condition)itr.next() );
    }

    variables.clear();
    conditions.clear();
    exp = null;
    {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

  final public void variables(List list) throws ParseException {
  Token exp = null;
    exp = getBindType();
    list.add(exp.image);
  }

  final public Defcube cubeExpr() throws ParseException {
  Defcube cube;
  Token cubename;
  List conditions = new ArrayList();
  List dimensions = new ArrayList();
  List measures = new ArrayList();
    cubename = jj_consume_token(IDENTIFIER);
    label_34:
    while (true) {
      jj_consume_token(ASSIGN);
      conditionElement(conditions);
      if (jj_2_45(2147483647)) {
        ;
      } else {
        break label_34;
      }
    }
    label_35:
    while (true) {
      jj_consume_token(LBRACE);
      cubeContents(dimensions, measures);
      jj_consume_token(RBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        ;
        break;
      default:
        jj_la1[71] = jj_gen;
        break label_35;
      }
    }
    cube = new Defcube(engine);
    cube.setName(cubename.image);
    cube.setDeftemplates(conditions);
    cube.setDimensions(dimensions);
    cube.setDefmeasures(measures);
    {if (true) return cube;}
    throw new Error("Missing return statement in function");
  }

  final public void cubeContents(List dimensions, List measures) throws ParseException {
  Token name;
  Token label;
  Token binding;
    if (jj_2_46(2147483647)) {
      label = jj_consume_token(IDENTIFIER);
      jj_consume_token(LBRACE);
      name = jj_consume_token(IDENTIFIER);
      binding = jj_consume_token(BIND);
      jj_consume_token(RBRACE);
    Defmeasure m = new Defmeasure();
    m.setMeasureLabel(label.image);
    m.setMeasureName(name.image);
    m.setVariableName(binding.image.substring(1));
    measures.add(m);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        name = jj_consume_token(IDENTIFIER);
        binding = jj_consume_token(BIND);
    Defdimension d = new Defdimension(engine);
    d.setName(name.image);
    d.setVariableName(binding.image.substring(1));
    dimensions.add(d);
        break;
      default:
        jj_la1[72] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_3_17() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(REMEMBERALPHA)) return true;
    return false;
  }

  final private boolean jj_3_39() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(RULEVERSION)) return true;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_scan_token(BIND)) return true;
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_scan_token(BIND)) return true;
    return false;
  }

  final private boolean jj_3_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) return true;
    }
    }
    }
    if (jj_scan_token(AND2)) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(AUTOFOCUS)) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(MULTISLOT)) return true;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(SALIENCE)) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_scan_token(TILDA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    }
    if (jj_scan_token(OR2)) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(SLOT)) return true;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_scan_token(TILDA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_31() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    }
    if (jj_scan_token(OR2)) return true;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(BIND3)) return true;
    if (jj_scan_token(BIND3)) return true;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_scan_token(TILDA)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_scan_token(TILDA)) return true;
    if (jj_scan_token(BIND)) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(BIND)) return true;
    if (jj_scan_token(BIND)) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_scan_token(BIND)) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(TEMPORALACTIVATION)) return true;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_scan_token(TILDA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_scan_token(BIND4)) return true;
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(NOAGENDA)) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_scan_token(NOTCE)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(DEFAULTVALUE)) return true;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_scan_token(TILDA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(CHAININGDIRECTION)) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_scan_token(BIND2)) return true;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(EXPIRATION)) return true;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_scan_token(TILDA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    }
    if (jj_scan_token(AND2)) return true;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(EFFECTIVE)) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(DECLARE)) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(TYPEDEF)) return true;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(HASHEDMEMORY)) return true;
    return false;
  }

  public CLIPSParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[73];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x4000,0x6c201,0x200,0x201,0x5800,0x200,0x200,0x8800,0x200,0x6da00,0x6da00,0x68000,0x68000,0x81900000,0x6da00,0x0,0x6da00,0x6da00,0x6da00,0x81900000,0x6d800,0x68000,0x200,0x6d800,0x2d800,0x2d800,0x2d800,0x2d800,0x2d800,0x2d800,0x6d800,0x6d800,0x2d800,0x200,0x200000,0x8200,0x8200,0x0,0x1800,0x0,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x20000000,0x81900000,0x200,0x200,0x6da00,0x200,0x200,0x0,0x0,0x0,0x0,0x5800,0xd800,0x5800,0x6da00,0x0,0x0,0x200,0x200,0x68000,0x8200,0x8200,0x200,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa10007d,0x0,0x2000000,0x0,0x0,0x0,0xa10007d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x94200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000400,0xa10007d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd80,0xd80,0x0,0x0,0xaffe0000,0xd80,0xaffe0000,0xd80,0xd80,0xd80,0xaffe0000,0xd80,0x0,0x0,0xd80,0x0,0x0,0x0,0x0,0x0,0x0,0xd80,0xd80,0x0,0x0,0xd,0x0,0x0,0x4000,0x0,0xd80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000060,0xaffe0000,0x0,0x0,0xd80,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0xd80,0x0,0x0,0xd80,0xa7fe0000,0xa7fe0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x4,0x4,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x24,0x24,0x0,0x0,0x4,0x24,0x0,0x24,0x24,0x24,0x4,0x24,0x0,0x0,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x0,0x4,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x24,0x0,0x0,0x1,0x1,0x0,0x0,0x20,0x22,0x20,0x24,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x4,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[46];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public CLIPSParser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CLIPSParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public CLIPSParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CLIPSParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public CLIPSParser(CLIPSParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CLIPSParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[102];
    for (int i = 0; i < 102; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 73; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 102; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 46; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
