/*
 * Copyright 2002-2009 Jamocha
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://jamocha.sourceforge.net/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package org.jamocha.mapping;

import java.io.Serializable;
import java.util.List;

import org.jamocha.rete.Print;

public interface Mapping extends Serializable, Print {
	public static final String PROPERTY = "property";
	public static final String KEY_PROPERTY = "key-property";
	
	String getMappingName();
	void setMappingName(String name);
	
	String getClassName();
	void setClassName(String clazz);
	
	String getSqlQuery();
	void setSqlQuery(String query);
	
	String getTableName();
	void setTableName(String table);
	
	String getTemplate();
	void setTemplate(String template);
	
	List getKeyProperties();
	void setKeyProperties(List keyProperties);
	void addKeyProperty(KeyProperty key);
	
	List getProperties();
	void setProperties(List properties);
	void addProperty(Property property);
	
	boolean usesCompositeKey();
}
