(deftemplate Aggregate
  (slot transactions)
  (slot ticker)
  (slot windowStart)
  (slot windowEnd)
  (slot totalShares)
  (slot average)
  (slot status)
)
(deftemplate Transaction
  (slot accountCode)
  (slot ticker)
  (slot cusip)
  (slot shares)
  (slot price)
  (slot total)
  (slot transactionType)
  (slot transactionStatus)
  (slot timestamp)
  (slot expirationDate)
  (slot effectiveDate)
)
(defrule calculate_aggregate
  ?aggregate <- (Aggregate
    (ticker ?ticker)
    (windowStart ?start&:(before ?start (now)) )
    (status "calculating")
  )
=>
  (printout t "calculate_aggregate fired" crlf)
)
(assert (Aggregate (ticker "GE")(windowStart 100000)(status "calculating") ) )