(deftemplate transaction
  (slot accountId)
  (slot buyPrice)
  (slot countryCode)
  (slot currentPrice)
  (slot cusip)
  (slot exchange)
  (slot industryGroupID)
  (slot industryID)
  (slot issuer)
  (slot lastPrice)
  (slot purchaseDate)
  (slot sectorID)
  (slot shares)
  (slot subIndustryID)
  (slot total)
  (slot txType)
)
(defrule temporal1
  (temporal
    (declare
      ?sell
      (relative-time 30)
    )
    (transaction
      (accountId ?sellid)
      (txType "sell")
      (shares ?shares)
    )
  )
  (temporal
    (declare
      ?tx
      (interval-time 5 (top 5) )
      (relative-time 5)
    )
    (transaction
    	(accountId ?accid)
      (exchange "NYSE")
      (issuer "IBM")
      (txType "buy")
      (shares ?shares)
    )
  )
=>
  (printout t "temporal1 rule test " ?accid " seller " ?sellid crlf)
)

(assert (transaction (accountId "aaa")(txType "sell") (shares 200) ) )
(assert (transaction (accountId "1")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 400) ) )
(assert (transaction (accountId "2")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 350) ) )
(assert (transaction (accountId "3")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "4")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "5")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "6")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "7")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "8")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "9")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "10")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "11")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "12")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "13")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "abc")(txType "sell") (shares 200) ) )
(assert (transaction (accountId "14")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (accountId "15")(exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
