(deftemplate transaction
  (slot accountId)
  (slot buyPrice)
  (slot countryCode)
  (slot currentPrice)
  (slot cusip)
  (slot exchange)
  (slot industryGroupID)
  (slot industryID)
  (slot issuer)
  (slot lastPrice)
  (slot purchaseDate)
  (slot sectorID)
  (slot shares)
  (slot subIndustryID)
  (slot total)
  (slot txType)
)
(defrule temporal1
  (temporal
    (declare
      ?sell
      (relative-time 20)
    )
    (transaction
      (txType "sell")
      (shares ?shares)
    )
  )
  (temporal
    (declare
      ?tx
      (relative-time 5)
    )
    (transaction
      (exchange "NYSE")
      (issuer "IBM")
      (txType "buy")
      (shares ?shares)
    )
  )
=>
  (printout t "temporal1 rule test" crlf)
)

(assert (transaction (exchange "NYSE")(issuer "IBM")(txType "buy") (shares 400) ) )
(assert (transaction (exchange "NYSE")(issuer "IBM")(txType "buy") (shares 350) ) )
(assert (transaction (exchange "NYSE")(issuer "IBM")(txType "buy") (shares 200) ) )
(assert (transaction (txType "sell") (shares 200) ) )
