;;;***************************************
;;;* sample farmer's dilemma for morendo *
;;;*  Nicky Dec.3th,2007, thx for peter  *
;;;***************************************

(deftemplate MAIN::status 
   (slot Previous_Status_ID (type LONG))
   (slot farmer_location (type STRING))
   (slot fox_location  (type STRING))
   (slot goat_location  (type STRING))
   (slot cabbage_location  (type STRING))
   (slot last_move  (type STRING)))

(deftemplate MAIN::opposites
   (slot site1 (type STRING))
   (slot site2 (type STRING))
   )
   
;;;*****************
;;;* INITIAL STATE *
;;;*****************

(assert (status  
          (Previous_Status_ID 1) 
          (farmer_location "shore-1")
          (fox_location "shore-1")
          (goat_location "shore-1")
          (cabbage_location "shore-1")
          (last_move "no-move")))

(assert (opposites
  (site1 "shore-1")
  (site2 "shore-2")
))

(assert (opposites
  (site1 "shore-2")
  (site2 "shore-1")
))

;;;***********************
;;;* GENERATE PATH RULES *
;;;***********************

(defrule MAIN::move_alone
    (status
        (farmer_location ?var1)
        (Previous_Status_ID ?num)
    )
    (opposites
        (site1 ?var1)
    )
=>
    (bind ?add (+ 1 ?num) )
    (assert (status
             (Previous_Status_ID ?add)
              (farmer_location "site2")
              (last_move "alone")
             )  
     ) 
)

(defrule MAIN::move_with_fox
    (status
        (farmer_location ?var1)
        (fox_location ?var1)
        (Previous_Status_ID ?num)
    )
    (opposites
        (site1 ?var1)
    )
=>
    (bind ?add (+ 1 ?num) )
    (assert  (status
               (Previous_Status_ID ?add)
               (farmer_location "site2")
               (fox_location "site2")
               (last_move "fox")
             )  
    ) 
)

(defrule MAIN::move_with_goat
    (status
        (farmer_location ?var1)
        (goat_location ?var1)
        (Previous_Status_ID ?num)
    )
    (opposites
        (site1 ?var1)
    )
=>
    (bind ?add (+ 1 ?num) )
    (assert  (status
               (Previous_Status_ID ?add)
               (farmer_location "site2")
               (goat_location "site2")
               (last_move "goat")
             )  
    ) 
)

(defrule MAIN::move_with_cabbage
    (status
        (farmer_location ?var1)
        (goat_location ?var1)
        (Previous_Status_ID ?num)
    )
    (opposites
        (site1 ?var1)
    )
=>
    (bind ?add (+ 1 ?num) )
    (assert  (status
               (Previous_Status_ID ?add)
               (farmer_location "site2")
               (cabbage_location "site2")
               (last_move "cabbage")
             )  
    ) 
)

;;;******************************
;;;* CONSTRAINT VIOLATION RULES *
;;;******************************
(defrule fox_eats_goat
    ?node <- (status
                (farmer_location ?s1)
                (fox_location ?s2 & ~?s1)
                (goat_location ?s2))
=>
    (retract ?node) 
)

(defrule fox_eats_goat
    ?node <- (status
                (farmer_location ?s1)
                (fox_location ?s2 & ~?s1)
                (goat_location ?s2))
=>
    (retract ?node) 
)


(defrule MAIN::goat_eats_cabbage
    ?node <- (status
                (farmer_location ?s1)
                (goat_location ?s2 & ~?s1)
                (cabbage_location ?s2))
=>
    (retract ?node) 
)

(defrule MAIN::circular_path 
  (status (Previous_Status_ID ?sd1)
          (farmer_location ?fs)
          (fox_location ?xs)
          (goat_location ?gs)
          (cabbage_location ?cs))
  ?node <- (status (Previous_Status_ID ?sd2&:(< ?sd1 ?sd2))
                   (farmer_location ?fs)
                   (fox_location ?xs)
                   (goat_location ?gs)
                   (cabbage_location ?cs))
  =>
  (retract ?node))
  
;;;************************
;;;* FIND  SOLUTION RULES *
;;;************************  
       
(deftemplate MAIN::moves 
   (slot id)
   (multislot moves-list))
   

(defrule MAIN::recognize-solution 
  ?node <- (status (farmer_location "shore-2")
                   (fox_location "shore-2")
                   (goat_location "shore-2")
                   (cabbage_location "shore-2")
                   (Previous_Status_ID ?statusid)
            )
  =>
  (printout t "Solution Found ID" ?statusid crlf)
  (retract ?node)
 ) 
(fire)
