(deftemplate Aggregate
  (slot transactions)
  (slot ticker)
  (slot windowStart)
  (slot windowEnd)
  (slot totalShares)
  (slot average)
  (slot status)
)
(deftemplate Transaction
  (slot accountCode)
  (slot ticker)
  (slot cusip)
  (slot shares)
  (slot price)
  (slot total)
  (slot transactionType)
  (slot transactionStatus)
  (slot timestamp)
  (slot expirationDate)
  (slot effectiveDate)
)
(defrule calculate_aggregate
  ?aggregate <- (Aggregate
    (ticker ?ticker)
    (windowStart ?start)
    (windowEnd ?end)
    (status "calculating")
  )
  ?trx <- (Transaction
    (ticker ?ticker)
    (ticker "IBM" | "MSFT" | "GE" | "ORCL")
    (timestamp ?stamp)
  )
  (test (and (> ?stamp ?start)(< ?stamp ?end) ) )
=>
  ;; add transaction to aggregate
  ;; (call ?aggregate addTransaction ?trx)
  (printout t "calculate the average" crlf)
<<=
  ;; on modify
  ;; (call ?aggregate removeTransaction ?trx)
  (printout t "correct the average" crlf)
)