(deftemplate transaction
  (slot accountId (type STRING))
  (slot buyPrice (type DOUBLE))
  (slot countryCode (type STRING))
  (slot currentPrice (type DOUBLE))
  (slot cusip (type INTEGER))
  (slot exchange (type STRING))
  (slot industryGroupID (type INTEGER))
  (slot industryID (type INTEGER))
  (slot issuer (type STRING))
  (slot lastPrice (type DOUBLE))
  (slot purchaseDate (type STRING))
  (slot sectorID (type INTEGER))
  (slot shares (type DOUBLE))
  (slot subIndustryID (type INTEGER))
  (slot total (type DOUBLE) (default 0.0))
)
(deftemplate account
  (slot accountId (type STRING))
  (slot cash (type DOUBLE))
  (slot fixedIncome (type DOUBLE))
  (slot stocks (type DOUBLE))
  (slot countryCode (type STRING))
  (slot accountType (type STRING))
)
(defrule joinrule1
 (transaction
    (accountId ?accid)
    (countryCode "US")
    (total ?tl&:(< ?tl 10000.00))
  )
  (account
    (accountId ?accid)
    (cash ?c&:(> ?c 1000000))
  )
=>
  (printout t "joinrule1 was fired" crlf)
)
(defrule joinrule2
 (transaction
    (accountId ?accid)
    (countryCode "US")
  )
  (account
    (accountId ~?accid)
    (accountType "new")
  )
=>
  (printout t "joinrule2 was fired" crlf)
)
(assert (transaction (accountId "acc1")(countryCode "US")(total 1298.00) ) )
(assert (account (accountId "acc1")(cash 1200000) ) )
(assert (transaction (accountId "acc2")(countryCode "US")(total 1299.00) ) )
(assert (account (accountId "acc2")(cash 1200002) ) )
(assert (transaction (accountId "acc2")(countryCode "NZ") ) )
(assert (transaction (accountId "acc3")(countryCode "US")(total 1298.00) ) )
(assert (account (accountId "acc3")(accountType "existing") ) )
(assert (transaction (accountId "acc4")(countryCode "US")(total 1299.00) ) )
(assert (account (accountId "acc4")(accountType "new") ) )
