(deftemplate transaction
  (slot accountId (type INTEGER))
  (slot buyPrice (type DOUBLE))
  (slot countryCode (type STRING))
  (slot currentPrice (type DOUBLE))
  (slot cusip (type INTEGER))
  (slot exchange (type STRING))
  (slot industryGroupID (type INTEGER))
  (slot industryID (type INTEGER))
  (slot issuer (type STRING))
  (slot lastPrice (type DOUBLE))
  (slot purchaseDate (type STRING))
  (slot sectorID (type INTEGER))
  (slot shares (type DOUBLE))
  (slot subIndustryID (type INTEGER))
  (slot total (type DOUBLE))
)
(deftemplate account
  (slot accountId (type INTEGER))
  (slot cash (type DOUBLE))
  (slot fixedIncome (type DOUBLE))
  (slot stocks (type DOUBLE))
  (slot countryCode (type STRING))
)
(deftemplate rating
  (slot cusip (type INTEGER))
  (slot issuer (type STRING))
)
(defrule joinrule1 (declare (salience 100)(rule-version a1.1) )
 (transaction
    (countryCode ?code)
    (accountId ?ac1)
  )
  (account
    (countryCode ~?code)
    (accountId ?ac2&:(> ?ac1 ?ac2))
  )

=>
  (printout t "joinrule1 was fired" crlf)
)

(assert (account (accountId 100)(countryCode "CHINA") ) )
(assert (transaction (accountId 200)(countryCode "US")) )