(deftemplate transaction
  (slot transactionId)
  (slot action)
  (slot accountId)
  (slot countryCode)
  (slot price)
  (slot cusip)
  (slot exchange)
  (slot industryGroupID)
  (slot industryID)
  (slot issuer)
  (slot purchaseDate)
  (slot sectorID)
  (slot shares)
  (slot subIndustryID)
)
(deftemplate proxyBuy
  (slot proxyTxId)
  (slot buyTxId)
  (slot shares)
  (slot cusip)
  (slot price)
  (slot transaction)
  (slot sharesAvail)
  (slot filled)
)
(deftemplate proxySell
  (multislot transactions)
  (slot cusip)
  (slot totalShares)
  (slot avePrice)
  (multislot buyTx)
  (slot sharesFound)
)
(deftemplate securityStats
  (slot cusip)
  (slot 30dayAve)
  (slot 30dayDelta)
  (slot 30dayVolume)
  (slot 60dayAve)
  (slot 60dayDelta)
  (slot 60dayVolume)
  (slot spLongRate)
  (slot spShortRate)
  (slot fLongRate)
  (slot fShortRate)
  (slot prevDayAve)
  (slot prevDayDelta)
  (slot prevDayVolume)
)
(deftemplate securityAggregate
  (slot high)
  (slot low)
  (slot cusip)
  (slot tradeVolume)
  (slot avePrice)
  (slot delta)
  (slot mean)
  (slot hourlyVolume)
)
(deftemplate hourlyAggregate
  (slot high)
  (slot low)
  (slot cusip)
  (slot hrVolume)
  (multislot transactions)
  (slot txPerSecond)
  (slot aveTxPerSec)
  (slot txPerMinute)
  (slot aveTxPerMin)
)
(defrule pump_and_dump
  (securityStats
    (prevDayVolume ?pdvol)
  )
  (securityAggregate
    (hourlyVolume ?hvol&:(> ?hvol ?pdvol ) )
  )
=>
  ;; if the hourly trade volume is 2x the trading volume of the previous day
  ;; send a warning there may be a pump and dump of the stock
  (printout t ?hvol " is greater than " ?pdvol crlf)
)
(assert (securityStats (prevDayVolume 12333.00) ) )
(assert (securityAggregate (hourlyVolume 14431.00) ) )
