(deftemplate guest
   (slot name (type STRING)) 
   (slot sex (type STRING))
   (slot hobby (type STRING)) )
   
(deftemplate last_seat
   (slot seat (type INTEGER)) )
   
(deftemplate seating
   (slot seat1 (type INTEGER))
   (slot name1 (type STRING))
   (slot name2 (type STRING))
   (slot seat2 (type INTEGER))
   (slot id (type INTEGER))
   (slot pid (type INTEGER))
   (slot path_done (type BOOLEAN)) )
   
(deftemplate context
   (slot name (type STRING)) )
   
(deftemplate path
   (slot id (type INTEGER))
   (slot name (type STRING))
   (slot seat (type INTEGER)) )
   
(deftemplate chosen
   (slot id (type INTEGER))
   (slot name (type STRING))
   (slot hobby (type STRING)) )

(deftemplate count
   (slot c (type INTEGER)) )

(defrule find_seating "find seating for guest"
   ?context <- (context (name "assign_seats") )
   (seating (seat2 ?s2) (name2 ?n2) (id ?id) (path_done TRUE) )
   (guest (name ?n2) (sex ?sex1) (hobby ?h1) )
   (guest (name ?g2) (sex ~?sex1) (hobby ?h1) )
   ?count <- (count (c ?cnt) )
   (not (path (id ?id) (name ?g2) ) )
   (not (chosen (id ?id) (name ?g2) (hobby ?h1) ) )
=>
   (bind ?s2plus1 (+ ?s2 1) )
   (assert (seating (seat1 ?s2) (name1 ?n2) (name2 ?g2) (seat2 ?s2plus1) (id ?cnt) (pid ?id) (path_done FALSE) ) )
   (assert (path (id ?cnt) (name ?g2) (seat ?s2plus1) ) )
   (assert (chosen (id ?id) (name ?g2) (hobby ?h1) ) ) 
   (bind ?cntPlus1 (+ ?cnt 1) )
   (modify ?count (c ?cntPlus1) )
   (modify ?context (name "make_path") )
   ;; (printout t "seat1=" ?s2 " : name1=" ?n2 " : seat2=" ?s2plus1 " : name2=" ?g2 " : id=" ?cnt " : pid=" ?id " : path_done=FALSE" crlf)
)
(defrule path_done "path is done"
   ?context <- (context (name "make_path") )
   ?seating <- (seating (path_done FALSE) )
=>
   (modify ?seating (path_done TRUE) )
   (modify ?context (name "check_done") )
   ;; (printout t "path is done " crlf)
)
(defrule continue "continue matching"
   ?context <- (context (name "check_done") )
=>
   (modify ?context (name "assign_seats") )
   ;; (printout t "assign seats again" crlf) 
)
(defrule are_we_done "are we done?"
   ?context <- (context (name "check_done") )
   (last_seat (seat ?lseat) )
   (seating (seat2 ?lseat) )
=>
   (printout t "Yes, we are done:  Print Results!!" crlf)
   (modify ?context (name "all_done") )
)
(defrule all_done "all done with test"
  ?context <- (context (name "all_done") )
=>
  (modify ?context (name "print_results") )
  (printout t crlf "rule all done: Condition context print_results" crlf )
)
(defrule print_results "print the results"
  (context (name "print_results") )
  ?seating <- (seating (id ?id) (seat2 ?s2) )
  (last_seat (seat ?s2) )
  (path (id ?id) (name ?n1) (seat ?s1) )
=>
  (printout t "name=" ?n1 " seat=" ?s1 crlf)
  (retract ?seating)
)
(bind ?*start* (ms-time) )
(load ./manners_128_facts.dat)
(fire)
(bind ?*end* (ms-time) )
(bind ?et (- ?*end* ?*start*) )
(printout t "elpasedTime=" ?et crlf)