(deftemplate Transaction
  (slot accountId)
  (slot buyPrice)
  (slot ticker)
  (slot cusip)
  (slot exchange)
  (slot shares)
  (slot total)
  (slot txType)
)
(deftemplate SecurityHistory
  (slot ticker)
  (slot cusip)
  (slot dailyAverage)
  (slot openPrice)
  (slot closePrice)
  (slot tradeVolume)
  (slot fitchLong)
  (slot timestamp)
)
(deftemplate SecurityDetails
  (slot ticker)
  (slot cusip)
  (slot countryCode)
  (slot issuer)
  (slot sectorID)
  (slot subIndustryID)
  (slot industryGroupID)
  (slot industryID)
)
(deftemplate Watchitem
  (slot ticker)
  (slot average)
  (slot openPrice)
  (slot closePrice)
  (slot tradeVolume)
)
(defcube StockStats
  <- (Transaction
    (accountId ?accid)
    (ticker ?tkr)
    (shares ?share)
    (buyPrice ?bprice)
    (total ?total)
    (txType ?txtype)
  )
  <- (SecurityHistory
    (ticker ?tkr) ;; join on transaction ticker
    (dailyAverage ?dayavg)
    (openPrice ?oprice)
    (closePrice ?cprice)
    (tradeVolume ?tvol)
    (fitchLong ?flong)
    (timestamp ?tstamp)
  )
  <- (SecurityDetails
    (ticker ?tkr)
    (countryCode ?country)
    (issuer ?issuer)
    (sectorID ?secId)
    (subIndustryID ?subIndId)
    (industryGroupID ?idnGrpId)
    (industryID ?indId)
  )
  (dimension accountId ?accid)
  (dimension ticker ?tkr)
  (dimension shares ?share)
  (dimension price ?bprice)
  (dimension total ?total)
  (dimension dailyAverage ?dayavg)
  (dimension openPrice ?oprice)
  (dimension closePrice ?cprice)
  (dimension tradeVolume ?tvol)
  (dimension fitchLong ?flong)
  (dimension issuer ?issuer)
  (dimension countryCode ?country)
  (dimension sectorID ?secId)
  (dimension industryGroupID ?idnGrpId)
  (dimension industryID ?indId)
  (dimension subIndustryID ?subIndId)
  (aveVolume (average ?tvol))
  (volume (sum ?share))
  (volumeStDev (stdev ?tvol))
  (aveBuy (average ?bprice))
  (maxTotal (max ?total))
  (minTotal (min ?total))
  (maxShares (max ?share))
  (minShares (min ?share))
  (maxBuy (max ?bprice))
  (minBuy (min ?bprice))
  (aveClosing (average ?cprice))
)

(defrule cube_rule_2
  (Watchitem
    (ticker ?ticker)
  )
  (cubequery
    (StockStats
      (ticker ?ticker)
      (shares ?shares&:(> ?shares 5000) )
      (aveBuy ?avebuy)
    )
  )
=>
  (printout t "cube_rule_2 fired - average buy: " ?avebuy crlf)
)
  