(deftemplate Transaction
  (slot accountId)
  (slot buyPrice)
  (slot ticker)
  (slot cusip)
  (slot exchange)
  (slot shares)
  (slot total)
  (slot txType)
)
(deftemplate SecurityHistory
  (slot ticker)
  (slot cusip)
  (slot dailyAverage)
  (slot openPrice)
  (slot closePrice)
  (slot tradeVolume)
  (slot fitchLong)
  (slot date)
)
(deftemplate SecurityDetails
  (slot ticker)
  (slot cusip)
  (slot countryCode)
  (slot issuer)
  (slot sectorID)
  (slot subIndustryID)
  (slot industryGroupID)
  (slot industryID)
)
(deftemplate Watchitem
  (slot ticker)
  (slot average)
  (slot openPrice)
  (slot closePrice)
  (slot tradeVolume)
)
(defcube StockStats
  <- (Transaction
    (accountId ?accid)
    (ticker ?tkr)
    (shares ?share)
    (buyPrice ?bprice)
    (total ?total)
    (txType ?txtype)
  )
  <- (SecurityHistory
    (ticker ?tkr) ;; join on transaction ticker
    (dailyAverage ?dayavg)
    (openPrice ?oprice)
    (closePrice ?cprice)
    (tradeVolume ?tvol)
    (fitchLong ?flong)
    (date ?date)
  )
  <- (SecurityDetails
    (ticker ?tkr)
    (countryCode ?country)
    (issuer ?issuer)
    (sectorID ?secId)
    (subIndustryID ?subIndId)
    (industryGroupID ?idnGrpId)
    (industryID ?indId)
  )
  (dimension accountId ?accid)
  (dimension ticker ?tkr)
  (dimension shares ?share)
  (dimension price ?bprice)
  (dimension total ?total)
  (dimension dailyAverage ?dayavg)
  (dimension openPrice ?oprice)
  (dimension closePrice ?cprice)
  (dimension tradeVolume ?tvol)
  (dimension fitchLong ?flong)
  (dimension issuer ?issuer)
  (dimension countryCode ?country)
  (dimension sectorID ?secId)
  (dimension industryGroupID ?idnGrpId)
  (dimension industryID ?indId)
  (dimension subIndustryID ?subIndId)
  (dimension date ?date)
  (aveVolume (average ?tvol))
  (volume (sum ?share))
  (volumeStDev (stdev ?tvol))
  (aveBuy (average ?bprice))
  (maxTotal (max ?total))
  (minTotal (min ?total))
  (maxShares (max ?share))
  (minShares (min ?share))
  (maxBuy (max ?bprice))
  (minBuy (min ?bprice))
  (aveClosing (average ?cprice))
)

(defrule cube_rule_1
  (Watchitem
    (ticker ?ticker)
  )
  (cubequery
    (StockStats
      (ticker ~?ticker)
      (volume ?volume)
      (maxShares ?maxs)
      (minShares ?mins)
    )
  )
=>
  (printout t "cube_rule_1 fired - volume: " ?volume " max shares: " ?maxs " min shares: " ?mins crlf)
)

(assert (Transaction (accountId "ABC")(ticker "IBM")(countryCode "US")(shares 3500)(buyPrice 90.25)(total 251250) ) )
(assert (Transaction (accountId "ABC")(ticker "MSFT")(countryCode "US")(shares 6000)(buyPrice 50.25)(total 251250) ) )
(assert (Transaction (accountId "DEF")(ticker "MSFT")(countryCode "US")(shares 5250)(buyPrice 50.00)(total 250000) ) )
(assert (Transaction (accountId "GHI")(ticker "MSFT")(countryCode "US")(shares 4300)(buyPrice 50.20)(total 251000) ) )
(assert (Transaction (accountId "JKL")(ticker "MSFT")(countryCode "US")(shares 7200)(buyPrice 50.00)(total 250000) ) )
(assert (SecurityHistory (ticker "MSFT")(dailyAverage 52.50)(openPrice 48.02)(closePrice 49.80)(fitchLong "AA") ) )
(assert (SecurityHistory (ticker "IBM")(dailyAverage 88.20)(openPrice 89.05)(closePrice 88.03)(fitchLong "AAA") ) )
(assert (SecurityDetails (ticker "MSFT")(countryCode "US")(issuer "Microsoft") ) )
(assert (SecurityDetails (ticker "IBM")(countryCode "US")(issuer "IBM") ) )
(assert (Watchitem (ticker "MSFT") ) )
(fire)
