(deftemplate transaction
  (slot accountId)
  (slot buyPrice)
  (slot countryCode)
  (slot currentPrice)
  (slot ticker)
  (slot cusip)
  (slot exchange)
  (slot industryGroupID)
  (slot industryID)
  (slot issuer)
  (slot lastPrice)
  (slot purchaseDate)
  (slot sectorID)
  (slot shares)
  (slot subIndustryID)
  (slot total)
  (slot txType)
)
(deftemplate securityHistory
  (slot ticker)
  (slot dailyAverage)
  (slot openPrice)
  (slot closePrice)
  (slot tradeVolume)
  (slot fitchLong)
)
(deftemplate watchitem
  (slot ticker)
  (slot average)
  (slot openPrice)
  (slot closePrice)
  (slot tradeVolume)
)
(defcube StockStats
  <- (transaction
    (ticker ?tkr)
    (countryCode ?country)
    (shares ?share)
    (buyPrice ?bprice)
    (total ?total)
    (accountId ?accid)
  )
  <- (securityHistory
    (ticker ?tkr) ;; join on transaction ticker
    (dailyAverage ?dayavg)
    (openPrice ?oprice)
    (closePrice ?cprice)
    (tradeVolume ?tvol)
    (fitchLong ?flong)
  )
  (dimension accountId ?accid)
  (dimension ticker ?tkr)
  (dimension countryCode ?country)
  (dimension shares ?share)
  (dimension price ?bprice)
  (dimension total ?total)
  (dimension dailyAverage ?dayavg)
  (dimension openPrice ?oprice)
  (dimension closePrice ?cprice)
  (dimension tradeVolume ?tvol)
  (dimension fitchLong ?flong)
  (aveVolume (average ?tvol))
  (volume (sum ?share))
  (volumeStDev (stdev ?tvol))
  (aveBuy (average ?bprice))
  (maxTotal (max ?total))
  (minTotal (min ?total))
  (maxShares (max ?share))
  (minShares (min ?share))
  (maxBuy (max ?bprice))
  (minBuy (min ?bprice))
  (aveClosing (average ?cprice))
)

(defrule cube_rule_1
  (watchitem
    (ticker ?ticker)
  )
  (cubequery
    (StockStats
      (ticker ~?ticker)
      (volume ?volume)
      (maxShares ?maxs)
      (minShares ?mins)
    )
  )
=>
  (printout t "cube_rule_1 fired - volume: " ?volume " max shares: " ?maxs " min shares: " ?mins crlf)
)

(assert (transaction (accountId "ABC")(ticker "IBM")(countryCode "US")(shares 3500)(buyPrice 90.25)(total 251250) ) )
(assert (transaction (accountId "ABC")(ticker "MSFT")(countryCode "US")(shares 6000)(buyPrice 50.25)(total 251250) ) )
(assert (transaction (accountId "DEF")(ticker "MSFT")(countryCode "US")(shares 5250)(buyPrice 50.00)(total 250000) ) )
(assert (transaction (accountId "GHI")(ticker "MSFT")(countryCode "US")(shares 4300)(buyPrice 50.20)(total 251000) ) )
(assert (transaction (accountId "JKL")(ticker "MSFT")(countryCode "US")(shares 7200)(buyPrice 50.00)(total 250000) ) )
(assert (securityHistory (ticker "MSFT")(dailyAverage 52.50)(openPrice 48.02)(closePrice 49.80)(fitchLong "AA") ) )
(assert (securityHistory (ticker "IBM")(dailyAverage 88.20)(openPrice 89.05)(closePrice 88.03)(fitchLong "AAA") ) )
(assert (watchitem (ticker "MSFT") ) )
(fire)
