(deftemplate Position
  (slot accountId)
  (slot ticker)
  (slot cusip)
  (slot shares)
  (slot total)
  (slot countryCode)
  (slot issuer)
  (slot sectorID)
  (slot industryGroupID)
  (slot industryID)
  (slot subIndustryID)
)
(deftemplate Rating
  (slot name)
  (slot description)
  (slot code)
  (slot ticker)
  (slot cusip)
  (slot numericValue)
  (slot ratingType)
)
(deftemplate Account
  (slot accountId)
  (slot firstName)
  (slot middleName)
  (slot lastName)
  (slot ssn)
  (slot age)
  (slot gender)
)
(deftemplate Stock
  (slot ticker)
  (slot closingPrice)
  (slot closeDate)
  (slot exchange)
  (slot cusip)
  (slot 60day)
  (slot 90day)
)
(defcube PositionCube
  <- (Account
    (accountId ?accountid)
    (ssn ?ssnumber)
    (age ?age)
    (gender ?gender)
  )
  <- (Position
    (accountId ?accountid)
    (ticker ?ticker)
    (cusip ?cusip)
    (shares ?shares)
    (total ?total)
    (countryCode ?countrycode)
    (issuer ?issuer)
    (sectorID ?sectorid)
    (industryGroupID ?industrygroupid)
    (industryID ?industryid)
    (subIndustryID ?subindustryid)
  )
  <- (Stock
    (ticker ?ticker)
    (closingPrice ?closeprice)
    (exchange ?exchange)
    (60day ?60day)
    (90day ?90day)
    (closeDate ?closedate)
  )
  <- (Rating
    (name ?ratingname)
    (ticker ?ticker)
    (code ?ratingcode)
    (numericValue ?ratingvalue)
    (ratingType ?ratetype)
  )
  (dimension accountId ?accountid)
  (dimension ssn ?ssnumber)
  (dimension age ?age)
  (dimension gender ?gender)
  (dimension ticker ?ticker)
  (dimension cusip ?cusip)
  (dimension shares ?shares)
  (dimension total ?total)
  (dimension country ?countrycode)
  (dimension issuer ?issuer)
  (dimension sector ?sectorid)
  (dimension industryGroup ?industrygroupid)
  (dimension industy ?industryid)
  (dimension subIndustry ?subindustryid)
  (dimension ratingName ?ratingname)
  (dimension ratingValue ?ratingvalue)
  (dimension closingPrice ?closeprice)
  (dimension closeDate ?closedate)
  (dimension exchange ?exchange)
  (dimension 60DayAverage ?60day)
  (dimension 90DayAverage ?90day)
  (totalValue (sum ?total))
  (totalShares (sum ?shares))
  (averageRating (average ?ratingvalue))
)
