(defcube TransactionCube
  <- (HTTPLog
    (IPAddress ?ipaddr)
    (URL ?url)
    (action ?action)
    (bytesSent ?bytesSent)
    (elapsedTime ?elapsedTime)
    (endTime ?endTime)
    (logType ?logType)
    (serverType ?applicationType)
    (sessionID ?sessionId)
    (statusCode ?statusCode)
    (timestamp ?timestamp)
    (transactionID ?transactionId)
  )
  <- (DatabaseQueryLog
    (IPAddress ?dbipaddr)
    (bytesSent ?dbBytesSent)
    (databaseName ?dbName)
    (databaseType ?dbType)
    (elapsedTime ?dbElapsedTime)
    (endTime ?dbEndTime&:(within-minutes 4 ?dbEndTime ?endTime) )
    (queryString ?qString)
    (queryType ?queryType)
    (statusCode ?dbStatusCode)
    (timestamp ?dbTimestamp&:(within-minutes 2 ?timestamp ?dbTimestamp) )
    (transactionID ?transactionId )
  )
  (dimension IPAddress ?ipaddr)
  (dimension DBIPAddress ?dbipaddr)
  (dimension Application ?url)
  (dimension TransactionID ?transactionId)
  (dimension StartTime ?timestamp)
  (dimension EndTime ?endTime)
  (dimension RequestElapsedTime ?elapsedTime)
  (dimension DbQueryElapsedTime ?dbElapsedTime)
  (dimension ServerType ?applicationType)
  (dimension ApplicationStatus ?statusCode)
  (dimension DatabaseStatus ?dbStatusCode)
  (AvergeResponseTime (average ?elapsedTime) )
  (AverageDbQueryTime (average ?dbElapsedTime) )
  (NinetyPercentResponseTime (90-percentile ?elapsedTime) )
  (MaxResponseTime (max ?elapsedTime) )
  (MaxDbQueryTime (max ?dbElapsedTime) )
  (TotalBytesSent (sum ?bytesSent) )
  (DbTotalBytesSent (sum ?dbBytesSent) )
)