(deftemplate piece
  (slot name)
  (slot id)
  (slot inPlay (type BOOLEAN))
  (slot pieceType)
  (slot color)
  (slot blocked (type BOOLEAN))
  (slot currentPosition)
  (slot lastPosition)
  (slot weight)
  (slot moveCount)
)
(deftemplate capture
  (slot attacker (type STRING))
  (slot defender (type STRING))
  (slot startPosition (type STRING))
  (slot endPosition (type STRING))
  (slot weight (type INTEGER))
  (slot color (type STRING))
)
(deftemplate move
  (slot name (type STRING))
  (slot id (type STRING))
  (slot color (type STRING))
  (slot startPosition (type STRING))
  (slot endPosition (type STRING))
)
(deftemplate availableMove
  (slot name (type STRING))
  (slot id (type STRING))
  (slot color (type STRING))
  (slot startPosition (type STRING))
  (slot endPosition (type STRING))
)
(deftemplate executedMove
  (slot piece (type STRING))
  (slot color (type STRING))
  (slot startPosition (type STRING))
  (slot endPosition (type STRING))
  (slot capturedPiece(type STRING))
)
(deftemplate position
  (slot piece (type STRING))
  (slot lastpiece (type STRING))
  (slot cellId (type STRING))
)
(deftemplate turn
  (slot color (type STRING))
)
(deftemplate game
  (slot status)
  (slot nextMove)
  (slot result)
)
(deftemplate player
  (slot level)
  (slot name)
  (slot color)
)
(deftemplate computer
  (slot calculate)
  (slot searchDepth)
)

(defrule newGame
  ?game <- (game
    (status "new")
  )
=>
  (assert (turn (color "white") ) ) ;; assert a turn fact to start the game
  (modify ?game (status "playing") ) ;; change game status to playing
)

(defrule computerMove
  ?turn <- (turn
    (color ?color) ;; bind color to variable named color
  )
  (player
    (name "computer") ;; the player is the computer
    (color ?color) ;; join on the color
  )
=>
  (assert (computer (calculate true)(searchDepth 1) ) ) ;; assert fact to calculate
)

(defrule movePiece
  (move
    (color ?color)
    (name ?name)
    (id ?id)
    (startPosition ?startpos)
    (endPosition ?endpos)
  )
  ?piece <- (piece
    (color ?color)
    (id ?id)
    (currentPosition ?startpos)
  )
=>
  ;; update the location of the piece
  (modify ?piece (currentPosition ?endpos)(lastPosition ?startpos) )
)

(defrule capture1
  (piece
    (currentPosition ?curr)
    (id ?target)
    (color ?color)
  )
  (turn
    (color ~?color)
  )
  (move
    (endPosition ?curr)
    (startPosition ?startpos)
    (id ?attacker)
    (color ~?color)
    (color ?mcolor)
  )
=>
  ;; assert a new capture fact to the working memory of the moves that can capture
  (assert 
    (capture 
      (attacker ?attacker)
      (defender ?target)
      (startPosition ?startpos)
      (endPosition ?curr)
      (weight 0)
      (color ?mcolor)
    )
  )
  (printout t "(capture (attacker " ?attacker ") (defender " 
    ?target ")(startPosition " ?startpos ")(endPosition " ?curr ")(weight 0) )" crlf)
)
(defrule isCheck
  ?cap <- (capture
    (defender ~"bk" & ~"wk")
  )
=>
  (printout t "no king is in check" crlf)
)

