(deftemplate transaction
  (slot transactionId)
  (slot action)
  (slot accountId)
  (slot countryCode)
  (slot price)
  (slot cusip)
  (slot exchange)
  (slot industryGroupID)
  (slot industryID)
  (slot issuer)
  (slot purchaseDate)
  (slot sectorID)
  (slot shares)
  (slot subIndustryID)
)
(deftemplate proxyBuy
  (slot proxyTxId)
  (slot buyTxId)
  (slot shares)
  (slot cusip)
  (slot price)
  (slot transaction)
  (slot sharesAvail)
  (slot filled)
)
(deftemplate proxySell
  (multislot transactions)
  (slot cusip)
  (slot totalShares)
  (slot avePrice)
  (multislot buyTx)
  (slot sharesFound)
)
(deftemplate securityStats
  (slot cusip)
  (slot 30dayAve)
  (slot 30dayDelta)
  (slot 30dayVolume)
  (slot 60dayAve)
  (slot 60dayDelta)
  (slot 60dayVolume)
  (slot spLongRate)
  (slot spShortRate)
  (slot fLongRate)
  (slot fShortRate)
  (slot prevDayAve)
  (slot prevDayDelta)
  (slot prevDayVolume)
)
(deftemplate securityAggregate
  (slot high)
  (slot low)
  (slot cusip)
  (slot tradeVolume)
  (slot avePrice)
  (slot delta)
  (slot mean)
  (slot hourlyVolume)
)
(deftemplate hourlyAggregate
  (slot high)
  (slot low)
  (slot cusip)
  (slot hrVolume)
  (multislot transactions)
  (slot txPerSecond)
  (slot aveTxPerSec)
  (slot txPerMinute)
  (slot aveTxPerMin)
)

(defrule make_proxy_buy
  (transaction
    (shares ?shares&:(> ?shares 100000) ) ;; over 100K shares
    (price ?bprice&:(> ?bprice 50.00) ) ;; price over 50.00
    (cusip ?cusip)
    (transactionId ?txid)
    (action "buy")
  )
  (not 
    (proxyBuy
      (buyTxId ?txid)
      (cusip ?cusip)
    )
  )
=>
  ;; create a new proxyBuy by dividing it into 4 smaller transactions
)
(defrule match_proxy_buy
  (proxyBuy
    (filled false)
    (cusip ?cusip)
    (shares ?shares)
    (price ?bprice)
  )
  ?sell <- (transaction
    (action "sell")
    (cusip ?cusip)
    (price ?sprice&:(<= ?sprice ?bprice) )
    (shares ?sell&:(<= ?sell ?shares) )
  )
=>
  ;; set proxyBuy.transaction with the transaction and set filled to true
)
(defrule create_proxy_sell
  (transaction
    (shares ?shares&:(< ?shares 100) )
    (price ?sprice&:(< ?sprice 2.00) )
    (cusip ?cusip)
    (action "sell")
  )
  (not
    (proxySell
      (cusip ?cusip)
    )
  )
=>
  ;; create a proxy sell 
)
(defrule add_to_proxy_sell
  (transaction
    (shares ?shares&:(< ?shares 100) )
    (price ?sprice&:(< ?sprice 2.00) )
    (cusip ?cusip)
    (action "sell")
  )
  (proxySell
    (cusip ?cusip)
    (totalShares ?tshares&:(< ?tshares 1000) )
    (avePrice ?avep)
  )
=>
  ;; add a number of smaller transactions to a proxy sell
)
(defrule execute_proxy_sell
  (proxySell
    (cusip ?cusip)
    (totalShares ?tshares)
    (avePrice ?avep)
  )
  (transaction
    (action "buy")
    (cusip ?cusip)
    (price ?price&:(>= ?price ?avep) )
    (shares ?shares&:(> ?shares ?tshares) )
  )
=>
  ;; execute a proxy sell by grouping a bunch of smaller transactions
  ;; to form a larger transaction
)
(defrule create_statistics
  (transaction
    (cusip ?cusip)
  )
  (not
    (securityAggregate
      (cusip ?cusip)
    )
  )
=>
  ;; create a new securityAggregate and assert it
)
(defrule update_statistics
  (transaction
    (cusip ?cusip)
  )
  (securityAggregate
    (cusip ?cusip)
  )
=>
  ;; retract the securityAggregate and update the statistics
)
(defrule pump_and_dump
  (securityStats
    (prevDayVolume ?pdvol)
  )
  (securityAggregate
    (hourlyVolume ?hvol&:(> ?hvol (* ?pdvol 2) ) )
  )
=>
  ;; if the hourly trade volume is 2x the trading volume of the previous day
  ;; send a warning there may be a pump and dump of the stock
)
(defrule stock_plumet
  (securityStats
    (prevDayAve ?pda)
  )
  (securityAggregate
    (avePrice ?avep&:(< ?avep (/ ?pda 4) ) )
  )
=>
  ;; the stock has dropped 75% of it's value
)
(defrule volume_drop
  ?hraggr <- (hourlyAggregate
    (declare (window 60) )
    (cusip ?cusip)
    (txPerMinute ?txpm) ;; the last txPerMinute
    (aveTxPerMin ?atpm) ;; the ave txPerMinute for the last hour
    (transactions $?transactions) ;; the list of transactions for the last hour
  )
  (aggregate
    (transaction
      (action "sell")
      (cusip ?cusip)
      (OBJECT ?tx) ;; bind the object to variable ?tx
    )
    (add-transaction ?tx ?hraggr) ;; add the transaction to hourlyAggregate
  )
  (test (< ?txpm (* ?atpm 0.5) ) ) ;; see if the ave txPerMin has dropped more than 50%
=>
  ;; send an alert
  ;; (send-alert ?cusip)
)
    