(defclass org.jamocha.sample.im.Message Message)
(defclass org.jamocha.sample.im.BuddyList BuddyList)
(defclass org.jamocha.sample.im.BlockList BlockList)
(defclass org.jamocha.sample.im.User User)
(load-function org.jamocha.sample.im.RouteMessage)
(load-function org.jamocha.sample.im.ReturnMessage)

(defrule BlockedMessages
	?msg <- (Message ;; bind Message object to variable msg
		(senderId ?sender) ;; bind senderId to variable sender
		(receiverId ?receiver)
	)
	(BlockList
		(userId ?receiver) ;; join on senderId
		(blocked $?blocked)
	)
	(test (member$ ?sender $?blocked) ) ;; check if sender is in the list
=>
	(return-msg ?msg) ;; custom function route the message back to sender
	(retract ?msg) ;; remove the message, we're done with it
)
(defrule AllowedMessages
	?msg <- (Message
		(senderId ?sender) ;; bind senderId to variable sender
		(receiverId ?receiver) ;; bind receiverId to variable receiver
	)
	(BlockList
		(userId ?receiver) ;; join on senderId
		(blocked $?blocked)
	)
	(test (not (member$ ?sender $?blocked) ) ) ;; check if sender not in the list
=>
	(route-msg ?msg) ;; custom function for routing message
	(retract ?msg) ;; remove the message, we're done with it
)
