/*
 * Decompiled with CFR 0.152.
 */
package woolfel.rulebenchmark;

import java.io.FileWriter;

public class GenerateRules {
    public static final String LINEBREAK = System.getProperty("line.separator");

    public String generateSimpleRule(int count) {
        StringBuffer buf = new StringBuffer();
        buf.append("(defrule rule" + count);
        buf.append(" (fact nsh" + count + ") => (printout t \"rule" + count);
        buf.append(" was fired\" ))" + LINEBREAK);
        return buf.toString();
    }

    public String generateDefRule(int count) {
        StringBuffer buf = new StringBuffer();
        buf.append("(defrule rule" + count + LINEBREAK);
        buf.append("  (object1" + LINEBREAK);
        buf.append("    (attr1 \"" + count + "\")" + LINEBREAK);
        buf.append("  )" + LINEBREAK);
        buf.append("=>" + LINEBREAK);
        buf.append("  (printout t \"rule" + count + " fired\")" + LINEBREAK);
        buf.append(")" + LINEBREAK);
        return buf.toString();
    }

    public String generateUniqueDeftRule(int count) {
        StringBuffer buf = new StringBuffer();
        buf.append("(defrule rule" + count + LINEBREAK);
        buf.append("  (object" + count + LINEBREAK);
        buf.append("    (attr1 \"" + count + "\")" + LINEBREAK);
        buf.append("  )" + LINEBREAK);
        buf.append("=>" + LINEBREAK);
        buf.append("  (printout t \"rule" + count + " fired\")" + LINEBREAK);
        buf.append(")" + LINEBREAK);
        return buf.toString();
    }

    public String generateRuleWithConditions(int count, int conditions) {
        StringBuffer buf = new StringBuffer();
        buf.append("(defrule rule" + count + LINEBREAK);
        buf.append("  (object" + count + LINEBREAK);
        conditions = conditions++;
        int idx = 0;
        while (idx < conditions) {
            buf.append("    (attr" + idx + " \"" + idx + "\")" + LINEBREAK);
            ++idx;
        }
        buf.append("  )" + LINEBREAK);
        buf.append("=>" + LINEBREAK);
        buf.append("  (printout t \"rule" + count + " fired\")" + LINEBREAK);
        buf.append(")" + LINEBREAK);
        return buf.toString();
    }

    public String getDeffact() {
        StringBuffer buf = new StringBuffer();
        buf.append("(deftemplate object1" + LINEBREAK);
        buf.append("  (slot attr1)" + LINEBREAK);
        buf.append("  (slot attr2)" + LINEBREAK);
        buf.append("  (slot attr3)" + LINEBREAK);
        buf.append("  (slot attr4)" + LINEBREAK);
        buf.append("  (slot attr5)" + LINEBREAK);
        buf.append("  (slot attr6)" + LINEBREAK);
        buf.append("  (slot attr7)" + LINEBREAK);
        buf.append("  (slot attr8)" + LINEBREAK);
        buf.append("  (slot attr9)" + LINEBREAK);
        buf.append("  (slot attr10)" + LINEBREAK);
        buf.append(")" + LINEBREAK);
        return buf.toString();
    }

    public String getDeffact(int count) {
        StringBuffer buf = new StringBuffer();
        buf.append("(deftemplate object" + count + LINEBREAK);
        buf.append("  (slot attr1)" + LINEBREAK);
        buf.append("  (slot attr2)" + LINEBREAK);
        buf.append("  (slot attr3)" + LINEBREAK);
        buf.append("  (slot attr4)" + LINEBREAK);
        buf.append("  (slot attr5)" + LINEBREAK);
        buf.append("  (slot attr6)" + LINEBREAK);
        buf.append("  (slot attr7)" + LINEBREAK);
        buf.append("  (slot attr8)" + LINEBREAK);
        buf.append("  (slot attr9)" + LINEBREAK);
        buf.append("  (slot attr10)" + LINEBREAK);
        buf.append(")" + LINEBREAK);
        return buf.toString();
    }

    public static void main(String[] args) {
        String output = "rules.clp";
        int count = 1000;
        boolean deffact = false;
        boolean unique = false;
        GenerateRules gen = new GenerateRules();
        if (args != null && args.length > 0) {
            if (args[0] != null) {
                count = Integer.parseInt(args[0]);
            }
            if (args.length >= 2 && args[1] != null) {
                output = args[1];
            }
            if (args.length >= 3 && args[2].equals("true")) {
                deffact = true;
            }
            if (args.length >= 4 && args[3].equals("true")) {
                unique = true;
            }
            try {
                int idx;
                FileWriter writer = new FileWriter(output);
                if (unique) {
                    idx = 0;
                    while (idx < count) {
                        writer.write(gen.getDeffact(idx));
                        ++idx;
                    }
                } else {
                    writer.write(gen.getDeffact());
                }
                idx = 0;
                while (idx < count) {
                    if (deffact && !unique) {
                        writer.write(gen.generateDefRule(idx));
                    } else if (deffact && unique) {
                        writer.write(gen.generateUniqueDeftRule(idx));
                    } else {
                        writer.write(gen.generateSimpleRule(idx));
                    }
                    ++idx;
                }
                writer.close();
                System.out.println("Finished generating " + count + " rules.");
                System.out.println("The rules were saved to " + output);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("The utility takes the following parameters");
            System.out.println(" ");
            System.out.println("java woolfel.rulebenchmark.GenerateRules 1000 output.clp(optional) true");
            System.out.println("first parameter - number of rules");
            System.out.println("second parameter - output file");
            System.out.println("third parameter - use deffact instead of ordered facts");
            System.out.println("forth parameter - generate n deffact declaration");
        }
    }
}

