/*
 * Decompiled with CFR 0.152.
 */
package woolfel.rete;

import java.io.FileWriter;
import java.util.Random;

public class SimpleDataGenerator {
    public static final String LINEBREAK = System.getProperty("line.separator");
    public String fileName = null;
    private FileWriter wtr = null;
    public static final String[] countries = new String[]{"US", "BR", "FR", "NZ", "CA", "MX", "CH", "TW", "NU", "IT"};
    public static final String[] gics = new String[]{"25201010", "25201020", "25201030", "25201040", "25201050", "25301010", "25301020", "25301030", "25301040"};
    public static final String[] issuers = new String[]{"AAA", "BBB", "CCC", "DDD", "EEE", "FFF", "GGG", "HHH"};
    public static final String[] exchange = new String[]{"NYSE", "NSDQ", "LNSE", "TKYO", "TWSE", "PSEX", "RMSE"};
    public static final String[] cusips = new String[]{"576335338", "847737565", "584420736", "776465086", "280242230", "334158152"};
    private Random ran = new Random();

    public void setFilename(String name) {
        this.fileName = name;
    }

    public void generate(int count) {
        try {
            this.wtr = new FileWriter(this.fileName);
            this.createDeffacts(count);
            this.wtr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createDeffacts(int count) {
        int idx = 0;
        while (idx < count) {
            String country = countries[this.ran.nextInt(countries.length)];
            String gicsCode = gics[this.ran.nextInt(gics.length - 1)];
            String iss = issuers[this.ran.nextInt(issuers.length - 1)];
            String ex = exchange[this.ran.nextInt(exchange.length - 1)];
            String csip = cusips[this.ran.nextInt(cusips.length - 1)];
            StringBuffer buf = new StringBuffer();
            buf.append("(assert (transaction");
            buf.append(" (accountId \"" + idx + "id\")");
            buf.append(" (buyPrice 55.23)");
            buf.append(" (countryCode \"" + country + "\")");
            buf.append(" (currentPrice 58.95)");
            buf.append(" (cusip " + csip + ")");
            buf.append(" (exchange \"" + ex + "\")");
            buf.append(" (industryGroupID " + gicsCode.substring(0, 4) + ")");
            buf.append(" (industryID " + gicsCode.substring(0, 6) + ")");
            buf.append(" (issuer \"" + iss + "\")");
            buf.append(" (lastPrice 50.12)");
            buf.append(" (sectorID " + gicsCode.substring(0, 2) + ")");
            buf.append(" (shares 100)");
            buf.append(" (subIndustryID " + gicsCode + ")");
            buf.append(" ) )" + LINEBREAK);
            try {
                this.wtr.write(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++idx;
        }
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            int count = Integer.parseInt(args[0]);
            String file = args[1];
            SimpleDataGenerator gen = new SimpleDataGenerator();
            gen.setFilename(file);
            gen.generate(count);
            System.out.println("done!!");
        }
    }
}

