/*
 * Decompiled with CFR 0.152.
 */
package woolfel.rete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashedEqBNode;
import org.jamocha.rete.Index;
import org.jamocha.rete.NotJoin;
import org.jamocha.rete.Rete;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import woolfel.examples.model.TestBean2;

public class NotNodeTest
extends TestCase {
    public NotNodeTest() {
    }

    public NotNodeTest(String arg0) {
        super(arg0);
    }

    public void testCreateNode() {
        Rete engine = new Rete();
        NotJoin bn = new NotJoin(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)bn);
    }

    public void testCreateNode2() {
        Rete engine = new Rete();
        NotJoin bn = new NotJoin(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)bn);
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        NotNodeTest.assertNotNull((Object)dtemp);
        Binding[] binds = new Binding[1];
        Binding b1 = new Binding();
        b1.setLeftIndex(0);
        b1.setIsObjectVar(false);
        b1.setLeftRow(0);
        b1.setRightIndex(0);
        b1.setVarName("var1");
        binds[0] = b1;
        bn.setBindings(binds);
    }

    public void testAssertLeftOne() {
        Rete engine = new Rete();
        NotJoin bn = new NotJoin(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)bn);
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        NotNodeTest.assertNotNull((Object)dtemp);
        Binding[] binds = new Binding[1];
        Binding b1 = new Binding();
        b1.setLeftIndex(0);
        b1.setIsObjectVar(false);
        b1.setLeftRow(0);
        b1.setRightIndex(0);
        b1.setVarName("var1");
        binds[0] = b1;
        bn.setBindings(binds);
        TestBean2 bean = new TestBean2();
        bean.setAttr1("random1");
        bean.setAttr2(101);
        short s = 10001;
        bean.setAttr3(s);
        long l = 10101018L;
        bean.setAttr4(l);
        bean.setAttr5(1010101.0f);
        bean.setAttr6(1001.1001);
        Fact f1 = dtemp.createFact(bean, dc, engine.nextFactId());
        try {
            bn.assertLeft(new Index(new Fact[]{f1}), engine, engine.getWorkingMemory());
            Map bmem = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn);
            NotNodeTest.assertEquals((int)1, (int)bmem.size());
        }
        catch (AssertException e) {
            e.printStackTrace();
        }
    }

    public void testAssertLeftMultiple() {
        Rete engine = new Rete();
        NotJoin bn = new NotJoin(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)bn);
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        NotNodeTest.assertNotNull((Object)dtemp);
        Binding[] binds = new Binding[1];
        Binding b1 = new Binding();
        b1.setLeftIndex(0);
        b1.setIsObjectVar(false);
        b1.setLeftRow(0);
        b1.setRightIndex(0);
        b1.setVarName("var1");
        binds[0] = b1;
        bn.setBindings(binds);
        int count = 10;
        ArrayList<Fact> data = new ArrayList<Fact>();
        int idx = 0;
        while (idx < count) {
            TestBean2 bean = new TestBean2();
            bean.setAttr1("random" + (idx + 1));
            bean.setAttr2(101);
            short s = 10001;
            bean.setAttr3(s);
            long l = 10101018L;
            bean.setAttr4(l);
            bean.setAttr5(1010101.0f);
            bean.setAttr6(1001.1001);
            Fact fact = dtemp.createFact(bean, dc, engine.nextFactId());
            data.add(fact);
            ++idx;
        }
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                Fact f1 = (Fact)itr.next();
                bn.assertLeft(new Index(new Fact[]{f1}), engine, engine.getWorkingMemory());
            }
            catch (AssertException e) {
                e.printStackTrace();
            }
        }
        Map bmem = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn);
        NotNodeTest.assertEquals((int)count, (int)bmem.size());
    }

    public void testAssertRightMultiple() {
        Rete engine = new Rete();
        NotJoin bn = new NotJoin(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)bn);
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        NotNodeTest.assertNotNull((Object)dtemp);
        Binding[] binds = new Binding[1];
        Binding b1 = new Binding();
        b1.setLeftIndex(0);
        b1.setIsObjectVar(false);
        b1.setLeftRow(0);
        b1.setRightIndex(0);
        b1.setVarName("var1");
        binds[0] = b1;
        bn.setBindings(binds);
        int count = 10;
        ArrayList<Fact> data = new ArrayList<Fact>();
        int idx = 0;
        while (idx < count) {
            TestBean2 bean = new TestBean2();
            bean.setAttr1("random" + (idx + 1));
            bean.setAttr2(101);
            short s = 10001;
            bean.setAttr3(s);
            long l = 10101018L;
            bean.setAttr4(l);
            bean.setAttr5(1010101.0f);
            bean.setAttr6(1001.1001);
            Fact fact = dtemp.createFact(bean, dc, engine.nextFactId());
            data.add(fact);
            ++idx;
        }
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                Fact f1 = (Fact)itr.next();
                bn.assertRight(f1, engine, engine.getWorkingMemory());
            }
            catch (AssertException e) {
                e.printStackTrace();
            }
        }
        Map bmem = (Map)engine.getWorkingMemory().getBetaRightMemory(bn);
        NotNodeTest.assertEquals((int)count, (int)bmem.size());
    }

    public void testMatch() {
        Rete engine = new Rete();
        NotJoin bn = new NotJoin(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)bn);
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        NotNodeTest.assertNotNull((Object)dtemp);
        Binding[] binds = new Binding[1];
        Binding2 b1 = new Binding2(9);
        b1.setLeftIndex(0);
        b1.setIsObjectVar(false);
        b1.setLeftRow(0);
        b1.setRightIndex(0);
        b1.setVarName("var1");
        binds[0] = b1;
        bn.setBindings(binds);
        int count = 10;
        ArrayList<Fact> data = new ArrayList<Fact>();
        int idx = 0;
        while (idx < count) {
            TestBean2 bean = new TestBean2();
            bean.setAttr1("random");
            bean.setAttr2(101);
            short s = 10001;
            bean.setAttr3(s);
            long l = 10101018L;
            bean.setAttr4(l);
            bean.setAttr5(1010101.0f);
            bean.setAttr6(1001.1001);
            Fact fact = dtemp.createFact(bean, dc, engine.nextFactId());
            data.add(fact);
            ++idx;
        }
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                Fact f1 = (Fact)itr.next();
                bn.assertLeft(new Index(new Fact[]{f1}), engine, engine.getWorkingMemory());
                bn.assertRight(f1, engine, engine.getWorkingMemory());
            }
            catch (AssertException e) {
                e.printStackTrace();
            }
        }
        Map rbmem = (Map)engine.getWorkingMemory().getBetaRightMemory(bn);
        NotNodeTest.assertEquals((int)count, (int)rbmem.size());
        Map lbmem = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn);
        NotNodeTest.assertEquals((int)count, (int)lbmem.size());
        System.out.println(bn.toPPString());
        for (BetaMemory btm : lbmem.values()) {
            NotNodeTest.assertEquals((int)9, (int)btm.matchCount());
            System.out.println("match count=" + btm.matchCount() + " - " + btm.toPPString());
        }
    }

    public void testAssertAndRetract() {
        Rete engine = new Rete();
        NotJoin bn = new NotJoin(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)bn);
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        NotNodeTest.assertNotNull((Object)dtemp);
        Binding[] binds = new Binding[1];
        Binding2 b1 = new Binding2(9);
        b1.setLeftIndex(0);
        b1.setIsObjectVar(false);
        b1.setLeftRow(0);
        b1.setRightIndex(0);
        b1.setVarName("var1");
        binds[0] = b1;
        bn.setBindings(binds);
        int count = 10;
        ArrayList<Fact> data = new ArrayList<Fact>();
        int idx = 0;
        while (idx < count) {
            TestBean2 bean = new TestBean2();
            bean.setAttr1("random");
            bean.setAttr2(101);
            short s = 10001;
            bean.setAttr3(s);
            long l = 10101018L;
            bean.setAttr4(l);
            bean.setAttr5(1010101.0f);
            bean.setAttr6(1001.1001);
            Fact fact = dtemp.createFact(bean, dc, engine.nextFactId());
            data.add(fact);
            ++idx;
        }
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                Fact f1 = (Fact)itr.next();
                bn.assertLeft(new Index(new Fact[]{f1}), engine, engine.getWorkingMemory());
                bn.assertRight(f1, engine, engine.getWorkingMemory());
            }
            catch (AssertException e) {
                e.printStackTrace();
            }
        }
        Map rbmem = (Map)engine.getWorkingMemory().getBetaRightMemory(bn);
        NotNodeTest.assertEquals((int)count, (int)rbmem.size());
        Map lbmem = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn);
        NotNodeTest.assertEquals((int)count, (int)lbmem.size());
        int retract = 5;
        try {
            int idx2 = 0;
            while (idx2 < 5) {
                Fact f2 = (Fact)data.get(idx2);
                bn.retractRight(f2, engine, engine.getWorkingMemory());
                ++idx2;
            }
        }
        catch (RetractException e) {
            e.printStackTrace();
        }
        rbmem = (Map)engine.getWorkingMemory().getBetaRightMemory(bn);
        NotNodeTest.assertEquals((int)5, (int)rbmem.size());
        lbmem = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn);
        NotNodeTest.assertEquals((int)count, (int)lbmem.size());
        System.out.println(bn.toPPString());
        for (BetaMemory btm : lbmem.values()) {
            System.out.println("match count=" + btm.matchCount() + " - " + btm.toPPString());
        }
    }

    public void testNoMatch() {
        Rete engine = new Rete();
        NotJoin bn = new NotJoin(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)bn);
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        NotNodeTest.assertNotNull((Object)dtemp);
        Binding[] binds = new Binding[1];
        Binding2 b1 = new Binding2(9);
        b1.setLeftIndex(0);
        b1.setIsObjectVar(false);
        b1.setLeftRow(0);
        b1.setRightIndex(0);
        b1.setVarName("var1");
        binds[0] = b1;
        bn.setBindings(binds);
        int count = 10;
        ArrayList<Fact> data = new ArrayList<Fact>();
        int idx = 0;
        while (idx < count) {
            TestBean2 bean = new TestBean2();
            bean.setAttr1("random" + idx);
            bean.setAttr2(101 + idx);
            short s = 10001;
            bean.setAttr3(s);
            long l = 10101018 + idx;
            bean.setAttr4(l);
            bean.setAttr5(1010101.0f);
            bean.setAttr6(1001.1001);
            Fact fact = dtemp.createFact(bean, dc, engine.nextFactId());
            data.add(fact);
            ++idx;
        }
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                Fact f1 = (Fact)itr.next();
                bn.assertLeft(new Index(new Fact[]{f1}), engine, engine.getWorkingMemory());
                bn.assertRight(f1, engine, engine.getWorkingMemory());
            }
            catch (AssertException e) {
                e.printStackTrace();
            }
        }
        Map rbmem = (Map)engine.getWorkingMemory().getBetaRightMemory(bn);
        NotNodeTest.assertEquals((int)count, (int)rbmem.size());
        Map lbmem = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn);
        NotNodeTest.assertEquals((int)count, (int)lbmem.size());
        System.out.println(bn.toPPString());
        for (BetaMemory btm : lbmem.values()) {
            NotNodeTest.assertEquals((int)0, (int)btm.matchCount());
            System.out.println("match count=" + btm.matchCount() + " - " + btm.toPPString());
        }
    }

    public void testPropogateNoMatch() {
        System.out.println("testPropogateNoMatch");
        Rete engine = new Rete();
        NotJoin nj = new NotJoin(engine.nextNodeId());
        HashedEqBNode bn2 = new HashedEqBNode(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)nj);
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        NotNodeTest.assertNotNull((Object)dtemp);
        Binding[] binds = new Binding[1];
        Binding2 b1 = new Binding2(9);
        b1.setLeftIndex(0);
        b1.setIsObjectVar(false);
        b1.setLeftRow(0);
        b1.setRightIndex(0);
        b1.setVarName("var1");
        binds[0] = b1;
        Binding[] binds2 = new Binding[1];
        Binding b2 = new Binding();
        b2.setLeftIndex(1);
        b2.setIsObjectVar(false);
        b2.setLeftRow(0);
        b2.setRightIndex(1);
        b2.setVarName("var2");
        binds2[0] = b2;
        nj.setBindings(binds);
        bn2.setBindings(binds2);
        try {
            nj.addSuccessorNode(bn2, engine, engine.getWorkingMemory());
        }
        catch (AssertException e) {
            e.printStackTrace();
        }
        int count = 10;
        ArrayList<Fact> data = new ArrayList<Fact>();
        int idx = 0;
        while (idx < count) {
            TestBean2 bean = new TestBean2();
            bean.setAttr1("random" + idx);
            bean.setAttr2(101 + idx);
            short s = 10001;
            bean.setAttr3(s);
            long l = 10101018 + idx;
            bean.setAttr4(l);
            bean.setAttr5(1010101.0f);
            bean.setAttr6(1001.1001);
            Fact fact = dtemp.createFact(bean, dc, engine.nextFactId());
            data.add(fact);
            ++idx;
        }
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                Fact f1 = (Fact)itr.next();
                nj.assertLeft(new Index(new Fact[]{f1}), engine, engine.getWorkingMemory());
                nj.assertRight(f1, engine, engine.getWorkingMemory());
            }
            catch (AssertException e) {
                e.printStackTrace();
            }
        }
        Map rbmem = (Map)engine.getWorkingMemory().getBetaRightMemory(nj);
        NotNodeTest.assertEquals((int)count, (int)rbmem.size());
        Map lbmem = (Map)engine.getWorkingMemory().getBetaLeftMemory(nj);
        NotNodeTest.assertEquals((int)count, (int)lbmem.size());
        System.out.println(nj.toPPString());
        for (BetaMemory btm : lbmem.values()) {
            NotNodeTest.assertEquals((int)0, (int)btm.matchCount());
            System.out.println("match count=" + btm.matchCount() + " - " + btm.toPPString());
        }
        Map lbmem2 = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn2);
        NotNodeTest.assertEquals((int)count, (int)lbmem2.size());
        System.out.println(bn2.toPPString());
        Iterator mitr2 = lbmem2.values().iterator();
    }

    public void testPropogateChange() {
        System.out.println("testPropogateChange");
        Rete engine = new Rete();
        NotJoin nj = new NotJoin(engine.nextNodeId());
        HashedEqBNode bn2 = new HashedEqBNode(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)nj);
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        NotNodeTest.assertNotNull((Object)dtemp);
        Binding[] binds = new Binding[1];
        Binding2 b1 = new Binding2(9);
        b1.setLeftIndex(0);
        b1.setIsObjectVar(false);
        b1.setLeftRow(0);
        b1.setRightIndex(0);
        b1.setVarName("var1");
        binds[0] = b1;
        Binding[] binds2 = new Binding[1];
        Binding2 b2 = new Binding2(9);
        b2.setLeftIndex(1);
        b2.setIsObjectVar(false);
        b2.setLeftRow(0);
        b2.setRightIndex(1);
        b2.setVarName("var2");
        binds2[0] = b2;
        nj.setBindings(binds);
        bn2.setBindings(binds2);
        try {
            nj.addSuccessorNode(bn2, engine, engine.getWorkingMemory());
        }
        catch (AssertException e) {
            e.printStackTrace();
        }
        int count = 2;
        ArrayList<Fact> data = new ArrayList<Fact>();
        int idx = 0;
        while (idx < count) {
            TestBean2 bean = new TestBean2();
            bean.setAttr1("random");
            bean.setAttr2(101 + idx);
            short s = 10001;
            bean.setAttr3(s);
            long l = 10101018 + idx;
            bean.setAttr4(l);
            bean.setAttr5(1010101.0f);
            bean.setAttr6(1001.1001);
            Fact fact = dtemp.createFact(bean, dc, engine.nextFactId());
            data.add(fact);
            ++idx;
        }
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                Fact f1 = (Fact)itr.next();
                nj.assertLeft(new Index(new Fact[]{f1}), engine, engine.getWorkingMemory());
            }
            catch (AssertException e) {
                e.printStackTrace();
            }
        }
        Map lbmem = (Map)engine.getWorkingMemory().getBetaLeftMemory(nj);
        NotNodeTest.assertEquals((int)count, (int)lbmem.size());
        Map lbmem2 = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn2);
        NotNodeTest.assertEquals((int)2, (int)lbmem2.size());
        itr = data.iterator();
        while (itr.hasNext()) {
            try {
                Fact f1 = (Fact)itr.next();
                nj.assertRight(f1, engine, engine.getWorkingMemory());
            }
            catch (AssertException e) {
                e.printStackTrace();
            }
        }
        Map rbmem = (Map)engine.getWorkingMemory().getBetaRightMemory(nj);
        NotNodeTest.assertEquals((int)count, (int)rbmem.size());
        lbmem2 = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn2);
        NotNodeTest.assertEquals((int)0, (int)lbmem2.size());
    }

    public void testPropogateChange2() {
        System.out.println("testPropogateChange2");
        Rete engine = new Rete();
        NotJoin nj = new NotJoin(engine.nextNodeId());
        HashedEqBNode bn2 = new HashedEqBNode(engine.nextNodeId());
        NotNodeTest.assertNotNull((Object)nj);
        NotNodeTest.assertNotNull((Object)bn2);
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        NotNodeTest.assertNotNull((Object)dtemp);
        Binding[] binds = new Binding[1];
        Binding2 b1 = new Binding2(9);
        b1.setLeftIndex(0);
        b1.setIsObjectVar(false);
        b1.setLeftRow(0);
        b1.setRightIndex(0);
        b1.setVarName("var1");
        binds[0] = b1;
        Binding[] binds2 = new Binding[1];
        Binding2 b2 = new Binding2(9);
        b2.setLeftIndex(1);
        b2.setIsObjectVar(false);
        b2.setLeftRow(0);
        b2.setRightIndex(1);
        b2.setVarName("var2");
        binds2[0] = b2;
        nj.setBindings(binds);
        bn2.setBindings(binds2);
        try {
            nj.addSuccessorNode(bn2, engine, engine.getWorkingMemory());
        }
        catch (AssertException e) {
            e.printStackTrace();
        }
        int count = 5;
        ArrayList<Fact> data = new ArrayList<Fact>();
        int idx = 0;
        while (idx < count) {
            TestBean2 bean = new TestBean2();
            bean.setAttr1("random");
            bean.setAttr2(101 + idx);
            short s = 10001;
            bean.setAttr3(s);
            long l = 10101018 + idx;
            bean.setAttr4(l);
            bean.setAttr5(1010101.0f);
            bean.setAttr6(1001.1001);
            Fact fact = dtemp.createFact(bean, dc, engine.nextFactId());
            data.add(fact);
            ++idx;
        }
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                Fact f1 = (Fact)itr.next();
                nj.assertLeft(new Index(new Fact[]{f1}), engine, engine.getWorkingMemory());
            }
            catch (AssertException e) {
                e.printStackTrace();
            }
        }
        Map lbmem = (Map)engine.getWorkingMemory().getBetaLeftMemory(nj);
        NotNodeTest.assertEquals((int)count, (int)lbmem.size());
        Map lbmem2 = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn2);
        NotNodeTest.assertEquals((int)count, (int)lbmem2.size());
        try {
            Fact f = (Fact)data.get(0);
            nj.assertRight(f, engine, engine.getWorkingMemory());
        }
        catch (AssertException e) {
            e.printStackTrace();
        }
        Map rbmem = (Map)engine.getWorkingMemory().getBetaRightMemory(nj);
        NotNodeTest.assertEquals((int)1, (int)rbmem.size());
        lbmem2 = (Map)engine.getWorkingMemory().getBetaLeftMemory(bn2);
        NotNodeTest.assertEquals((int)1, (int)lbmem2.size());
        try {
            int idx2 = 1;
            while (idx2 < count) {
                Fact f = (Fact)data.get(idx2);
                nj.assertRight(f, engine, engine.getWorkingMemory());
                ++idx2;
            }
        }
        catch (AssertException e) {
            e.printStackTrace();
        }
        System.out.println(nj.toPPString());
        for (BetaMemory btm : lbmem.values()) {
            System.out.println("match count=" + btm.matchCount() + " - " + btm.toPPString());
        }
    }
}

