/*
 * Decompiled with CFR 0.152.
 */
package woolfel.rete;

import junit.framework.TestCase;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Slot;
import woolfel.examples.model.Account;
import woolfel.examples.model.TestBean2;

public class DeftemplateTest
extends TestCase {
    public DeftemplateTest() {
    }

    public DeftemplateTest(String arg0) {
        super(arg0);
    }

    public void testCreateTemplateFromClass() {
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        DeftemplateTest.assertNotNull((Object)dtemp);
        System.out.println(dtemp.toPPString());
    }

    public void testCreateTemplateFromSlots() {
        Slot[] slots = new Slot[4];
        slots[0] = new Slot();
        slots[0].setId(0);
        slots[0].setName("col1");
        slots[0].setValueType(1);
        slots[1] = new Slot();
        slots[1].setId(1);
        slots[1].setName("col2");
        slots[1].setValueType(5);
        slots[2] = new Slot();
        slots[2].setId(2);
        slots[2].setName("col3");
        slots[2].setValueType(9);
        slots[3] = new Slot();
        slots[3].setId(3);
        slots[3].setName("col4");
        slots[3].setValueType(3);
        Deftemplate dtemp = new Deftemplate("template1", null, slots);
        DeftemplateTest.assertNotNull((Object)dtemp);
        DeftemplateTest.assertEquals((int)4, (int)dtemp.getNumberOfSlots());
        System.out.println(dtemp.toPPString());
    }

    public void testCreateTemplate2() {
        Defclass dc = new Defclass(Account.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("account");
        DeftemplateTest.assertNotNull((Object)dtemp);
        DeftemplateTest.assertNotNull((Object)dtemp.toPPString());
        System.out.println(dtemp.toPPString());
    }

    public void testCreateFactFromInstance() {
        Defclass dc = new Defclass(TestBean2.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate("testBean2");
        TestBean2 bean = new TestBean2();
        bean.setAttr1("random1");
        bean.setAttr2(101);
        short s = 10001;
        bean.setAttr3(s);
        long l = 10101018L;
        bean.setAttr4(l);
        bean.setAttr5(1010101.0f);
        bean.setAttr6(1001.1001);
        Fact fact = dtemp.createFact(bean, dc, 0L);
        DeftemplateTest.assertNotNull((Object)fact);
        System.out.println(fact.toFactString());
    }

    public void testSlotID() {
        Slot[] slots = new Slot[4];
        slots[0] = new Slot();
        slots[0].setId(0);
        slots[0].setName("col1");
        slots[0].setValueType(1);
        slots[1] = new Slot();
        slots[1].setId(1);
        slots[1].setName("col2");
        slots[1].setValueType(5);
        slots[2] = new Slot();
        slots[2].setId(2);
        slots[2].setName("col3");
        slots[2].setValueType(9);
        slots[3] = new Slot();
        slots[3].setId(3);
        slots[3].setName("col4");
        slots[3].setValueType(3);
        Deftemplate dtemp = new Deftemplate("template1", null, slots);
        DeftemplateTest.assertNotNull((Object)dtemp);
        DeftemplateTest.assertEquals((int)4, (int)dtemp.getNumberOfSlots());
        System.out.println(dtemp.toPPString());
        Slot[] theslots = dtemp.getAllSlots();
        int idx = 0;
        while (idx < theslots.length) {
            Slot aslot = theslots[idx];
            DeftemplateTest.assertEquals((int)idx, (int)aslot.getId());
            System.out.println("slot id: " + aslot.getId());
            ++idx;
        }
    }

    public void testCreateTemplateSlot() {
        String acc = "account";
        Defclass dc = new Defclass(Account.class);
        Deftemplate dtemp = (Deftemplate)dc.createDeftemplate(acc);
        DeftemplateTest.assertNotNull((Object)dtemp);
        DeftemplateTest.assertNotNull((Object)dtemp.toPPString());
        DeftemplateTest.assertEquals((String)acc, (String)dtemp.getName());
        System.out.println(dtemp.toPPString());
        Slot[] theslots = dtemp.getAllSlots();
        int idx = 0;
        while (idx < theslots.length) {
            Slot aslot = theslots[idx];
            DeftemplateTest.assertEquals((int)idx, (int)aslot.getId());
            System.out.println("slot id: " + aslot.getId());
            ++idx;
        }
    }
}

