/*
 * Decompiled with CFR 0.152.
 */
package woolfel.rete;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.jamocha.parser.clips.CLIPSParser;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Function;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnValue;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rule.Defrule;
import org.jamocha.rule.FunctionAction;
import woolfel.examples.model.Account;

public class AssertWRules {
    private static Random ran = new Random();

    public void parse(Rete engine, CLIPSParser parser, List factlist) {
        Object itm = null;
        try {
            while ((itm = parser.basicExpr()) != null) {
                if (itm instanceof Defrule) {
                    Defrule rule = (Defrule)itm;
                    engine.getRuleCompiler().addRule(rule);
                    continue;
                }
                if (itm instanceof Deftemplate) {
                    Deftemplate dt = (Deftemplate)itm;
                    System.out.println("template=" + dt.getName());
                    engine.declareTemplate(dt);
                    continue;
                }
                if (itm instanceof FunctionAction) {
                    FunctionAction fa = (FunctionAction)itm;
                    continue;
                }
                if (!(itm instanceof Function)) continue;
                ReturnVector rv = ((Function)itm).executeFunction(engine, null);
                Iterator itr = rv.getIterator();
                while (itr.hasNext()) {
                    ReturnValue rval = (ReturnValue)itr.next();
                    System.out.println(rval.getStringValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String rulefile = "./benchmark_files/account_5.clp";
        ArrayList<Account> objects = new ArrayList<Account>();
        AssertWRules awr = new AssertWRules();
        Runtime rt = Runtime.getRuntime();
        long total1 = rt.totalMemory();
        long free1 = rt.freeMemory();
        long used1 = total1 - free1;
        int count = 5000;
        System.out.println("loading file " + rulefile);
        System.out.println("Used memory before creating objects " + used1 + " bytes " + used1 / 1024L + " Kb");
        int idx = 0;
        while (idx < count) {
            Account acc = new Account();
            acc.setAccountId("acc" + idx);
            acc.setAccountType("standard");
            acc.setFirst(String.valueOf(ran.nextInt(100000)));
            acc.setLast(String.valueOf(ran.nextInt(100000)));
            acc.setMiddle(String.valueOf(ran.nextInt(100000)));
            acc.setOfficeCode(String.valueOf(ran.nextInt(100000)));
            acc.setRegionCode(String.valueOf(ran.nextInt(100000)));
            acc.setStatus("active");
            acc.setTitle("mr");
            acc.setUsername(String.valueOf(ran.nextInt(100000)));
            acc.setAreaCode(String.valueOf(ran.nextInt(999)));
            acc.setExchange(String.valueOf(ran.nextInt(999)));
            acc.setNumber(String.valueOf(ran.nextInt(999)));
            acc.setExt(String.valueOf(ran.nextInt(9999)));
            objects.add(acc);
            ++idx;
        }
        long total2 = rt.totalMemory();
        long free2 = rt.freeMemory();
        long used2 = total2 - free2;
        System.out.println("Used memory after creating objects " + used2 + " bytes " + used2 / 1024L + " Kb " + used2 / 1024L / 1024L + " Mb");
        int loop = 5;
        long ETTotal = 0L;
        int idx2 = 0;
        while (idx2 < loop) {
            Rete engine = new Rete();
            engine.declareObject(Account.class, "Account");
            try {
                FileInputStream freader = new FileInputStream(rulefile);
                CLIPSParser parser = new CLIPSParser(engine, freader);
                Object item = null;
                ArrayList list = new ArrayList();
                long start = System.currentTimeMillis();
                awr.parse(engine, parser, list);
                long end = System.currentTimeMillis();
                long el = end - start;
                rt.gc();
                System.out.println("time to parse rules " + el + " ms");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Iterator itr = objects.iterator();
            long start2 = System.currentTimeMillis();
            try {
                while (itr.hasNext()) {
                    engine.assertObject(itr.next(), "Account", false, false);
                }
            }
            catch (AssertException e) {
                e.printStackTrace();
            }
            long end2 = System.currentTimeMillis();
            long start3 = System.currentTimeMillis();
            int fired = 0;
            try {
                fired = engine.fire();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long end3 = System.currentTimeMillis();
            long total3 = rt.totalMemory();
            long free3 = rt.freeMemory();
            long used3 = total3 - free3;
            System.out.println("Number of rules: " + engine.getCurrentFocus().getRuleCount());
            System.out.println("rules fired " + fired);
            System.out.println("Used memory after asserting objects " + used3 + " bytes " + used3 / 1024L + " Kb " + used3 / 1024L / 1024L + " Mb");
            System.out.println("number of facts " + engine.getObjectCount());
            System.out.println("memory used by facts " + (used3 - used2) / 1024L / 1024L + " Mb");
            System.out.println("elapsed time to assert " + (end2 - start2) + " ms");
            System.out.println("elapsed time to fire " + (end3 - start3) + " ms");
            ETTotal += end2 - start2;
            engine.close();
            engine.clearAll();
            rt.gc();
            ++idx2;
        }
        System.out.println("Average ET to assert " + ETTotal / (long)loop + " ms");
    }
}

