/*
 * Decompiled with CFR 0.152.
 */
package woolfel.rete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.jamocha.rete.Rete;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import woolfel.examples.model.Account;

public class AssertRetractTest
extends TestCase {
    public AssertRetractTest() {
    }

    public AssertRetractTest(String arg0) {
        super(arg0);
    }

    public void testRetractNoShadow() {
        System.out.println("testRetractNoShadow");
        Random ran = new Random();
        ArrayList<Account> objects = new ArrayList<Account>();
        Runtime rt = Runtime.getRuntime();
        long total1 = rt.totalMemory();
        long free1 = rt.freeMemory();
        long used1 = total1 - free1;
        int count = 50000;
        System.out.println("Used memory before creating objects " + used1 + " bytes " + used1 / 1024L + " Kb");
        int idx = 0;
        while (idx < count) {
            Account acc = new Account();
            acc.setAccountId(String.valueOf(ran.nextInt(100000)));
            acc.setAccountType(String.valueOf(ran.nextInt(100000)));
            acc.setFirst(String.valueOf(ran.nextInt(100000)));
            acc.setLast(String.valueOf(ran.nextInt(100000)));
            acc.setMiddle(String.valueOf(ran.nextInt(100000)));
            acc.setOfficeCode(String.valueOf(ran.nextInt(100000)));
            acc.setRegionCode(String.valueOf(ran.nextInt(100000)));
            acc.setStatus(String.valueOf(ran.nextInt(100000)));
            acc.setTitle(String.valueOf(ran.nextInt(100000)));
            acc.setUsername(String.valueOf(ran.nextInt(100000)));
            acc.setAreaCode(String.valueOf(ran.nextInt(999)));
            acc.setExchange(String.valueOf(ran.nextInt(999)));
            acc.setNumber(String.valueOf(ran.nextInt(999)));
            acc.setExt(String.valueOf(ran.nextInt(9999)));
            objects.add(acc);
            ++idx;
        }
        long total2 = rt.totalMemory();
        long free2 = rt.freeMemory();
        long used2 = total2 - free2;
        System.out.println("Used memory after creating objects " + used2 + " bytes " + used2 / 1024L + " Kb " + used2 / 1024L / 1024L + " Mb");
        Rete engine = new Rete();
        engine.declareObject(Account.class);
        Iterator itr = objects.iterator();
        long start = System.currentTimeMillis();
        try {
            while (itr.hasNext()) {
                engine.assertObject(itr.next(), null, false, false);
            }
        }
        catch (AssertException e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        long assertET = end - start;
        long total3 = rt.totalMemory();
        long free3 = rt.freeMemory();
        long used3 = total3 - free3;
        rt.gc();
        System.out.println("Used memory after asserting objects " + used3 + " bytes " + used3 / 1024L + " Kb " + used3 / 1024L / 1024L + " Mb");
        System.out.println("number of facts " + engine.getObjectCount());
        System.out.println("memory used by facts " + (used3 - used2) / 1024L / 1024L + " Mb");
        System.out.println("elapsed time is assert " + assertET + " ms");
        Iterator itr2 = objects.iterator();
        long retstart = System.currentTimeMillis();
        try {
            while (itr2.hasNext()) {
                engine.retractObject(itr2.next());
            }
        }
        catch (RetractException e) {
            e.printStackTrace();
        }
        long retend = System.currentTimeMillis();
        long retractET = retend - retstart;
        long total4 = rt.totalMemory();
        long free4 = rt.freeMemory();
        long used4 = total4 - free4;
        objects.clear();
        engine.clearAll();
        engine.close();
        rt.gc();
        System.out.println("elapsed time to retract " + retractET + " ms");
    }

    public void testRetractWithShadow() {
        System.out.println("testRetractWithShadow");
        Random ran = new Random();
        ArrayList<Account> objects = new ArrayList<Account>();
        Runtime rt = Runtime.getRuntime();
        long total1 = rt.totalMemory();
        long free1 = rt.freeMemory();
        long used1 = total1 - free1;
        int count = 5000;
        System.out.println("Used memory before creating objects " + used1 + " bytes " + used1 / 1024L + " Kb");
        int idx = 0;
        while (idx < count) {
            Account acc = new Account();
            acc.setAccountId(String.valueOf(ran.nextInt(100000)));
            acc.setAccountType(String.valueOf(ran.nextInt(100000)));
            acc.setFirst(String.valueOf(ran.nextInt(100000)));
            acc.setLast(String.valueOf(ran.nextInt(100000)));
            acc.setMiddle(String.valueOf(ran.nextInt(100000)));
            acc.setOfficeCode(String.valueOf(ran.nextInt(100000)));
            acc.setRegionCode(String.valueOf(ran.nextInt(100000)));
            acc.setStatus(String.valueOf(ran.nextInt(100000)));
            acc.setTitle(String.valueOf(ran.nextInt(100000)));
            acc.setUsername(String.valueOf(ran.nextInt(100000)));
            acc.setAreaCode(String.valueOf(ran.nextInt(999)));
            acc.setExchange(String.valueOf(ran.nextInt(999)));
            acc.setNumber(String.valueOf(ran.nextInt(999)));
            acc.setExt(String.valueOf(ran.nextInt(9999)));
            objects.add(acc);
            ++idx;
        }
        long total2 = rt.totalMemory();
        long free2 = rt.freeMemory();
        long used2 = total2 - free2;
        System.out.println("Used memory after creating objects " + used2 + " bytes " + used2 / 1024L + " Kb " + used2 / 1024L / 1024L + " Mb");
        Rete engine = new Rete();
        engine.declareObject(Account.class);
        Iterator itr = objects.iterator();
        long start = System.currentTimeMillis();
        try {
            while (itr.hasNext()) {
                engine.assertObject(itr.next(), null, false, true);
            }
        }
        catch (AssertException e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        long assertET = end - start;
        long total3 = rt.totalMemory();
        long free3 = rt.freeMemory();
        long used3 = total3 - free3;
        rt.gc();
        System.out.println("Used memory after asserting objects " + used3 + " bytes " + used3 / 1024L + " Kb " + used3 / 1024L / 1024L + " Mb");
        System.out.println("number of facts " + engine.getObjectCount());
        System.out.println("memory used by facts " + (used3 - used2) / 1024L / 1024L + " Mb");
        System.out.println("elapsed time is assert " + assertET + " ms");
        Iterator itr2 = objects.iterator();
        long retstart = System.currentTimeMillis();
        try {
            while (itr2.hasNext()) {
                engine.retractObject(itr2.next());
            }
        }
        catch (RetractException e) {
            e.printStackTrace();
        }
        long retend = System.currentTimeMillis();
        long retractET = retend - retstart;
        long total4 = rt.totalMemory();
        long free4 = rt.freeMemory();
        long used4 = total4 - free4;
        objects.clear();
        rt.gc();
        System.out.println("elapsed time to retract " + retractET + " ms");
        AssertRetractTest.assertTrue((assertET > retractET * 4L ? 1 : 0) != 0);
    }
}

