/*
 * Decompiled with CFR 0.152.
 */
package woolfel.rete;

import junit.framework.TestCase;
import org.jamocha.rete.Rete;
import org.jamocha.rete.exception.AssertException;
import woolfel.examples.model.Account;
import woolfel.examples.model.BackupAccount;
import woolfel.examples.model.DeletedAccount;
import woolfel.examples.model.IAccount;
import woolfel.examples.model.TestBean3;

public class AssertObjectTest
extends TestCase {
    public AssertObjectTest() {
    }

    public AssertObjectTest(String arg0) {
        super(arg0);
    }

    public void testSimpleAssert() {
        System.out.println("start testSimpleAssert");
        Rete engine = new Rete();
        engine.declareObject(Account.class);
        AssertObjectTest.assertNotNull((Object)engine);
        Account acc1 = new Account();
        acc1.setAccountId("1234");
        acc1.setAccountType("new");
        acc1.setFirst("fName");
        acc1.setLast("lName");
        acc1.setMiddle("m");
        acc1.setOfficeCode("MA");
        acc1.setRegionCode("NE");
        acc1.setStatus("active");
        acc1.setTitle("MR");
        acc1.setUsername("user1");
        try {
            engine.assertObject(acc1, null, false, true);
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertEquals((int)1, (int)engine.getObjectCount());
            System.out.println("Number of facts: " + engine.getDefclasses().size());
        }
        catch (AssertException e) {
            AssertObjectTest.fail();
        }
    }

    public void testAssertTwoObjects() {
        System.out.println("start testAssertTwoObjects");
        Rete engine = new Rete();
        engine.declareObject(Account.class);
        engine.declareObject(TestBean3.class);
        AssertObjectTest.assertNotNull((Object)engine);
        Account acc1 = new Account();
        acc1.setAccountId("1234");
        acc1.setAccountType("new");
        acc1.setFirst("fName");
        acc1.setLast("lName");
        acc1.setMiddle("m");
        acc1.setOfficeCode("MA");
        acc1.setRegionCode("NE");
        acc1.setStatus("active");
        acc1.setTitle("MR");
        acc1.setUsername("user1");
        TestBean3 b = new TestBean3();
        b.setCount(3);
        b.setFloat(10000.0f);
        try {
            long start = System.nanoTime();
            engine.assertObject(acc1, null, false, true);
            int count = engine.getObjectCount();
            engine.assertObject(b, null, false, true);
            int count2 = engine.getObjectCount();
            long end = System.nanoTime();
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertEquals((int)1, (int)count);
            AssertObjectTest.assertEquals((int)2, (int)count2);
            System.out.println("Number of facts: " + count);
            System.out.println("Number of facts: " + count2);
            System.out.println("ET: " + (end - start) + " ns");
            double el = ((double)end - (double)start) / 100000.0;
            System.out.println("ET: " + el + " ms");
        }
        catch (AssertException e) {
            AssertObjectTest.fail();
        }
    }

    public void testRepeatedAssert() {
        System.out.println("start testRepatedAssert");
        Rete engine = new Rete();
        engine.declareObject(Account.class);
        engine.declareObject(TestBean3.class);
        AssertObjectTest.assertNotNull((Object)engine);
        Account acc1 = new Account();
        acc1.setAccountId("1234");
        acc1.setAccountType("new");
        acc1.setFirst("fName");
        acc1.setLast("lName");
        acc1.setMiddle("m");
        acc1.setOfficeCode("MA");
        acc1.setRegionCode("NE");
        acc1.setStatus("active");
        acc1.setTitle("MR");
        acc1.setUsername("user1");
        TestBean3 b = new TestBean3();
        b.setCount(3);
        b.setFloat(10000.0f);
        try {
            long start = System.nanoTime();
            int idx = 0;
            while (idx < 100) {
                engine.assertObject(acc1, null, false, true);
                ++idx;
            }
            int count = engine.getObjectCount();
            int idx2 = 0;
            while (idx2 < 100) {
                engine.assertObject(b, null, false, true);
                ++idx2;
            }
            int count2 = engine.getObjectCount();
            long end = System.nanoTime();
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertEquals((int)1, (int)count);
            AssertObjectTest.assertEquals((int)2, (int)count2);
            System.out.println("Number of facts: " + count);
            System.out.println("Number of facts: " + count2);
            System.out.println("ET: " + (end - start) + " ns");
            double el = ((double)end - (double)start) / 100000.0;
            System.out.println("ET: " + el + " ms");
        }
        catch (AssertException e) {
            AssertObjectTest.fail();
        }
    }

    public void testAssertWithInterface() {
        System.out.println("-----------------------------");
        System.out.println("start testAssertWithInterface");
        Rete engine = new Rete();
        engine.declareObject(IAccount.class, "account");
        AssertObjectTest.assertNotNull((Object)engine);
        Account acc1 = new Account();
        acc1.setAccountId("1234");
        acc1.setAccountType("new");
        acc1.setFirst("fName");
        acc1.setLast("lName");
        acc1.setMiddle("m");
        acc1.setOfficeCode("MA");
        acc1.setRegionCode("NE");
        acc1.setStatus("active");
        acc1.setTitle("MR");
        acc1.setUsername("user1");
        try {
            engine.assertObject(acc1, "account", false, true);
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertEquals((int)1, (int)engine.getObjectCount());
            System.out.println("Number of facts: " + engine.getObjectCount());
        }
        catch (AssertException e) {
            AssertObjectTest.fail();
        }
    }

    public void testAssertWithSubclass() {
        System.out.println("start testAssertWithSubclass");
        Rete engine = new Rete();
        engine.declareObject(IAccount.class, "account");
        AssertObjectTest.assertNotNull((Object)engine);
        BackupAccount acc1 = new BackupAccount();
        acc1.setAccountId("1234");
        acc1.setAccountType("new");
        acc1.setFirst("fName");
        acc1.setLast("lName");
        acc1.setMiddle("m");
        acc1.setOfficeCode("MA");
        acc1.setRegionCode("NE");
        acc1.setStatus("active");
        acc1.setTitle("MR");
        acc1.setUsername("user1");
        try {
            engine.assertObject(acc1, "account", false, true);
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertEquals((int)1, (int)engine.getObjectCount());
            System.out.println("Number of facts: " + engine.getObjectCount());
        }
        catch (AssertException e) {
            AssertObjectTest.fail();
        }
    }

    public void testAssertWithSubclass2() {
        System.out.println("\nstart testAssertWithSubclass2");
        Rete engine = new Rete();
        engine.declareObject(IAccount.class, "account");
        engine.declareObject(BackupAccount.class, "backupAccount");
        AssertObjectTest.assertNotNull((Object)engine);
        BackupAccount acc1 = new BackupAccount();
        acc1.setAccountId("1234");
        acc1.setAccountType("new");
        acc1.setFirst("fName");
        acc1.setLast("lName");
        acc1.setMiddle("m");
        acc1.setOfficeCode("MA");
        acc1.setRegionCode("NE");
        acc1.setStatus("active");
        acc1.setTitle("MR");
        acc1.setUsername("user1");
        try {
            engine.assertObject(acc1, "backupAccount", false, true);
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertEquals((int)1, (int)engine.getObjectCount());
            System.out.println("Number of facts: " + engine.getObjectCount());
        }
        catch (AssertException e) {
            AssertObjectTest.fail();
        }
    }

    public void testAssertWithSubclass3() {
        System.out.println("\nstart testAssertWithSubclass3");
        Rete engine = new Rete();
        engine.declareObject(IAccount.class, "account");
        engine.declareObject(BackupAccount.class, "backupAccount");
        AssertObjectTest.assertNotNull((Object)engine);
        BackupAccount acc1 = new BackupAccount();
        acc1.setAccountId("1234");
        acc1.setAccountType("new");
        acc1.setFirst("fName");
        acc1.setLast("lName");
        acc1.setMiddle("m");
        acc1.setOfficeCode("MA");
        acc1.setRegionCode("NE");
        acc1.setStatus("active");
        acc1.setTitle("MR");
        acc1.setUsername("user1");
        try {
            engine.assertObject(acc1, "account", false, true);
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertEquals((int)1, (int)engine.getObjectCount());
            System.out.println("Number of facts: " + engine.getObjectCount());
        }
        catch (AssertException e) {
            AssertObjectTest.fail();
        }
    }

    public void testAssertWithSubclassWithParent() {
        System.out.println("\nstart testAssertWithSubclassWithParent");
        Rete engine = new Rete();
        engine.declareObject(IAccount.class, "account");
        engine.declareObject(BackupAccount.class, "backupAccount", "account");
        AssertObjectTest.assertNotNull((Object)engine);
        BackupAccount acc1 = new BackupAccount();
        acc1.setAccountId("1234");
        acc1.setAccountType("new");
        acc1.setFirst("fName");
        acc1.setLast("lName");
        acc1.setMiddle("m");
        acc1.setOfficeCode("MA");
        acc1.setRegionCode("NE");
        acc1.setStatus("active");
        acc1.setTitle("MR");
        acc1.setUsername("user1");
        try {
            engine.assertObject(acc1, "backupAccount", false, true);
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertEquals((int)1, (int)engine.getObjectCount());
            System.out.println("Number of facts: " + engine.getObjectCount());
        }
        catch (AssertException e) {
            AssertObjectTest.fail();
        }
    }

    public void testAssertWithSubclassWithParent2() {
        System.out.println("\nstart testAssertWithSubclassWithParent2");
        Rete engine = new Rete();
        engine.declareObject(IAccount.class, "account");
        engine.declareObject(BackupAccount.class, null, "account");
        AssertObjectTest.assertNotNull((Object)engine);
        BackupAccount acc1 = new BackupAccount();
        acc1.setAccountId("1234");
        acc1.setAccountType("new");
        acc1.setFirst("fName");
        acc1.setLast("lName");
        acc1.setMiddle("m");
        acc1.setOfficeCode("MA");
        acc1.setRegionCode("NE");
        acc1.setStatus("active");
        acc1.setTitle("MR");
        acc1.setUsername("user1");
        try {
            engine.assertObject(acc1, null, false, true);
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertEquals((int)1, (int)engine.getObjectCount());
            System.out.println("Number of facts: " + engine.getObjectCount());
        }
        catch (AssertException e) {
            AssertObjectTest.fail();
        }
    }

    public void testAssertWithSubclassWithParent3() {
        System.out.println("\nstart testAssertWithSubclassWithParent3");
        Rete engine = new Rete();
        engine.declareObject(IAccount.class, "account");
        engine.declareObject(BackupAccount.class, null, "account");
        engine.declareObject(DeletedAccount.class, null, BackupAccount.class.getName());
        AssertObjectTest.assertNotNull((Object)engine);
        DeletedAccount acc1 = new DeletedAccount();
        acc1.setAccountId("1234");
        acc1.setAccountType("new");
        acc1.setFirst("fName");
        acc1.setLast("lName");
        acc1.setMiddle("m");
        acc1.setOfficeCode("MA");
        acc1.setRegionCode("NE");
        acc1.setStatus("active");
        acc1.setTitle("MR");
        acc1.setUsername("user1");
        try {
            engine.assertObject(acc1, null, false, true);
            AssertObjectTest.assertTrue((boolean)true);
            AssertObjectTest.assertEquals((int)1, (int)engine.getObjectCount());
            System.out.println("Number of facts: " + engine.getObjectCount());
        }
        catch (AssertException e) {
            AssertObjectTest.fail();
        }
    }
}

