/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jamocha.service.ClipsInitialData;
import org.jamocha.service.ClipsRuleset;
import org.jamocha.service.FunctionPackage;
import org.jamocha.service.ObjectModel;
import org.jamocha.service.ServiceConfiguration;
import org.jamocha.service.servlet.RuleServiceApplication;
import org.jamocha.xml.ConfigurationHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationUtility {
    private Writer writer = null;
    private String LINE_BREAK = System.getProperty("line.separator");
    private String TAB = "  ";
    private String TAGSTART = "<";
    private String TAGEND = ">";
    private int tabCount = 0;

    public ServiceConfiguration fromXml(String filename) {
        ConfigurationHandler handler = new ConfigurationHandler();
        try {
            File file = new File(filename);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(file, (DefaultHandler)handler);
            ServiceConfiguration config = handler.getServiceConfiguration();
            return config;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void toXml(ServiceConfiguration configuration, String file) {
        try {
            this.writer = new FileWriter(file);
            this.writeConfiguration(configuration);
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeConfiguration(ServiceConfiguration configuration) throws IOException {
        this.writeRuleServiceConfiguration(configuration);
    }

    protected void writeRuleServiceConfiguration(ServiceConfiguration configuration) throws IOException {
        ServiceConfiguration servConfig = configuration;
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("ruleServiceConfiguration")) + this.LINE_BREAK);
        this.pushTab();
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("applications")) + this.LINE_BREAK);
        this.pushTab();
        int i = 0;
        while (i < servConfig.getApplications().size()) {
            RuleServiceApplication app = (RuleServiceApplication)servConfig.getApplications().get(i);
            this.writeRuleServiceApplication(app);
            ++i;
        }
        this.popTab();
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagEnd("applications")) + this.LINE_BREAK);
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("serviceName")) + servConfig.getServiceName() + this.makeTagEnd("serviceName") + this.LINE_BREAK);
        this.popTab();
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagEnd("ruleServiceConfiguration")) + this.LINE_BREAK);
    }

    protected void writeRuleServiceApplication(RuleServiceApplication ruleServiceApp) throws IOException {
        int i;
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart(ruleServiceApp.getClass().getName())) + this.LINE_BREAK);
        this.pushTab();
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("applicationName")) + ruleServiceApp.getName() + this.makeTagEnd("applicationName") + this.LINE_BREAK);
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("version")) + ruleServiceApp.getVersion() + this.makeTagEnd("version") + this.LINE_BREAK);
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("models")) + this.LINE_BREAK);
        this.pushTab();
        if (ruleServiceApp.getModels() != null) {
            i = 0;
            while (i < ruleServiceApp.getModels().size()) {
                this.writeModels(ruleServiceApp.getModels().get(i));
                ++i;
            }
        }
        this.popTab();
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagEnd("models")) + this.LINE_BREAK);
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("initialData")) + this.LINE_BREAK);
        this.pushTab();
        if (ruleServiceApp.getInitialData() != null) {
            i = 0;
            while (i < ruleServiceApp.getInitialData().size()) {
                this.writeInitialData(ruleServiceApp.getInitialData().get(i));
                ++i;
            }
        }
        this.popTab();
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagEnd("initialData")) + this.LINE_BREAK);
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("functionGroups")) + this.LINE_BREAK);
        this.pushTab();
        if (ruleServiceApp.getFunctionGroups() != null) {
            i = 0;
            while (i < ruleServiceApp.getFunctionGroups().size()) {
                this.writeFunctionGroup(ruleServiceApp.getFunctionGroups().get(i));
                ++i;
            }
        }
        this.popTab();
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagEnd("functionGroups")) + this.LINE_BREAK);
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("rulesets")) + this.LINE_BREAK);
        this.pushTab();
        if (ruleServiceApp.getRulesets() != null) {
            i = 0;
            while (i < ruleServiceApp.getRulesets().size()) {
                this.writeRuleset(ruleServiceApp.getRulesets().get(i));
                ++i;
            }
        }
        this.popTab();
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagEnd("rulesets")) + this.LINE_BREAK);
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("maxPool")) + ruleServiceApp.getMaxPool() + this.makeTagEnd("maxPool") + this.LINE_BREAK);
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("minPool")) + ruleServiceApp.getMinPool() + this.makeTagEnd("minPool") + this.LINE_BREAK);
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("initialPool")) + ruleServiceApp.getInitialPool() + this.makeTagEnd("initialPool") + this.LINE_BREAK);
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagStart("currentPoolCount")) + ruleServiceApp.getCurrentPoolCount() + this.makeTagEnd("currentPoolCount") + this.LINE_BREAK);
        this.popTab();
        this.writeTabs();
        this.writer.write(String.valueOf(this.makeTagEnd(ruleServiceApp.getClass().getName())) + this.LINE_BREAK);
    }

    protected void writeModels(Object model) throws IOException {
        if (model instanceof ObjectModel) {
            ObjectModel objModel = (ObjectModel)model;
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagStart(objModel.getClass().getName())) + this.LINE_BREAK);
            this.pushTab();
            this.writeTabs();
            if (objModel.getURL() != null) {
                this.writer.write(String.valueOf(this.makeTagStart("URL")) + objModel.getURL() + this.makeTagEnd("URL") + this.LINE_BREAK);
            } else {
                this.writer.write(String.valueOf(this.makeEmptyTag("URL")) + this.LINE_BREAK);
            }
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagStart("classList")) + this.LINE_BREAK);
            this.pushTab();
            int i = 0;
            while (i < objModel.getClassList().size()) {
                String clss = (String)objModel.getClassList().get(i);
                this.writeTabs();
                this.writer.write(String.valueOf(this.makeTagStart("string")) + clss + this.makeTagEnd("string") + this.LINE_BREAK);
                ++i;
            }
            this.popTab();
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagEnd("classList")) + this.LINE_BREAK);
            this.popTab();
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagEnd(objModel.getClass().getName())) + this.LINE_BREAK);
        }
    }

    protected void writeInitialData(Object data) throws IOException {
        if (data instanceof ClipsInitialData) {
            ClipsInitialData clipsData = (ClipsInitialData)data;
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagStart(clipsData.getClass().getName())) + this.LINE_BREAK);
            this.pushTab();
            this.writeTabs();
            if (clipsData.getURL() != null) {
                this.writer.write(String.valueOf(this.makeTagStart("URL")) + clipsData.getURL() + this.makeTagEnd("URL") + this.LINE_BREAK);
            } else {
                this.writer.write(String.valueOf(this.makeEmptyTag("URL")) + this.LINE_BREAK);
            }
            this.writeTabs();
            if (clipsData.getName() != null) {
                this.writer.write(String.valueOf(this.makeTagStart("name")) + clipsData.getName() + this.makeTagEnd("name") + this.LINE_BREAK);
            } else {
                this.writer.write(String.valueOf(this.makeEmptyTag("name")) + this.LINE_BREAK);
            }
            this.popTab();
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagEnd(clipsData.getClass().getName())) + this.LINE_BREAK);
        }
    }

    protected void writeFunctionGroup(Object data) throws IOException {
        if (data instanceof FunctionPackage) {
            FunctionPackage fncPkg = (FunctionPackage)data;
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagStart(fncPkg.getClass().getName())) + this.LINE_BREAK);
            this.pushTab();
            this.writeTabs();
            if (fncPkg.getURL() != null) {
                this.writer.write(String.valueOf(this.makeTagStart("URL")) + fncPkg.getURL() + this.makeTagEnd("URL") + this.LINE_BREAK);
            } else {
                this.writer.write(String.valueOf(this.makeEmptyTag("URL")) + this.LINE_BREAK);
            }
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagStart("classNames")) + this.LINE_BREAK);
            this.pushTab();
            int i = 0;
            while (i < fncPkg.getClassNames().length) {
                String clss = fncPkg.getClassNames()[i];
                this.writeTabs();
                this.writer.write(String.valueOf(this.makeTagStart("string")) + clss + this.makeTagEnd("string") + this.LINE_BREAK);
                ++i;
            }
            this.popTab();
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagEnd("classNames")) + this.LINE_BREAK);
            this.popTab();
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagEnd(fncPkg.getClass().getName())) + this.LINE_BREAK);
        }
    }

    protected void writeRuleset(Object data) throws IOException {
        if (data instanceof ClipsRuleset) {
            ClipsRuleset clipsRuleset = (ClipsRuleset)data;
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagStart(clipsRuleset.getClass().getName())) + this.LINE_BREAK);
            this.pushTab();
            this.writeTabs();
            if (clipsRuleset.getURL() != null) {
                this.writer.write(String.valueOf(this.makeTagStart("URL")) + clipsRuleset.getURL() + this.makeTagEnd("URL") + this.LINE_BREAK);
            } else {
                this.writer.write(String.valueOf(this.makeEmptyTag("URL")) + this.LINE_BREAK);
            }
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagStart("contents")) + clipsRuleset.getContents() + this.makeTagEnd("contents") + this.LINE_BREAK);
            this.popTab();
            this.writeTabs();
            this.writer.write(String.valueOf(this.makeTagEnd(clipsRuleset.getClass().getName())) + this.LINE_BREAK);
        }
    }

    protected String makeTagStart(String name) {
        return String.valueOf(this.TAGSTART) + name + this.TAGEND;
    }

    protected String makeTagEnd(String name) {
        return String.valueOf(this.TAGSTART) + "/" + name + this.TAGEND;
    }

    protected String makeEmptyTag(String name) {
        return String.valueOf(this.TAGSTART) + name + "/" + this.TAGEND;
    }

    protected void pushTab() {
        ++this.tabCount;
    }

    protected void popTab() {
        --this.tabCount;
    }

    protected void writeTabs() {
        try {
            int i = 0;
            while (i < this.tabCount) {
                this.writer.write(this.TAB);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

