/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.xml;

import java.util.ArrayList;
import java.util.Stack;
import org.jamocha.service.ClipsInitialData;
import org.jamocha.service.ClipsRuleset;
import org.jamocha.service.FunctionPackage;
import org.jamocha.service.ObjectModel;
import org.jamocha.service.ServiceConfiguration;
import org.jamocha.service.TemplateModel;
import org.jamocha.service.servlet.RuleServiceApplication;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationHandler
extends DefaultHandler {
    public static final String APPLICATION_ELEMENT = RuleServiceApplication.class.getName();
    public static final String CLIPS_RULESET_ELEMENT = ClipsRuleset.class.getName();
    public static final String CLIPS_INITIAL_DATA_ELEMENT = ClipsInitialData.class.getName();
    public static final String FUNCTION_PACKAGE_ELEMENT = FunctionPackage.class.getName();
    public static final String OBJECT_MODEL_ELEMENT = ObjectModel.class.getName();
    public static final String TEMPLATE_MODEL_ELEMENT = TemplateModel.class.getName();
    public static final String SERVICE_CONFIGURATION_ELEMENT = ServiceConfiguration.class.getName();
    private Stack stack = new Stack();
    private Stack objectStack = new Stack();
    private RuleServiceApplication app = null;
    private ServiceConfiguration ruleServiceConfig = new ServiceConfiguration();

    public ServiceConfiguration getServiceConfiguration() {
        return this.ruleServiceConfig;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuffer buf = new StringBuffer();
        int i = start;
        while (i < start + length) {
            buf.append(ch[i]);
            ++i;
        }
        String node = (String)this.stack.peek();
        Object obj = this.objectStack.peek();
        if (obj instanceof ServiceConfiguration) {
            if (node.equals("serviceName")) {
                this.ruleServiceConfig.setServiceName(buf.toString());
            }
        } else if (obj instanceof RuleServiceApplication) {
            if (node.equals("applicationName")) {
                this.app.setName(buf.toString());
            } else if (node.equals("version")) {
                this.app.setVersion(buf.toString());
            } else if (node.equals("minPool")) {
                this.app.setMinPool(Integer.parseInt(buf.toString()));
            } else if (node.equals("maxPool")) {
                this.app.setMaxPool(Integer.parseInt(buf.toString()));
            } else if (node.equals("initialPool")) {
                this.app.setInitialPool(Integer.parseInt(buf.toString()));
            } else if (node.equals("currentPoolCount")) {
                this.app.setCurrentPoolCount(Integer.parseInt(buf.toString()));
            }
        } else if (obj instanceof ObjectModel) {
            ObjectModel objModel = (ObjectModel)obj;
            if (node.equals("string")) {
                if (objModel.getClassList() == null) {
                    objModel.setClassList(new ArrayList());
                }
                objModel.getClassList().add(buf.toString());
            } else if (node.equals("url")) {
                objModel.setURL(buf.toString());
            }
        } else if (obj instanceof ClipsRuleset) {
            ClipsRuleset clipsRuleset = (ClipsRuleset)obj;
            if (node.equals("URL")) {
                clipsRuleset.setURL(buf.toString());
            } else if (node.equals("contents")) {
                clipsRuleset.setContents(buf.toString());
            }
        } else if (obj instanceof ClipsInitialData) {
            ClipsInitialData clipsData = (ClipsInitialData)obj;
            if (node.equals("name")) {
                clipsData.setName(buf.toString());
            } else if (node.equals("url")) {
                clipsData.setURL(buf.toString());
            }
        } else if (obj instanceof FunctionPackage) {
            FunctionPackage functionPkg = (FunctionPackage)obj;
            if (node.equals("URL")) {
                functionPkg.setURL(buf.toString());
            } else if (node.equals("string")) {
                String text = buf.toString();
                if (functionPkg.getClassNames() == null) {
                    functionPkg.setClassNames(new String[0]);
                }
                String[] array = new String[functionPkg.getClassNames().length + 1];
                System.arraycopy(functionPkg.getClassNames(), 0, array, 0, functionPkg.getClassNames().length);
                array[functionPkg.getClassNames().length] = text;
                functionPkg.setClassNames(array);
            }
        }
    }

    public void endDocument() throws SAXException {
        this.stack.clear();
        this.objectStack.clear();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.stack.pop();
        if (qName.equals(OBJECT_MODEL_ELEMENT) || qName.equals(APPLICATION_ELEMENT) || qName.equals(CLIPS_INITIAL_DATA_ELEMENT) || qName.equals(CLIPS_RULESET_ELEMENT) || qName.equals(FUNCTION_PACKAGE_ELEMENT) || qName.equals(TEMPLATE_MODEL_ELEMENT) || qName.equals(SERVICE_CONFIGURATION_ELEMENT)) {
            this.objectStack.pop();
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.stack.push(qName);
        if (qName.equals(APPLICATION_ELEMENT)) {
            this.app = new RuleServiceApplication();
            if (this.ruleServiceConfig.getApplications() == null) {
                this.ruleServiceConfig.setApplications(new ArrayList());
            }
            this.ruleServiceConfig.getApplications().add(this.app);
            this.objectStack.push(this.app);
        } else if (qName.equals(FUNCTION_PACKAGE_ELEMENT)) {
            FunctionPackage funcPkg = new FunctionPackage();
            if (this.app.getFunctionGroups() == null) {
                this.app.setFunctionGroups(new ArrayList());
            }
            this.app.getFunctionGroups().add(funcPkg);
            this.objectStack.push(funcPkg);
        } else if (qName.equals(OBJECT_MODEL_ELEMENT)) {
            ObjectModel objModel = new ObjectModel();
            if (this.app.getModels() == null) {
                this.app.setModels(new ArrayList());
            }
            this.app.getModels().add(objModel);
            this.objectStack.push(objModel);
        } else if (qName.equals(CLIPS_INITIAL_DATA_ELEMENT)) {
            ClipsInitialData clipsData = new ClipsInitialData();
            if (this.app.getInitialData() == null) {
                this.app.setInitialData(new ArrayList());
            }
            this.app.getInitialData().add(clipsData);
            this.objectStack.push(clipsData);
        } else if (qName.equals(CLIPS_RULESET_ELEMENT)) {
            ClipsRuleset clipsRuleset = new ClipsRuleset();
            if (this.app.getRulesets() == null) {
                this.app.setRulesets(new ArrayList());
            }
            this.app.getRulesets().add(clipsRuleset);
            this.objectStack.push(clipsRuleset);
        } else if (qName.equals(SERVICE_CONFIGURATION_ELEMENT)) {
            this.objectStack.push(this.ruleServiceConfig);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

