/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.service.servlet;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import javax.servlet.ServletContext;
import org.jamocha.rete.Rete;
import org.jamocha.service.RuleApplication;
import org.jamocha.service.ServiceAdministration;
import org.jamocha.service.ServiceConfiguration;
import org.jamocha.service.servlet.RuleStartupService;

public class ServletServiceAdmin
implements ServiceAdministration {
    private RuleStartupService ruleService = null;
    private ServletContext servletContext = null;

    public ServletServiceAdmin(RuleStartupService service) {
        this.ruleService = service;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public RuleApplication getApplication(String applicationName, String version) {
        String key = String.valueOf(applicationName) + "::" + version;
        return (RuleApplication)this.ruleService.getRuleApplicationMap().get(key);
    }

    public int getEnginePoolCount(String ruleApplication, String version) {
        String key = String.valueOf(ruleApplication) + "::" + version;
        PriorityQueue queue = (PriorityQueue)this.ruleService.getEngineMap().get(key);
        return queue.size();
    }

    public List getEngines(String applicationName, String version) {
        String key = String.valueOf(applicationName) + "::" + version;
        PriorityQueue queue = (PriorityQueue)this.ruleService.getEngineMap().get(key);
        return new ArrayList(queue);
    }

    public List getRuleApplications() {
        return this.ruleService.getRuleApplications();
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.ruleService.getServiceConfiguration();
    }

    public void reinitialize(String ruleApplication, String version) {
        this.servletContext.log("--- Start reinitializing rule application: " + ruleApplication + " " + version);
        String key = String.valueOf(ruleApplication) + "::" + version;
        PriorityQueue<Rete> queue = (PriorityQueue<Rete>)this.ruleService.getEngineMap().remove(key);
        for (Rete engine : queue) {
            engine.close();
        }
        queue.clear();
        RuleApplication app = (RuleApplication)this.ruleService.getRuleApplicationMap().get(key);
        queue = new PriorityQueue<Rete>();
        this.ruleService.getEngineMap().put(ruleApplication, queue);
        int idx = 0;
        while (idx < app.getInitialPool()) {
            Rete engine = new Rete();
            queue.add(engine);
            app.reinitializeEngine(engine);
            ++idx;
        }
        this.servletContext.log("--- Finished reinitializing rule application: " + ruleApplication + " " + version);
    }

    public boolean reloadFunctionPackage(String ruleApplication, String version) {
        this.servletContext.log("--- Start reloading Function Package: " + ruleApplication + " " + version);
        boolean reload = false;
        String key = String.valueOf(ruleApplication) + "::" + version;
        RuleApplication app = (RuleApplication)this.ruleService.getRuleApplicationMap().get(key);
        PriorityQueue queue = (PriorityQueue)this.ruleService.getEngineMap().remove(key);
        for (Rete engine : queue) {
            reload = app.reloadFunctionGroups(engine);
            if (!reload) break;
        }
        this.servletContext.log("--- Finished reloading Function Package: " + ruleApplication + " " + version);
        return reload;
    }

    public boolean reloadInitialData(String ruleApplication, String version) {
        this.servletContext.log("--- Start reloading Initial Data: " + ruleApplication + " " + version);
        boolean reload = false;
        String key = String.valueOf(ruleApplication) + "::" + version;
        RuleApplication app = (RuleApplication)this.ruleService.getRuleApplicationMap().get(key);
        PriorityQueue queue = (PriorityQueue)this.ruleService.getEngineMap().remove(key);
        for (Rete engine : queue) {
            reload = app.reloadInitialData(engine);
            if (!reload) break;
        }
        this.servletContext.log("--- Finished reloading Initial Data: " + ruleApplication + " " + version);
        return reload;
    }

    public boolean reloadRuleset(String ruleApplication, String version) {
        this.servletContext.log("--- Start reloading Ruleset: " + ruleApplication + " " + version);
        boolean reload = false;
        String key = String.valueOf(ruleApplication) + "::" + version;
        RuleApplication app = (RuleApplication)this.ruleService.getRuleApplicationMap().get(key);
        PriorityQueue queue = (PriorityQueue)this.ruleService.getEngineMap().remove(key);
        for (Rete engine : queue) {
            reload = app.reloadRulesets(engine);
            if (!reload) break;
        }
        this.servletContext.log("--- Finished reloading Ruleset: " + ruleApplication + " " + version);
        return reload;
    }
}

