/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.service.servlet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.jamocha.rete.Rete;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.service.EngineContext;
import org.jamocha.service.servlet.RuleStartupService;

public class ServletEngineContext
implements EngineContext {
    private RuleStartupService ruleService = null;
    private Rete engine = null;
    private String applicationName = null;
    private String version = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private List objectList = new ArrayList();
    private ServletContext servletContext = null;

    protected ServletEngineContext() {
    }

    public ServletEngineContext(RuleStartupService service, Rete engine, String applicationName, String version, ServletContext servletContext) {
        this.ruleService = service;
        this.engine = engine;
        this.applicationName = applicationName;
        this.version = version;
        this.servletContext = servletContext;
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public Rete getRuleEngine() {
        return this.engine;
    }

    public void assertObject(Object data, boolean isStatic, boolean isShadowed) throws AssertException {
        try {
            this.engine.assertObject(data, null, isStatic, isShadowed);
        }
        catch (AssertException e) {
            this.servletContext.log("ServletEngineContext error asserting Object:", (Throwable)e);
            throw e;
        }
    }

    public void asssertObjects(List data, boolean isStatic, boolean isShadowed) throws AssertException {
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                this.engine.assertObject(itr.next(), null, isStatic, isShadowed);
            }
            catch (AssertException e) {
                this.servletContext.log("ServletEngineContext error asserting Object:", (Throwable)e);
                throw e;
            }
        }
    }

    public void close() {
        this.endTime = System.currentTimeMillis();
        long elapsedTime = this.endTime - this.startTime;
        int count = this.engine.getRulesFiredCount();
        this.ruleService.updateStatistics(elapsedTime, count);
        Iterator itr = this.objectList.iterator();
        while (itr.hasNext()) {
            try {
                this.engine.retractObject(itr.next());
            }
            catch (Exception e) {
                this.servletContext.log("Error closing ServletEngineContext", (Throwable)e);
            }
        }
        this.ruleService.queueEngine(this.applicationName, this.version, this.engine);
        this.engine = null;
    }

    public void executeRules() {
        this.engine.fire();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public List getObjects() {
        return this.engine.getObjects();
    }

    public void modifyObject(Object data) throws AssertException, RetractException {
        try {
            this.engine.modifyObject(data);
        }
        catch (AssertException e) {
            this.servletContext.log("ServletEngineContext error modifying Object:", (Throwable)e);
            throw e;
        }
        catch (RetractException e) {
            this.servletContext.log("ServletEngineContext error modifying Object:", (Throwable)e);
            throw e;
        }
    }

    public void modifyObjects(List data) throws AssertException, RetractException {
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                this.engine.modifyObject(itr.next());
            }
            catch (AssertException e) {
                this.servletContext.log("ServletEngineContext error modifying Object:", (Throwable)e);
                throw e;
            }
            catch (RetractException e) {
                this.servletContext.log("ServletEngineContext error modifying Object:", (Throwable)e);
                throw e;
            }
        }
    }

    public void removeObject(Object data) throws RetractException {
        try {
            this.engine.retractObject(data);
        }
        catch (RetractException e) {
            this.servletContext.log("ServletEngineContext error removing Object:", (Throwable)e);
            throw e;
        }
    }

    public void removeObjects(List data) throws RetractException {
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            try {
                this.engine.retractObject(itr.next());
            }
            catch (RetractException e) {
                this.servletContext.log("ServletEngineContext error removing Object:", (Throwable)e);
                throw e;
            }
        }
    }

    public void reset() {
        this.engine.resetObjects();
    }
}

