/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.service.servlet;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.ServletLogger;
import org.jamocha.rete.Rete;
import org.jamocha.service.EngineContext;
import org.jamocha.service.RuleApplication;
import org.jamocha.service.RuleService;
import org.jamocha.service.ServiceAdministration;
import org.jamocha.service.ServiceConfiguration;
import org.jamocha.service.servlet.ServletEngineContext;
import org.jamocha.service.servlet.ServletServiceAdmin;

public class RuleStartupService
implements ServletContextListener,
RuleService {
    public static final String CONFIGURATION_FILE = "Ruleconfig.xml";
    private long totalResponseTime = 0L;
    private long averageResponseTime = 0L;
    private long averageRulesFired = 0L;
    private long requests = 0L;
    private long totalRulesFired = 0L;
    private String serviceName = null;
    private List applications = new ArrayList();
    private Map applicationMap = new HashMap();
    private Map engineMap = new HashMap();
    protected ServiceConfiguration serviceConfiguration = null;
    private ServletServiceAdmin administration = null;
    protected ServletContext servletContext = null;

    public RuleStartupService() {
        this.applications = new ArrayList();
        this.administration = new ServletServiceAdmin(this);
    }

    public void contextDestroyed(ServletContextEvent context) {
        this.close();
    }

    public void contextInitialized(ServletContextEvent context) {
        this.servletContext = context.getServletContext();
        LogFactory.setServletContext(this.servletContext);
        this.administration.setServletContext(this.servletContext);
        this.serviceConfiguration = this.loadConfiguration();
        this.servletContext.log("--- configuration loaded from Ruleconfig.xml ---");
        this.applications = this.serviceConfiguration.getApplications();
        this.serviceName = this.serviceConfiguration.getServiceName();
        this.initialize();
        context.getServletContext().setAttribute(this.serviceName, (Object)this);
        this.servletContext.log("--- RuleService has been initialized ---");
    }

    public void close() {
        this.servletContext.log("--- Start closing RuleService ---");
        for (String key : this.engineMap.keySet()) {
            List queue = (List)this.engineMap.remove(key);
            for (Rete engine : queue) {
                engine.close();
            }
            queue.clear();
        }
        for (String key : this.applicationMap.keySet()) {
            RuleApplication app = (RuleApplication)this.applicationMap.remove(key);
            app.close();
        }
        this.applicationMap.clear();
        this.servletContext.log("--- End closing RuleService ---");
    }

    public long getAverageResponseTime() {
        return this.averageResponseTime;
    }

    public long getAverageRulesFired() {
        return this.averageRulesFired;
    }

    public EngineContext getEngine(String applicationName, String version) {
        String key = String.valueOf(applicationName) + "::" + version;
        List queue = (List)this.engineMap.get(key);
        if (queue != null) {
            Rete engine = null;
            if (queue.size() > 0 && (engine = (Rete)queue.remove(0)) != null) {
                ServletEngineContext context = new ServletEngineContext(this, engine, applicationName, version, this.servletContext);
                return context;
            }
            RuleApplication application = (RuleApplication)this.applicationMap.get(key);
            if (application.getCurrentPoolCount() < application.getMaxPool()) {
                engine = new Rete();
                application.initializeEngine(engine);
                application.setCurrentPoolCount(application.getCurrentPoolCount() + 1);
                ServletEngineContext context = new ServletEngineContext(this, engine, applicationName, version, this.servletContext);
                this.servletContext.log("New engine instance created. Current engine pool count is " + application.getCurrentPoolCount());
                return context;
            }
            this.servletContext.log("The Rule service has reached the maximum pool number. Try increasing the configuration.");
            return null;
        }
        return null;
    }

    public long getRequests() {
        return this.requests;
    }

    public List getRuleApplications() {
        return this.applications;
    }

    public ServiceAdministration getServiceAdmin() {
        return this.administration;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public long getTotalRulesFired() {
        return this.totalRulesFired;
    }

    public void initialize() {
        this.servletContext.log("--- Start initializing RuleService ---");
        int idx = 0;
        while (idx < this.applications.size()) {
            RuleApplication application = (RuleApplication)this.applications.get(idx);
            String key = String.valueOf(application.getName()) + "::" + application.getVersion();
            ArrayList<Rete> queue = new ArrayList<Rete>();
            this.applicationMap.put(key, application);
            this.engineMap.put(key, queue);
            int initialCount = application.getInitialPool();
            int c = 0;
            while (c < initialCount) {
                Rete engine = new Rete(new ServletLogger(this.servletContext));
                application.initializeEngine(engine);
                application.setCurrentPoolCount(c + 1);
                queue.add(engine);
                ++c;
            }
            ++idx;
        }
        this.servletContext.log("--- End initializing RuleService ---");
    }

    public void reinitialize() {
        this.close();
        this.initialize();
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public void updateStatistics(long time, int rulesFired) {
        ++this.requests;
        this.totalResponseTime += time;
        this.averageResponseTime = this.totalResponseTime / this.requests;
        this.totalRulesFired += (long)rulesFired;
        this.averageRulesFired = this.totalRulesFired / this.requests;
    }

    public void queueEngine(String application, String version, Rete engine) {
        String key = String.valueOf(application) + "::" + version;
        List queue = (List)this.engineMap.get(key);
        queue.add(engine);
    }

    public Map getRuleApplicationMap() {
        return this.applicationMap;
    }

    public Map getEngineMap() {
        return this.engineMap;
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public void setServiceConfiguration(ServiceConfiguration config) {
        this.serviceConfiguration = config;
    }

    protected ServiceConfiguration loadConfiguration() {
        if (this.serviceConfiguration == null) {
            XStream xstream = new XStream();
            String path = "/WEB-INF/Ruleconfig.xml";
            this.servletContext.log("Path: " + path);
            InputStream input = this.servletContext.getResourceAsStream(path);
            ServiceConfiguration config = (ServiceConfiguration)xstream.fromXML(input);
            return config;
        }
        return this.serviceConfiguration;
    }
}

