/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.service;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.rete.Rete;
import org.jamocha.service.RuleApplication;
import org.jamocha.service.RuleApplicationImpl;
import org.jamocha.service.RuleServiceImpl;
import org.jamocha.service.ServiceAdministration;
import org.jamocha.service.ServiceConfiguration;

public class ServiceAdministrationImpl
implements ServiceAdministration {
    private Logger log = LogFactory.createLogger(ServiceAdministrationImpl.class);
    private RuleServiceImpl ruleService = null;

    public ServiceAdministrationImpl(RuleServiceImpl service) {
        this.ruleService = service;
    }

    public RuleApplication getApplication(String applicationName, String version) {
        String key = String.valueOf(applicationName) + "::" + version;
        return (RuleApplication)this.ruleService.getRuleApplicationMap().get(key);
    }

    public int getEnginePoolCount(String ruleApplication, String version) {
        String key = String.valueOf(ruleApplication) + "::" + version;
        PriorityQueue queue = (PriorityQueue)this.ruleService.getEngineMap().get(key);
        return queue.size();
    }

    public List getEngines(String ruleApplication, String version) {
        String key = String.valueOf(ruleApplication) + "::" + version;
        PriorityQueue queue = (PriorityQueue)this.ruleService.getEngineMap().get(key);
        return new ArrayList(queue);
    }

    public List getRuleApplications() {
        return this.ruleService.getRuleApplications();
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.ruleService.getServiceConfiguration();
    }

    public void reinitialize(String ruleApplication, String version) {
        this.log.info("--- Start reinitializing rule application: " + ruleApplication + " " + version);
        String key = String.valueOf(ruleApplication) + "::" + version;
        PriorityQueue<Rete> queue = (PriorityQueue<Rete>)this.ruleService.getEngineMap().remove(key);
        for (Rete engine : queue) {
            engine.close();
        }
        queue.clear();
        RuleApplicationImpl app = (RuleApplicationImpl)this.ruleService.getRuleApplicationMap().get(key);
        queue = new PriorityQueue<Rete>();
        this.ruleService.getEngineMap().put(ruleApplication, queue);
        int idx = 0;
        while (idx < app.getInitialPool()) {
            Rete engine = new Rete();
            queue.add(engine);
            app.reinitializeEngine(engine);
            ++idx;
        }
        this.log.info("--- Finished reinitializing rule application: " + ruleApplication + " " + version);
    }

    public boolean reloadFunctionPackage(String ruleApplication, String version) {
        this.log.info("--- Start reloading Function Package: " + ruleApplication + " " + version);
        boolean reload = false;
        String key = String.valueOf(ruleApplication) + "::" + version;
        RuleApplicationImpl app = (RuleApplicationImpl)this.ruleService.getRuleApplicationMap().get(key);
        PriorityQueue queue = (PriorityQueue)this.ruleService.getEngineMap().remove(key);
        for (Rete engine : queue) {
            reload = app.reloadFunctionGroups(engine);
            if (!reload) break;
        }
        this.log.info("--- Finished reloading Function Package: " + ruleApplication + " " + version);
        return reload;
    }

    public boolean reloadInitialData(String ruleApplication, String version) {
        this.log.info("--- Start reloading Initial Data: " + ruleApplication + " " + version);
        boolean reload = false;
        String key = String.valueOf(ruleApplication) + "::" + version;
        RuleApplicationImpl app = (RuleApplicationImpl)this.ruleService.getRuleApplicationMap().get(key);
        PriorityQueue queue = (PriorityQueue)this.ruleService.getEngineMap().remove(key);
        for (Rete engine : queue) {
            reload = app.reloadInitialData(engine);
            if (!reload) break;
        }
        this.log.info("--- Finished reloading Initial Data: " + ruleApplication + " " + version);
        return reload;
    }

    public boolean reloadRuleset(String ruleApplication, String version) {
        this.log.info("--- Start reloading Ruleset: " + ruleApplication + " " + version);
        boolean reload = false;
        String key = String.valueOf(ruleApplication) + "::" + version;
        RuleApplicationImpl app = (RuleApplicationImpl)this.ruleService.getRuleApplicationMap().get(key);
        PriorityQueue queue = (PriorityQueue)this.ruleService.getEngineMap().remove(key);
        for (Rete engine : queue) {
            reload = app.reloadRulesets(engine);
            if (!reload) break;
        }
        this.log.info("--- Finished reloading Ruleset: " + ruleApplication + " " + version);
        return reload;
    }
}

