/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.service;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.rete.Rete;
import org.jamocha.service.EngineContext;
import org.jamocha.service.EngineContextImpl;
import org.jamocha.service.RuleApplication;
import org.jamocha.service.RuleApplicationImpl;
import org.jamocha.service.RuleService;
import org.jamocha.service.ServiceAdministration;
import org.jamocha.service.ServiceAdministrationImpl;
import org.jamocha.service.ServiceConfiguration;

public class RuleServiceImpl
implements RuleService {
    private Logger log = LogFactory.createLogger(RuleServiceImpl.class);
    private long totalResponseTime = 0L;
    private long averageResponseTime = 0L;
    private long averageRulesFired = 0L;
    private long requests = 0L;
    private long totalRulesFired = 0L;
    private String serviceName = null;
    private List applications = new ArrayList();
    private Map applicationMap = new HashMap();
    private Map engineMap = new HashMap();
    private ServiceConfiguration serviceConfiguration = null;
    private ServiceAdministration administration = null;

    public RuleServiceImpl() {
        this.applications = new ArrayList();
        this.administration = new ServiceAdministrationImpl(this);
    }

    public ServiceAdministration getServiceAdmin() {
        return this.administration;
    }

    public long getAverageResponseTime() {
        return this.averageResponseTime;
    }

    public long getAverageRulesFired() {
        return this.averageRulesFired;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public long getRequests() {
        return this.requests;
    }

    public long getTotalRulesFired() {
        return this.totalRulesFired;
    }

    public void initialize() {
        this.log.info("--- Start initializing RuleService ---");
        int idx = 0;
        while (idx < this.applications.size()) {
            RuleApplication application = (RuleApplication)this.applications.get(idx);
            String key = String.valueOf(application.getName()) + "::" + application.getVersion();
            PriorityQueue<Rete> queue = new PriorityQueue<Rete>();
            this.applicationMap.put(key, application);
            this.engineMap.put(key, queue);
            int initialCount = application.getInitialPool();
            int c = 0;
            while (c < initialCount) {
                Rete engine = new Rete();
                application.initializeEngine(engine);
                application.setCurrentPoolCount(c + 1);
                queue.add(engine);
                ++c;
            }
            ++idx;
        }
        this.log.info("--- End initializing RuleService ---");
    }

    public void reinitialize() {
        this.close();
        this.initialize();
    }

    public void close() {
        this.log.info("--- Start closing RuleService ---");
        for (String key : this.engineMap.keySet()) {
            PriorityQueue queue = (PriorityQueue)this.engineMap.remove(key);
            for (Rete engine : queue) {
                engine.close();
            }
            queue.clear();
        }
        for (String key : this.applicationMap.keySet()) {
            RuleApplicationImpl app = (RuleApplicationImpl)this.applicationMap.remove(key);
            app.close();
        }
        this.applicationMap.clear();
        this.log.info("--- End closing RuleService ---");
    }

    public EngineContext getEngine(String applicationName, String version) {
        String key = String.valueOf(applicationName) + "::" + version;
        PriorityQueue queue = (PriorityQueue)this.engineMap.get(key);
        if (queue != null) {
            Rete engine = (Rete)queue.remove();
            if (engine != null) {
                EngineContextImpl context = new EngineContextImpl(this, engine, applicationName, version);
                return context;
            }
            RuleApplication application = (RuleApplication)this.applicationMap.get(key);
            if (application.getCurrentPoolCount() < application.getMaxPool()) {
                engine = new Rete();
                application.initializeEngine(engine);
                application.setCurrentPoolCount(application.getCurrentPoolCount() + 1);
                EngineContextImpl context = new EngineContextImpl(this, engine, applicationName, version);
                return context;
            }
            return null;
        }
        return null;
    }

    public void setAverageResponseTime(long milliseconds) {
        this.averageResponseTime = milliseconds;
    }

    public void setAverageRulesFired(long average) {
        this.averageRulesFired = average;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public void setRequests(long requests) {
        this.requests = requests;
    }

    public void setTotalRulesFired(long count) {
        this.totalRulesFired = count;
    }

    public List getRuleApplications() {
        return this.applications;
    }

    public void queueEngine(String application, String version, Rete engine) {
        String key = String.valueOf(application) + "::" + version;
        PriorityQueue queue = (PriorityQueue)this.engineMap.get(key);
        queue.add(engine);
    }

    public void updateStatistics(long time, int rulesFired) {
        ++this.requests;
        this.totalResponseTime += time;
        this.averageResponseTime = this.totalResponseTime / this.requests;
        this.totalRulesFired += (long)rulesFired;
        this.averageRulesFired = this.totalRulesFired / this.requests;
    }

    public static RuleService createInstance(String filepath) {
        XStream xstream = new XStream();
        try {
            FileReader reader = new FileReader(filepath);
            ServiceConfiguration config = (ServiceConfiguration)xstream.fromXML((Reader)reader);
            RuleServiceImpl ruleService = new RuleServiceImpl();
            ruleService.applications = config.getApplications();
            ruleService.setServiceName(config.getServiceName());
            ruleService.serviceConfiguration = config;
            return ruleService;
        }
        catch (FileNotFoundException e) {
            Logger log = LogFactory.createLogger(RuleApplicationImpl.class);
            log.fatal(e);
            return null;
        }
    }

    public static void saveConfiguration(String filename, ServiceConfiguration configuration) {
        XStream xstream = new XStream();
        File output = new File(filename.substring(0, filename.lastIndexOf(47)));
        output.mkdirs();
        try {
            FileWriter writer = new FileWriter(filename);
            xstream.toXML((Object)configuration, (Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            Logger log = LogFactory.createLogger(RuleApplicationImpl.class);
            log.fatal(e);
        }
    }

    public Map getRuleApplicationMap() {
        return this.applicationMap;
    }

    public Map getEngineMap() {
        return this.engineMap;
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public void setServiceConfiguration(ServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }
}

