/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.service;

import com.thoughtworks.xstream.XStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionGroup;
import org.jamocha.rete.Rete;
import org.jamocha.service.FunctionPackage;
import org.jamocha.service.InitialData;
import org.jamocha.service.Model;
import org.jamocha.service.ObjectModel;
import org.jamocha.service.RuleApplication;
import org.jamocha.service.Ruleset;

public class RuleApplicationImpl
implements RuleApplication {
    private transient Logger log = LogFactory.createLogger(RuleApplicationImpl.class);
    private String applicationName = null;
    private String version = null;
    private List models = null;
    private List initialData = null;
    private List functionGroups = null;
    private List rulesets = new ArrayList();
    private List functionInstances = new ArrayList();
    private int minPool;
    private int maxPool;
    private int initialPool;
    private int currentPoolCount;
    private URLClassLoader classloader = null;

    public void close() {
        this.models.clear();
        this.functionGroups.clear();
        this.functionInstances.clear();
        this.rulesets.clear();
        this.initialData.clear();
        this.classloader = null;
    }

    protected URLClassLoader createURLClassLoader() {
        int idx;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.models != null) {
            idx = 0;
            while (idx < this.models.size()) {
                Model m = (Model)this.models.get(idx);
                if (m instanceof ObjectModel) {
                    ((ObjectModel)m).setRuleApplication(this);
                }
                if (m.getURLObject() != null) {
                    urls.add(m.getURLObject());
                }
                ++idx;
            }
        }
        if (this.functionGroups != null) {
            idx = 0;
            while (idx < this.functionGroups.size()) {
                FunctionPackage functionGroup = (FunctionPackage)this.functionGroups.get(idx);
                if (functionGroup.getURLObject() != null) {
                    urls.add(functionGroup.getURLObject());
                }
                ++idx;
            }
        }
        URL[] urllist = new URL[urls.size()];
        urllist = urls.toArray(urllist);
        return URLClassLoader.newInstance(urllist, ClassLoader.getSystemClassLoader());
    }

    public ClassLoader getClassLoaders() {
        return this.classloader;
    }

    public Class findClass(String className) {
        try {
            return this.classloader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            this.log.debug(e);
            return null;
        }
    }

    public boolean initializeEngine(Rete engine) {
        this.classloader = this.createURLClassLoader();
        if (this.classloader != null) {
            boolean init = true;
            init = this.loadModels(engine);
            if (init) {
                init = this.loadFunctionGroups(engine);
            }
            if (init) {
                init = this.loadRulesets(engine);
            }
            if (init) {
                init = this.loadInitialData(engine);
            }
            return init;
        }
        return false;
    }

    public boolean loadModels(Rete engine) {
        boolean success = true;
        int idx = 0;
        while (idx < this.models.size()) {
            Model m = (Model)this.models.get(idx);
            m.loadModel(engine);
            ++idx;
        }
        return success;
    }

    public boolean loadFunctionGroups(Rete engine) {
        if (this.functionInstances == null) {
            this.functionInstances = new ArrayList();
        }
        boolean success = true;
        int idx = 0;
        while (idx < this.functionGroups.size()) {
            FunctionPackage functionGroup = (FunctionPackage)this.functionGroups.get(idx);
            String[] classnames = functionGroup.getClassNames();
            int fx = 0;
            while (fx < classnames.length) {
                block10: {
                    String classname = classnames[fx];
                    try {
                        Class<?> clzz = this.classloader.loadClass(classname);
                        if (clzz == null) break block10;
                        Object data = clzz.newInstance();
                        if (data instanceof Function) {
                            Function func = (Function)data;
                            engine.declareFunction(func);
                        } else if (data instanceof FunctionGroup) {
                            FunctionGroup fGroup = (FunctionGroup)data;
                            fGroup.loadFunctions(engine);
                        }
                        this.functionInstances.add(data);
                    }
                    catch (ClassNotFoundException e) {
                        this.log.fatal(e);
                        success = false;
                        break;
                    }
                    catch (InstantiationException e) {
                        this.log.fatal(e);
                        success = false;
                        break;
                    }
                    catch (IllegalAccessException e) {
                        this.log.fatal(e);
                        success = false;
                        break;
                    }
                }
                ++fx;
            }
            ++idx;
        }
        return success;
    }

    public boolean loadRulesets(Rete engine) {
        boolean success = true;
        int idx = 0;
        while (idx < this.rulesets.size()) {
            Ruleset ruleset = (Ruleset)this.rulesets.get(idx);
            success = ruleset.loadRuleset(engine);
            if (!success) break;
            ++idx;
        }
        return success;
    }

    public boolean loadInitialData(Rete engine) {
        boolean success = true;
        int idx = 0;
        while (idx < this.initialData.size()) {
            InitialData initialData = (InitialData)this.initialData.get(idx);
            initialData.loadData(engine);
            ++idx;
        }
        return success;
    }

    public boolean reinitializeEngine(Rete engine) {
        this.close();
        if (this.classloader != null) {
            boolean init = true;
            init = this.loadModels(engine);
            if (init) {
                init = this.loadFunctionGroups(engine);
            }
            if (init) {
                init = this.loadRulesets(engine);
            }
            if (init) {
                init = this.loadInitialData(engine);
            }
            return init;
        }
        return false;
    }

    public boolean reloadFunctionGroups(Rete engine) {
        int idx = 0;
        while (idx < this.functionInstances.size()) {
            Object data = this.functionInstances.get(idx);
            if (data instanceof Function) {
                engine.removeFunction((Function)data);
            } else if (data instanceof FunctionGroup) {
                engine.removeFunctionGroup((FunctionGroup)data);
            }
            ++idx;
        }
        return this.loadFunctionGroups(engine);
    }

    public boolean reloadRulesets(Rete engine) {
        boolean reload = false;
        try {
            int idx = 0;
            while (idx < this.rulesets.size()) {
                Ruleset ruleset = (Ruleset)this.rulesets.get(idx);
                reload = ruleset.reloadRuleset(engine);
                if (!reload) break;
                ++idx;
            }
            reload = true;
        }
        catch (Exception e) {
            return false;
        }
        return reload;
    }

    public boolean reloadInitialData(Rete engine) {
        boolean reload = false;
        int idx = 0;
        while (idx < this.initialData.size()) {
            InitialData initialData = (InitialData)this.initialData.get(idx);
            reload = initialData.reloadData(engine);
            if (!reload) break;
            ++idx;
        }
        return reload;
    }

    public List getFunctionGroups() {
        return this.functionGroups;
    }

    public List getInitialData() {
        return this.initialData;
    }

    public int getInitialPool() {
        return this.initialPool;
    }

    public int getMaxPool() {
        return this.maxPool;
    }

    public int getMinPool() {
        return this.minPool;
    }

    public List getModels() {
        return this.models;
    }

    public String getName() {
        return this.applicationName;
    }

    public List getRulesets() {
        return this.rulesets;
    }

    public String getVersion() {
        return this.version;
    }

    public void setFunctionGroups(List functionGroups) {
        this.functionGroups = functionGroups;
    }

    public void setInitialData(List data) {
        this.initialData = data;
    }

    public void setInitialPool(int initial) {
        this.initialPool = initial;
    }

    public void setMaxPool(int max) {
        this.maxPool = max;
    }

    public void setMinPool(int min) {
        this.minPool = min;
    }

    public void setModels(List models) {
        this.models = models;
    }

    public void setName(String name) {
        this.applicationName = name;
    }

    public void setRulesets(List rulesets) {
        this.rulesets = rulesets;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public static void saveConfiguration(String filename, RuleApplication app) {
        XStream xstream = new XStream();
        try {
            FileWriter writer = new FileWriter(filename);
            xstream.toXML((Object)app, (Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            Logger log = LogFactory.createLogger(RuleApplicationImpl.class);
            log.fatal(e);
        }
    }

    public static RuleApplication loadConfiguration(String url) {
        XStream xstream = new XStream();
        try {
            FileReader reader = new FileReader(url);
            RuleApplication app = (RuleApplication)xstream.fromXML((Reader)reader);
            return app;
        }
        catch (FileNotFoundException e) {
            Logger log = LogFactory.createLogger(RuleApplicationImpl.class);
            log.fatal(e);
            return null;
        }
    }

    public int getCurrentPoolCount() {
        return this.currentPoolCount;
    }

    public void setCurrentPoolCount(int currentPoolCount) {
        this.currentPoolCount = currentPoolCount;
    }
}

