/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.service;

import com.thoughtworks.xstream.XStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.rete.Rete;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.service.InitialData;

public class ObjectData
implements InitialData {
    private transient Logger log = LogFactory.createLogger(ObjectData.class);
    private String name;
    private transient List data = null;
    private String url;

    public Object getData() {
        return this.data;
    }

    public void setData(List data) {
        this.data = data;
    }

    public List getObjectList() {
        return this.data;
    }

    public String getDataType() {
        return "objects";
    }

    public String getName() {
        return this.name;
    }

    public boolean loadData(Rete engine) {
        if (this.data == null) {
            this.loadFromURL();
        }
        if (this.data != null) {
            try {
                engine.assertObjects(this.data);
                return true;
            }
            catch (AssertException e) {
                this.log.info(e);
                return false;
            }
        }
        return false;
    }

    public boolean reloadData(Rete engine) {
        if (this.data != null) {
            int idx = 0;
            while (idx < this.data.size()) {
                try {
                    engine.retractObject(this.data.get(idx));
                }
                catch (RetractException e) {
                    return false;
                }
                ++idx;
            }
            try {
                engine.assertObjects(this.data);
                return true;
            }
            catch (AssertException e) {
                this.log.info(e);
                return false;
            }
        }
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private void loadFromURL() {
        if (this.url != null) {
            this.data = ObjectData.loadObjectData(this.url);
        }
    }

    public static List loadObjectData(String url) {
        block6: {
            XStream xstream = new XStream();
            try {
                if (url.startsWith("http://")) {
                    try {
                        URL urlObject = new URL(url);
                        InputStream input = urlObject.openStream();
                        List data = (List)xstream.fromXML(input);
                        return data;
                    }
                    catch (MalformedURLException e) {
                        Logger log = LogFactory.createLogger(ObjectData.class);
                        log.fatal(e);
                        break block6;
                    }
                    catch (IOException e) {
                        Logger log = LogFactory.createLogger(ObjectData.class);
                        log.fatal(e);
                        break block6;
                    }
                }
                FileReader reader = new FileReader(url);
                List data = (List)xstream.fromXML((Reader)reader);
                return data;
            }
            catch (FileNotFoundException e) {
                Logger log = LogFactory.createLogger(ObjectData.class);
                log.fatal(e);
            }
        }
        return null;
    }

    public static void saveObjectData(String filename, List data) {
        XStream xstream = new XStream();
        try {
            FileWriter writer = new FileWriter(filename);
            xstream.toXML((Object)data, (Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            Logger log = LogFactory.createLogger(ObjectData.class);
            log.fatal(e);
        }
    }
}

