/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.service;

import java.util.List;
import junit.framework.TestCase;
import org.jamocha.service.EngineContext;
import org.jamocha.service.EngineContextImpl;
import org.jamocha.service.RuleApplication;
import org.jamocha.service.RuleService;
import org.jamocha.service.RuleServiceImpl;
import org.jamocha.service.ServiceAdministration;

public class InitServiceTest
extends TestCase {
    public void testInitialize() {
        RuleService service = RuleServiceImpl.createInstance("./samples/configuration/sample_config.xml");
        service.initialize();
        InitServiceTest.assertNotNull((Object)service.getServiceName());
        InitServiceTest.assertNotNull((Object)service.getRuleApplications());
        List applications = service.getRuleApplications();
        InitServiceTest.assertTrue((applications.size() == 1 ? 1 : 0) != 0);
    }

    public void testGetEngineContext() {
        RuleService service = RuleServiceImpl.createInstance("./samples/configuration/sample_config.xml");
        service.initialize();
        InitServiceTest.assertNotNull((Object)service.getServiceName());
        InitServiceTest.assertNotNull((Object)service.getRuleApplications());
        List applications = service.getRuleApplications();
        InitServiceTest.assertTrue((applications.size() == 1 ? 1 : 0) != 0);
        EngineContext context = service.getEngine("demo", "1.0");
        InitServiceTest.assertNotNull((Object)context);
    }

    public void testReloadFunction() {
        RuleService service = RuleServiceImpl.createInstance("./samples/configuration/sample_config.xml");
        service.initialize();
        InitServiceTest.assertNotNull((Object)service.getServiceName());
        InitServiceTest.assertNotNull((Object)service.getRuleApplications());
        EngineContextImpl context = (EngineContextImpl)service.getEngine("demo", "1.0");
        List applications = service.getRuleApplications();
        RuleApplication app = (RuleApplication)applications.get(0);
        boolean reload = app.reloadFunctionGroups(context.getRuleEngine());
        InitServiceTest.assertTrue((boolean)reload);
    }

    public void testGetServiceAdmin() {
        RuleService service = RuleServiceImpl.createInstance("./samples/configuration/sample_config.xml");
        service.initialize();
        InitServiceTest.assertNotNull((Object)service.getServiceName());
        InitServiceTest.assertNotNull((Object)service.getRuleApplications());
        ServiceAdministration admin = service.getServiceAdmin();
        InitServiceTest.assertNotNull((Object)admin);
    }

    public void testReloadRuleset() {
        RuleService service = RuleServiceImpl.createInstance("./samples/configuration/sample_config.xml");
        service.initialize();
        InitServiceTest.assertNotNull((Object)service.getServiceName());
        InitServiceTest.assertNotNull((Object)service.getRuleApplications());
        ServiceAdministration admin = service.getServiceAdmin();
        InitServiceTest.assertNotNull((Object)admin);
        boolean reload = admin.reloadRuleset("demo", "1.0");
        InitServiceTest.assertTrue((boolean)reload);
    }
}

