/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.service;

import java.io.StringReader;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.parser.clips.CLIPSParser;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Function;
import org.jamocha.rete.Rete;
import org.jamocha.rule.Defrule;
import org.jamocha.service.Ruleset;

public class ClipsRuleset
implements Ruleset {
    private transient Logger log = LogFactory.createLogger(ClipsRuleset.class);
    private String contents;
    private String URL;

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public String getURL() {
        return this.URL;
    }

    public void setURL(String url) {
        this.URL = url;
    }

    public boolean loadRuleset(Rete engine) {
        if (this.log == null) {
            this.log = LogFactory.createLogger(ClipsRuleset.class);
        }
        boolean loaded = false;
        if (this.URL != null) {
            try {
                engine.loadRuleset(this.URL);
                loaded = true;
            }
            catch (Exception e) {
                this.log.fatal(e);
            }
        } else if (this.contents != null) {
            StringReader reader = new StringReader(this.contents);
            CLIPSParser parser = new CLIPSParser(engine, reader);
            Object expr = null;
            try {
                while ((expr = parser.basicExpr()) != null) {
                    if (expr instanceof Defrule) {
                        Defrule rl = (Defrule)expr;
                        engine.getRuleCompiler().addRule(rl);
                        continue;
                    }
                    if (expr instanceof Deftemplate) {
                        Deftemplate dft = (Deftemplate)expr;
                        engine.getCurrentFocus().addTemplate(dft, engine, engine.getWorkingMemory());
                        continue;
                    }
                    if (!(expr instanceof Function)) continue;
                    Function fnc = (Function)expr;
                    fnc.executeFunction(engine, null);
                }
            }
            catch (Exception e) {
                this.log.fatal(e);
            }
            loaded = true;
        }
        return loaded;
    }

    public boolean reloadRuleset(Rete engine) {
        boolean reload = false;
        engine.clearRules();
        reload = this.loadRuleset(engine);
        return reload;
    }
}

