/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.service;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.functions.io.LoadFactsFunction;
import org.jamocha.service.InitialData;

public class ClipsInitialData
implements InitialData {
    private transient Logger log = LogFactory.createLogger(ClipsInitialData.class);
    private String data = null;
    private String cacheFile = null;
    private String name = null;
    private String url = null;

    public Object getData() {
        return this.data;
    }

    public String getDataType() {
        return "deffacts";
    }

    public void setName(String text) {
        this.name = text;
    }

    public String getName() {
        return this.name;
    }

    public void setURL(String text) {
        this.url = text;
    }

    public String getURL() {
        return this.url;
    }

    public boolean loadData(Rete engine) {
        if (this.log == null) {
            this.log = LogFactory.createLogger(ClipsInitialData.class);
        }
        boolean loaded = true;
        try {
            LoadFactsFunction load = (LoadFactsFunction)engine.findFunction("load-facts");
            Parameter[] parameters = new Parameter[]{new ValueParam(11, this.cacheFile)};
            load.executeFunction(engine, parameters);
        }
        catch (Exception e) {
            loaded = false;
        }
        return loaded;
    }

    public boolean reloadData(Rete engine) {
        engine.clearFacts();
        engine.clearObjects();
        return this.loadData(engine);
    }

    protected void serializeArrayToDisk() {
        this.cacheFile = "./cache/data/" + this.name + ".bin";
        try {
            FileOutputStream fos = new FileOutputStream(this.cacheFile);
            ObjectOutputStream output = new ObjectOutputStream(fos);
            output.writeObject(this.data);
            output.close();
            this.data = null;
        }
        catch (FileNotFoundException e) {
            this.log.info(e);
        }
        catch (IOException e) {
            this.log.info(e);
        }
    }
}

