/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.sample.im;

import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import junit.framework.TestCase;
import org.jamocha.rete.Rete;
import org.jamocha.sample.im.BlockList;
import org.jamocha.sample.im.BuddyList;
import org.jamocha.sample.im.Message;
import org.jamocha.sample.im.User;

public class MessagingTest
extends TestCase {
    private Rete engine = null;

    public void testMessageFilter() {
        this.engine = this.setupEngine();
        if (this.engine == null) {
            MessagingTest.fail();
        } else {
            try {
                Message msg = this.createSpamMessage();
                this.engine.assertObject(msg, "Message", false, true);
                this.engine.fire();
                System.out.println(msg.getMessageStatus());
                List facts = this.engine.getDeffacts();
                System.out.println("number of facts - " + facts.size());
                Message msg2 = this.createSimpleMessage();
                this.engine.assertObject(msg2, "Message", false, true);
                this.engine.fire();
                System.out.println(msg2.getMessageStatus());
            }
            catch (Exception e) {
                e.printStackTrace();
                MessagingTest.fail();
            }
        }
    }

    public Rete setupEngine() {
        if (this.engine == null) {
            this.engine = new Rete();
        }
        String ruleset = "./samples/InstantMessaging/instant_messaging.clp";
        this.engine.loadRuleset(ruleset);
        User u = this.createUser();
        BuddyList buddy = this.createBuddies();
        BlockList block = this.createBlock();
        try {
            this.engine.assertObject(u, "User", false, true);
            this.engine.assertObject(buddy, "BuddyList", false, true);
            this.engine.assertObject(block, "BlockList", false, true);
            return this.engine;
        }
        catch (Exception e) {
            e.printStackTrace();
            MessagingTest.fail();
            return null;
        }
    }

    public User createUser() {
        User usr = new User();
        usr.setCity("Boston");
        usr.setCountry("US");
        usr.setFirstName("John");
        Inet4Address ip = null;
        usr.setIpAddress(ip);
        usr.setLastName("Doe");
        usr.setPostalCode("010101");
        usr.setPublicProfile(false);
        usr.setStreet1("100 Massachusetts Ave");
        usr.setUserId("john.doe");
        return usr;
    }

    public BuddyList createBuddies() {
        BuddyList buddies = new BuddyList();
        buddies.setUserId("john.doe");
        ArrayList<String> buds = new ArrayList<String>();
        buds.add("jane.doe");
        buds.add("mike.doe");
        buds.add("howard.doe");
        buds.add("bestbuds");
        buddies.setBuddies(buds);
        return buddies;
    }

    public BlockList createBlock() {
        BlockList block = new BlockList();
        block.setUserId("john.doe");
        ArrayList<String> bl = new ArrayList<String>();
        bl.add("hot.tomalie");
        bl.add("george.bush");
        bl.add("dick.cheney");
        block.setBlocked(bl);
        return block;
    }

    public Message createSimpleMessage() {
        Message msg = new Message();
        msg.setReceiverId("john.doe");
        msg.setMessageStatus(100);
        msg.setSenderId("jane.doe");
        msg.setSendTime(Calendar.getInstance());
        msg.setText("hello john");
        return msg;
    }

    public Message createSpamMessage() {
        Message msg = new Message();
        msg.setReceiverId("john.doe");
        msg.setMessageStatus(100);
        msg.setSenderId("dick.cheney");
        msg.setSendTime(Calendar.getInstance());
        msg.setText("hello john");
        return msg;
    }
}

