/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule.util;

import java.util.List;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.HashedNotEqBNode;
import org.jamocha.rete.HashedNotEqNJoin;
import org.jamocha.rete.LIANode;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.Rete;
import org.jamocha.rete.RootNode;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.Template;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Defrule;
import org.jamocha.rule.ObjectCondition;

public class TopologyCostCalculation {
    public static final int STANDARD = 1000;
    public static final int OPTIMIZED = 2000;
    private int MODE = 2000;

    public int getMode() {
        return this.MODE;
    }

    public void setMode(int m) {
        this.MODE = m;
    }

    public void calculateCost(Rete engine, Defrule r, RootNode root) {
        if (this.MODE == 1000) {
            this.calculateWithoutOptimization(engine, r, root);
        } else {
            this.calculateWithOptimization(engine, r, root);
        }
    }

    public void calculateWithoutOptimization(Rete engine, Defrule r, RootNode root) {
        ObjectCondition oc;
        Condition[] conditions = r.getConditions();
        int cost = 0;
        RuleCompiler compiler = engine.getRuleCompiler();
        Template template = null;
        int idx = 0;
        while (idx < conditions.length) {
            if (conditions[idx] instanceof ObjectCondition) {
                oc = (ObjectCondition)conditions[idx];
                template = oc.getTemplate();
                ++cost;
                ObjectTypeNode otn = compiler.getObjectTypeNode(template);
                cost += otn.getStandardCostValue();
            }
            ++idx;
        }
        idx = 0;
        while (idx < conditions.length) {
            List nodes;
            if (conditions[idx] instanceof ObjectCondition && (nodes = (oc = (ObjectCondition)conditions[idx]).getNodes()).size() > 1) {
                int idz = 1;
                while (idz < nodes.size()) {
                    BaseNode node = (BaseNode)nodes.get(idz);
                    if (node instanceof BaseAlpha && !(node instanceof LIANode)) {
                        ++cost;
                    }
                    ++idz;
                }
            }
            ++idx;
        }
        List joins = r.getJoins();
        for (BaseJoin join : joins) {
            cost += 4;
            if (!(join instanceof HashedNotEqBNode) && !(join instanceof HashedNotEqNJoin)) continue;
            ++cost;
        }
        r.setCostValue(cost);
    }

    public void calculateWithOptimization(Rete engine, Defrule r, RootNode root) {
        ObjectCondition oc;
        Condition[] conditions = r.getConditions();
        int cost = 0;
        RuleCompiler compiler = engine.getRuleCompiler();
        Template template = null;
        int idx = 0;
        while (idx < conditions.length) {
            if (conditions[idx] instanceof ObjectCondition) {
                oc = (ObjectCondition)conditions[idx];
                template = oc.getTemplate();
                ++cost;
                ObjectTypeNode otn = compiler.getObjectTypeNode(template);
                cost += otn.getOptimizedCostValue();
            }
            ++idx;
        }
        idx = 0;
        while (idx < conditions.length) {
            List nodes;
            if (conditions[idx] instanceof ObjectCondition && (nodes = (oc = (ObjectCondition)conditions[idx]).getNodes()).size() > 1) {
                int idz = 1;
                while (idz < nodes.size()) {
                    BaseNode node = (BaseNode)nodes.get(idz);
                    if (node instanceof BaseAlpha && !(node instanceof LIANode)) {
                        ++cost;
                    }
                    ++idz;
                }
            }
            ++idx;
        }
        List joins = r.getJoins();
        for (BaseJoin join : joins) {
            cost += 4;
            if (!(join instanceof HashedNotEqBNode) && !(join instanceof HashedNotEqNJoin)) continue;
            ++cost;
        }
        r.setCostValue(cost);
    }
}

