/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnValue;
import org.jamocha.rete.Slot;
import org.jamocha.rete.ValueParam;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.LiteralConstraint;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.PredicateConstraint;
import org.jamocha.rule.Rule;
import org.jamocha.rule.TestCondition;

public class GenerateFacts {
    public static ArrayList generateFacts(Rule rule, Rete engine) {
        ArrayList<Object> facts = new ArrayList<Object>();
        if (rule != null) {
            Condition[] conditions = rule.getConditions();
            int idx = 0;
            while (idx < conditions.length) {
                Condition c = conditions[idx];
                if (c instanceof ObjectCondition) {
                    Object data;
                    ObjectCondition oc = (ObjectCondition)c;
                    Deftemplate tpl = (Deftemplate)engine.findTemplate(oc.getTemplateName());
                    if (tpl.getClassName() != null) {
                        data = GenerateFacts.generateJavaFacts(oc, tpl, engine);
                        facts.add(data);
                    } else {
                        data = GenerateFacts.generateDeffact(oc, tpl, engine);
                        facts.add(data);
                    }
                } else {
                    boolean cfr_ignored_0 = c instanceof TestCondition;
                }
                ++idx;
            }
        }
        return facts;
    }

    public static Object generateJavaFacts(ObjectCondition cond, Deftemplate templ, Rete engine) {
        try {
            Class<?> theclz = Class.forName(templ.getClassName());
            Defclass dfc = engine.findDefclass(theclz);
            Object data = theclz.newInstance();
            Constraint[] cnstr = cond.getConstraints();
            int idx = 0;
            while (idx < cnstr.length) {
                Constraint cn = cnstr[idx];
                if (cn instanceof LiteralConstraint) {
                    Method meth = dfc.getWriteMethod(cn.getName());
                    meth.invoke(data, cn.getValue());
                }
                ++idx;
            }
            return data;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static Object generateDeffact(ObjectCondition cond, Deftemplate templ, Rete engine) {
        ArrayList<Slot> list = new ArrayList<Slot>();
        Constraint[] cnstr = cond.getConstraints();
        int idx = 0;
        while (idx < cnstr.length) {
            Slot s;
            Constraint cn = cnstr[idx];
            if (cn instanceof LiteralConstraint) {
                s = new Slot(cn.getName(), cn.getValue());
                list.add(s);
            } else if (cn instanceof PredicateConstraint) {
                PredicateConstraint pc = (PredicateConstraint)cn;
                Object val = GenerateFacts.generatePredicateValue(pc);
                Slot s2 = new Slot(cn.getName(), val);
                list.add(s2);
            } else if (cn instanceof BoundConstraint) {
                s = new Slot(cn.getName(), new Integer(1));
                list.add(s);
            }
            ++idx;
        }
        Fact f = templ.createFact(list, engine.nextFactId());
        return f;
    }

    public static String parseModuleName(Rule rule, Rete engine) {
        if (rule.getName().indexOf("::") > 0) {
            String text = rule.getName();
            String[] sp = text.split("::");
            return sp[0].toUpperCase();
        }
        return null;
    }

    public static Object generatePredicateValue(PredicateConstraint pc) {
        String fname = pc.getFunctionName();
        BigDecimal value = null;
        ReturnValue p = null;
        List prms = pc.getParameters();
        int idx = 0;
        while (idx < prms.size()) {
            if (prms.get(idx) instanceof ValueParam) {
                p = (Parameter)pc.getParameters().get(1);
            }
            ++idx;
        }
        if (fname.equals(">") || fname.equals(">=")) {
            value = p.getBigDecimalValue().add(new BigDecimal(1));
        } else if (fname.equals("<") || fname.equals("<=")) {
            value = p.getBigDecimalValue().subtract(new BigDecimal(1));
        }
        return value;
    }
}

