/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import java.util.ArrayList;
import java.util.List;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Constants;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.QueryCompiler;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.TestNode;
import org.jamocha.rete.compiler.CompilerProvider;
import org.jamocha.rete.compiler.ConditionCompiler;
import org.jamocha.rete.functions.ShellFunction;
import org.jamocha.rule.Condition;

public class TestCondition
implements Condition {
    protected Function func = null;
    protected TestNode node = null;
    protected ArrayList binds = new ArrayList();
    protected boolean negated = false;

    public TestCondition() {
    }

    public TestCondition(Function function) {
        this.func = function;
    }

    public Function getFunction() {
        return this.func;
    }

    public void setFunction(Function function) {
        this.func = function;
    }

    public boolean executeFunction(Rete engine, Parameter[] params) {
        ReturnVector rv = this.func.executeFunction(engine, params);
        return rv.firstReturnValue().getBooleanValue();
    }

    public boolean compare(Condition cond) {
        return false;
    }

    public void setTestNode(TestNode node) {
        this.node = node;
    }

    public TestNode getTestNode() {
        return this.node;
    }

    public List getNodes() {
        ArrayList<TestNode> n = new ArrayList<TestNode>();
        n.add(this.node);
        return n;
    }

    public void addNode(BaseNode node) {
        if (node instanceof TestNode) {
            this.node = (TestNode)node;
        }
    }

    public void addNewAlphaNodes(BaseNode node) {
        this.addNode(node);
    }

    public BaseNode getLastNode() {
        return this.node;
    }

    public List getBindConstraints() {
        return this.binds;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negate) {
        this.negated = negate;
    }

    public void clear() {
        this.node = null;
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        String pad = "  ";
        buf.append(String.valueOf(pad) + "(test (" + this.func.getName());
        if (this.func instanceof ShellFunction) {
            Parameter[] p = ((ShellFunction)this.func).getParameters();
            int idx = 0;
            while (idx < p.length) {
                if (p[idx] instanceof BoundParam) {
                    buf.append(" ?" + ((BoundParam)p[idx]).getVariableName());
                } else if (p[idx] instanceof FunctionParam) {
                    FunctionParam fp = (FunctionParam)p[idx];
                    buf.append(" " + fp.toString() + " ");
                } else if (p[idx] instanceof FunctionParam2) {
                    FunctionParam2 fp2 = (FunctionParam2)p[idx];
                    buf.append(" " + fp2.toPPString());
                } else {
                    buf.append(" " + ConversionUtils.formatSlot(p[idx].getValue()));
                }
                ++idx;
            }
        }
        buf.append(") )" + Constants.LINEBREAK);
        return buf.toString();
    }

    public ConditionCompiler getCompiler(RuleCompiler ruleCompiler) {
        CompilerProvider.getInstance(ruleCompiler);
        return CompilerProvider.testConditionCompiler;
    }

    public ConditionCompiler getCompiler(QueryCompiler ruleCompiler) {
        CompilerProvider.getInstance(ruleCompiler);
        return CompilerProvider.testConditionCompiler;
    }
}

